/*
 * Decompiled with CFR 0.152.
 */
package org.clyze.jphantom;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import org.clyze.jphantom.ClassMembers;
import org.clyze.jphantom.JPhantom;
import org.clyze.jphantom.Options;
import org.clyze.jphantom.Types;
import org.clyze.jphantom.adapters.ClassPhantomExtractor;
import org.clyze.jphantom.hier.ClassHierarchies;
import org.clyze.jphantom.hier.ClassHierarchy;
import org.clyze.jphantom.jar.JarExtender;
import org.clyze.jphantom.util.FailableClassReader;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Driver
implements Types {
    protected static final Logger logger = LoggerFactory.getLogger(Driver.class);
    private final JPhantom phantom;
    private final File outDir;

    public Driver(Path jar, Path dir) throws IOException {
        this(jar.toString(), dir.toFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Driver(String jarname, File outDir) throws IOException {
        this.outDir = outDir;
        ClassHierarchy hierarchy = ClassHierarchies.fromJar(jarname);
        ClassMembers members = ClassMembers.fromJar(jarname, hierarchy);
        JarInputStream jin = new JarInputStream(new FileInputStream(jarname));
        JarFile jarFile = new JarFile(jarname);
        HashMap<Type, ClassNode> nodes = new HashMap<Type, ClassNode>();
        try {
            JarEntry entry;
            while ((entry = jin.getNextJarEntry()) != null) {
                if (entry.isDirectory() || !entry.getName().endsWith(".class")) continue;
                logger.trace("Reading jar entry: {}", (Object)entry.getName());
                FailableClassReader reader = new FailableClassReader(jarFile.getInputStream(entry));
                reader.accept(new ClassPhantomExtractor(hierarchy, members), 0);
                ClassNode node = new ClassNode();
                reader.accept((ClassVisitor)node, 0);
                nodes.put(Type.getObjectType((String)node.name), node);
            }
        }
        finally {
            jarFile.close();
            jin.close();
        }
        this.phantom = new JPhantom(nodes, hierarchy, members);
    }

    public void run() throws IOException {
        this.phantom.run();
        this.generateFiles(this.outDir);
    }

    public List<File> generateFiles(File outDir) throws IOException {
        LinkedList<File> files = new LinkedList<File>();
        for (Map.Entry<Type, byte[]> e : this.phantom.getGenerated().entrySet()) {
            Type key = e.getKey();
            byte[] bytes = e.getValue();
            File outFile = Driver.locationOf(outDir, key);
            if (!outFile.getParentFile().isDirectory() && !outFile.getParentFile().mkdirs()) {
                throw new IOException("" + outFile.getParentFile());
            }
            try (DataOutputStream dout = new DataOutputStream(new FileOutputStream(outFile));){
                dout.write(bytes);
                dout.flush();
            }
            files.add(outFile);
        }
        return files;
    }

    public static File locationOf(File outDir, Type type) {
        return new File(outDir, type.getClassName().replace('.', '/') + ".class");
    }

    private static void deleteDirectory(Path dir) throws IOException {
        Path start = dir;
        Files.walkFileTree(start, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException e) throws IOException {
                if (e == null) {
                    Files.delete(dir);
                    return FileVisitResult.CONTINUE;
                }
                throw e;
            }
        });
    }

    private static void usage(CmdLineParser parser) {
        System.err.print("java -jar <jphantom> ");
        parser.printSingleLineUsage((OutputStream)System.err);
        System.err.println("\n");
        parser.printUsage((OutputStream)System.err);
        System.exit(1);
    }

    public static void main(String[] args) throws IOException {
        Options bean = Options.V();
        CmdLineParser parser = new CmdLineParser((Object)bean);
        try {
            parser.parseArgument(args);
        }
        catch (CmdLineException e) {
            System.err.println("Error: " + e.getMessage() + "\nUsage:\n");
            Driver.usage(parser);
        }
        if (bean.getHelp()) {
            Driver.usage(parser);
        }
        logger.debug("Options: \n{}", (Object)bean);
        Path injar = bean.getSource();
        Path outjar = bean.getTarget();
        Path classdir = bean.getDestinationDir();
        Files.deleteIfExists(outjar);
        Files.createDirectories(classdir, new FileAttribute[0]);
        Driver.deleteDirectory(classdir);
        Files.createDirectories(classdir, new FileAttribute[0]);
        new Driver(injar, classdir).run();
        logger.info("Creating complemented jar: " + outjar);
        new JarExtender(injar, outjar, classdir).extend();
        if (bean.purgeClassFiles()) {
            logger.info("Removing temporary class files...");
            Driver.deleteDirectory(classdir);
        }
    }
}

