/*
 * Decompiled with CFR 0.152.
 */
package me.coley.analysis.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import me.coley.analysis.util.SetMap;
import org.objectweb.asm.ClassReader;

public class InheritanceGraph {
    private static final String MAP_KV_SPLIT = ":::";
    private static final String MAP_VAL_SPLIT = ",";
    private final SetMap<String, String> parentsOf = new SetMap();
    private final SetMap<String, String> childrenOf = new SetMap();
    private final SetMap<String, String> parentsOfCachedAll = new SetMap();
    private final SetMap<String, String> childrenOfCachedAll = new SetMap();

    public InheritanceGraph copy() {
        InheritanceGraph copy = new InheritanceGraph();
        copy.parentsOf.putAll(this.parentsOf);
        copy.childrenOf.putAll(this.childrenOf);
        copy.parentsOfCachedAll.putAll(this.parentsOfCachedAll);
        copy.childrenOfCachedAll.putAll(this.childrenOfCachedAll);
        return copy;
    }

    public void addRtJar() throws IOException {
        Path rtJar = Paths.get(System.getProperties().getProperty("java.home"), "lib", "rt.jar");
        if (!Files.isRegularFile(rtJar, new LinkOption[0])) {
            throw new IOException("Could not locate 'rt.jar' in 'java.home' from relative path '/lib/rt.jar'");
        }
        this.addArchive(rtJar.toFile());
    }

    public void addClasspath() throws IOException {
        String path = System.getProperty("java.class.path");
        String separator = System.getProperty("path.separator");
        String localDir = System.getProperty("user.dir");
        if (path != null && !path.isEmpty()) {
            String[] items;
            for (String item : items = path.split(separator)) {
                Path filePath = Paths.get(item, new String[0]);
                boolean isAbsolute = filePath.isAbsolute();
                File file = isAbsolute ? new File(item) : Paths.get(localDir, item).toFile();
                if (!file.exists()) continue;
                if (file.isDirectory()) {
                    this.addDirectory(file);
                    continue;
                }
                if (file.getName().endsWith(".jar") || file.getName().endsWith(".jmod")) {
                    this.addArchive(file);
                    continue;
                }
                if (!file.getName().endsWith(".jmod") && !file.getName().endsWith(".jmod")) continue;
                this.addArchive(file);
            }
        }
    }

    public boolean addModulePath() {
        try {
            Class<?> c_finder = Class.forName("java.lang.module.ModuleFinder");
            Method finder_ofSystem = c_finder.getDeclaredMethod("ofSystem", new Class[0]);
            Method finder_findAll = c_finder.getDeclaredMethod("findAll", new Class[0]);
            Object result = finder_ofSystem.invoke(null, new Object[0]);
            Set refs = (Set)finder_findAll.invoke(result, new Object[0]);
            Class<?> c_ref = Class.forName("java.lang.module.ModuleReference");
            Class<?> c_reader = Class.forName("java.lang.module.ModuleReader");
            Method ref_open = c_ref.getDeclaredMethod("open", new Class[0]);
            Method reader_list = c_reader.getDeclaredMethod("list", new Class[0]);
            Method reader_read = c_reader.getDeclaredMethod("read", String.class);
            Method reader_close = c_reader.getDeclaredMethod("release", ByteBuffer.class);
            for (Object ref : refs) {
                Object reader = ref_open.invoke(ref, new Object[0]);
                Stream stream = (Stream)reader_list.invoke(reader, new Object[0]);
                stream.filter(name -> name.endsWith(".class")).forEach(name -> {
                    try {
                        Optional read = (Optional)reader_read.invoke(reader, name);
                        if (read.isPresent()) {
                            ByteBuffer buffer = (ByteBuffer)read.get();
                            byte[] bytecode = new byte[buffer.remaining()];
                            buffer.slice().get(bytecode);
                            reader_close.invoke(reader, buffer);
                            this.addClass(bytecode);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                });
            }
        }
        catch (Exception ignored) {
            return false;
        }
        return true;
    }

    public void addDirectory(File dir) throws IOException {
        this.addDirectory(dir.toPath());
    }

    public void addDirectory(Path dir) throws IOException {
        if (!Files.isDirectory(dir, new LinkOption[0])) {
            return;
        }
        Files.walkFileTree(dir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (file.toString().endsWith(".class")) {
                    InheritanceGraph.this.addClass(file.toFile());
                } else if (file.toString().endsWith(".jar") || file.toString().endsWith(".jmod")) {
                    InheritanceGraph.this.addArchive(file.toFile());
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public void addArchive(File archive) throws IOException {
        try (ZipFile jarArchive = new ZipFile(archive);){
            byte[] data = new byte[1024];
            Enumeration<? extends ZipEntry> entries = jarArchive.entries();
            while (entries.hasMoreElements()) {
                int nRead;
                ZipEntry e = entries.nextElement();
                if (!e.getName().endsWith(".class")) continue;
                InputStream is = jarArchive.getInputStream(e);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                while ((nRead = is.read(data, 0, data.length)) != -1) {
                    baos.write(data, 0, nRead);
                }
                baos.flush();
                this.addClass(baos.toByteArray());
            }
        }
    }

    public void addClass(File clazz) throws IOException {
        this.addClass(Files.readAllBytes(clazz.toPath()));
    }

    public void addClass(byte[] code) {
        HashSet<String> parents = new HashSet<String>();
        ClassReader cr = new ClassReader(code);
        String child = cr.getClassName();
        parents.add(cr.getSuperName());
        parents.addAll(Arrays.asList(cr.getInterfaces()));
        this.add(child, (Set<String>)parents);
    }

    public void add(String child, Collection<String> parents) {
        this.add(child, (Set<String>)new HashSet<String>(parents));
    }

    public void add(String child, Set<String> parents) {
        if (child == null || parents == null) {
            return;
        }
        parents.remove(null);
        this.parentsOf.put(child, (String)((Object)parents));
        parents.forEach(parent -> this.childrenOf.putSingle((String)parent, child));
    }

    public boolean hasParentLookup(String name) {
        return this.parentsOf.containsKey(name);
    }

    public boolean hasChildrenLookup(String name) {
        return this.childrenOf.containsKey(name);
    }

    public Set<String> getParents(String name) {
        Set set = (Set)this.parentsOf.get(name);
        if (set == null) {
            return Collections.emptySet();
        }
        return set;
    }

    public Set<String> getAllParents(String name) {
        Set set = (Set)this.parentsOfCachedAll.get(name);
        if (set == null) {
            set = this.getParents(name).stream().map(n -> this.getAllParents((String)n).stream()).reduce(this.getParents(name).stream(), Stream::concat).collect(Collectors.toSet());
            this.parentsOfCachedAll.put(name, (String)((Object)set));
        }
        return set;
    }

    public Set<String> getChildren(String name) {
        Set set = (Set)this.childrenOf.get(name);
        if (set == null) {
            return Collections.emptySet();
        }
        return set;
    }

    public Set<String> getAllChildren(String name) {
        Set set = (Set)this.childrenOfCachedAll.get(name);
        if (set == null) {
            set = this.getChildren(name).stream().map(n -> this.getAllChildren((String)n).stream()).reduce(this.getChildren(name).stream(), Stream::concat).collect(Collectors.toSet());
            this.childrenOfCachedAll.put(name, (String)((Object)set));
        }
        return set;
    }

    public String getCommon(String first, String second) {
        String next;
        Set<String> firstParents = this.getAllParents(first);
        firstParents.add(first);
        if (firstParents.contains(second)) {
            return second;
        }
        LinkedList<String> queue = new LinkedList<String>();
        queue.add(second);
        while ((next = (String)queue.poll()) != null && !next.equals("java/lang/Object")) {
            for (String parent : this.getParents(next)) {
                if (firstParents.contains(parent)) {
                    return parent;
                }
                if (parent.equals("java/lang/Object")) continue;
                queue.add(parent);
            }
            if (!queue.isEmpty()) continue;
        }
        return "java/lang/Object";
    }

    public String convertToString() {
        StringBuilder sb = new StringBuilder();
        this.childrenOf.forEach((parent, children) -> {
            if (parent.equals("java/lang/object")) {
                return;
            }
            sb.append((String)parent).append(MAP_KV_SPLIT).append(String.join((CharSequence)MAP_VAL_SPLIT, children)).append('\n');
        });
        return sb.toString();
    }
}

