/*
 * Decompiled with CFR 0.152.
 */
package me.coley.analysis.cfg;

import me.coley.analysis.cfg.Block;
import org.objectweb.asm.tree.MethodNode;

public class BlockHandler {
    private Block root;
    private MethodNode method;

    public void setMethod(MethodNode method) {
        this.method = method;
        this.root = this.createBlock(0, method.instructions.size() - 1);
    }

    public void add(int insnIndex, int successorIndex) {
        this.root.addSubBlock(this.createBlock(insnIndex, successorIndex));
    }

    public Block getBlockAtIndex(int index) {
        return this.root.getBlockFromIndex(index);
    }

    public Block getCommonBlock(int first, int second) {
        Block firstBlock = this.getBlockAtIndex(first);
        Block secondBlock = this.getBlockAtIndex(second);
        while (firstBlock != this.root) {
            while (firstBlock.getDepth() > secondBlock.getDepth()) {
                firstBlock = firstBlock.getParent();
            }
            if (firstBlock == secondBlock) {
                return firstBlock;
            }
            secondBlock = secondBlock.getParent();
        }
        return null;
    }

    private Block createBlock(int insnIndex, int successorIndex) {
        int start = Math.min(insnIndex, successorIndex);
        int end = Math.max(insnIndex, successorIndex);
        return Block.create(this.method, start, end);
    }
}

