/*
 * Decompiled with CFR 0.152.
 */
package me.coley.analysis;

import java.util.HashMap;
import java.util.Map;
import me.coley.analysis.OpaquePredicateType;
import me.coley.analysis.util.InternalAnalyzerHackery;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;

public class OpaqueHandler {
    private final Map<AbstractInsnNode, OpaquePredicateType> opaqueJumpMap = new HashMap<AbstractInsnNode, OpaquePredicateType>();
    private final InternalAnalyzerHackery hackery;
    private boolean hasHitOpaquePredicate;
    private boolean doesOpaqueJumpGotoDestination;
    private LabelNode destination;

    public OpaqueHandler(InternalAnalyzerHackery hackery) {
        this.hackery = hackery;
    }

    public void reset() {
        this.hasHitOpaquePredicate = false;
        this.doesOpaqueJumpGotoDestination = false;
        this.opaqueJumpMap.clear();
        this.destination = null;
    }

    public void onVisitControlFlowEdge(int insnIndex, int successorIndex) {
        if (this.hasHitOpaquePredicate && this.doesOpaqueJumpGotoDestination) {
            int fallthroughIndex = insnIndex + 1;
            this.hackery.stopAnalyzerFromGoingToFallthrough(fallthroughIndex, this.destination);
        }
        this.hasHitOpaquePredicate = false;
    }

    public void setOpaqueJump(AbstractInsnNode insn, boolean gotoDestination) {
        this.opaqueJumpMap.put(insn, gotoDestination ? OpaquePredicateType.GOTO_DESTINATION : OpaquePredicateType.FALL_THROUGH);
        this.hasHitOpaquePredicate = true;
        this.doesOpaqueJumpGotoDestination = gotoDestination;
        if (insn instanceof JumpInsnNode) {
            this.destination = ((JumpInsnNode)insn).label;
        }
    }

    public Map<AbstractInsnNode, OpaquePredicateType> getOpaqueJumpMap() {
        return this.opaqueJumpMap;
    }
}

