/*
 * Decompiled with CFR 0.152.
 */
package me.coley.analysis.value;

import java.util.List;
import me.coley.analysis.util.CollectUtils;
import me.coley.analysis.util.TypeUtil;
import me.coley.analysis.value.AbstractValue;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;

public class NullConstantValue
extends AbstractValue {
    public static Type NULL_VALUE_TYPE = TypeUtil.OBJECT_TYPE;

    protected NullConstantValue(AbstractInsnNode insn) {
        super(insn, NULL_VALUE_TYPE, null);
    }

    protected NullConstantValue(List<AbstractInsnNode> insns) {
        super(insns, NULL_VALUE_TYPE, null);
    }

    public static NullConstantValue newNull(AbstractInsnNode insn) {
        return new NullConstantValue(insn);
    }

    @Override
    public AbstractValue copy(AbstractInsnNode insn) {
        return this.onCopy(new NullConstantValue(CollectUtils.add(this.getInsns(), insn)));
    }

    @Override
    public boolean canMerge(AbstractValue other) {
        return other == this;
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    @Override
    public boolean isReference() {
        return true;
    }

    @Override
    public boolean isValueResolved() {
        return true;
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof NullConstantValue;
    }
}

