/*
 * Decompiled with CFR 0.152.
 */
package me.coley.analysis.util;

import java.util.ArrayList;
import java.util.List;
import me.coley.analysis.TypeChecker;
import me.coley.analysis.value.AbstractValue;
import me.coley.analysis.value.NullConstantValue;
import me.coley.analysis.value.UninitializedValue;
import org.objectweb.asm.Type;

public class TypeUtil {
    private static final List<Integer> SORT_ORDER = new ArrayList<Integer>();
    public static final Type OBJECT_TYPE = Type.getObjectType((String)"java/lang/Object");
    public static final Type EXCEPTION_TYPE = Type.getObjectType((String)"java/lang/Exception");

    public static boolean isPrimitiveDesc(String desc) {
        if (desc.length() != 1) {
            return false;
        }
        switch (desc.charAt(0)) {
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'Z': {
                return true;
            }
        }
        return false;
    }

    public static Type commonMathType(Type a, Type b) {
        int i2;
        if (a == null || b == null) {
            throw new IllegalStateException("Cannot find common type of a null type");
        }
        int i1 = TypeUtil.getPromotionIndex(a.getSort());
        int max = Math.max(i1, i2 = TypeUtil.getPromotionIndex(b.getSort()));
        if (max <= 8) {
            return max == i1 ? a : b;
        }
        throw new IllegalStateException("Cannot do math on non-primitive types: " + a.getDescriptor() + " & " + b.getDescriptor());
    }

    public static int sortToSize(int sort) {
        switch (sort) {
            case 7: 
            case 8: {
                return 2;
            }
        }
        return 1;
    }

    public static int getPromotionIndex(int sort) {
        return SORT_ORDER.indexOf(sort);
    }

    public static boolean isSubTypeOfOrNull(TypeChecker typeChecker, AbstractValue childValue, AbstractValue parentValue) {
        return TypeUtil.isSubTypeOfOrNull(typeChecker, childValue, parentValue.getType());
    }

    public static boolean isSubTypeOfOrNull(TypeChecker typeChecker, AbstractValue childValue, Type parent) {
        if (childValue == null) {
            return false;
        }
        if (childValue instanceof NullConstantValue && !TypeUtil.isPrimitive(parent)) {
            return true;
        }
        if (childValue == UninitializedValue.UNINITIALIZED_VALUE) {
            return false;
        }
        return TypeUtil.isSubTypeOf(typeChecker, childValue.getType(), parent);
    }

    public static boolean isSubTypeOf(TypeChecker typeChecker, Type child, Type parent) {
        boolean bothArrays;
        if (child == null) {
            return false;
        }
        if (child.equals((Object)parent)) {
            return true;
        }
        boolean bl = bothArrays = child.getSort() == 9 && parent.getSort() == 9;
        if (bothArrays) {
            child = child.getElementType();
            parent = parent.getElementType();
            if (!(child.getDimensions() == parent.getDimensions() || child.equals((Object)OBJECT_TYPE) && parent.equals((Object)OBJECT_TYPE))) {
                return false;
            }
        }
        if (parent == null) {
            return false;
        }
        if (parent.getSort() >= 1 && parent.getSort() <= 5) {
            parent = Type.INT_TYPE;
        }
        if (TypeUtil.isPrimitive(parent) && TypeUtil.isPrimitive(child)) {
            return parent.getSort() >= child.getSort();
        }
        if (!TypeUtil.isPrimitive(child) && parent.getDescriptor().equals("Ljava/lang/Object;")) {
            return true;
        }
        if (child.getSort() == parent.getSort()) {
            AbstractValue host = AbstractValue.ofDefault(null, typeChecker, parent);
            return host != null && host.canMerge(AbstractValue.ofDefault(null, typeChecker, child));
        }
        return false;
    }

    public static boolean isPrimitive(Type type) {
        return type.getSort() < 9;
    }

    static {
        SORT_ORDER.add(0);
        SORT_ORDER.add(1);
        SORT_ORDER.add(3);
        SORT_ORDER.add(4);
        SORT_ORDER.add(2);
        SORT_ORDER.add(5);
        SORT_ORDER.add(6);
        SORT_ORDER.add(8);
        SORT_ORDER.add(7);
        SORT_ORDER.add(9);
        SORT_ORDER.add(10);
    }
}

