/*
 * Decompiled with CFR 0.152.
 */
package me.coley.analysis.exception;

import java.util.List;
import me.coley.analysis.TypeChecker;
import me.coley.analysis.cfg.BlockHandler;
import me.coley.analysis.exception.ResolvableAnalyzerException;
import me.coley.analysis.exception.TypeMismatchKind;
import me.coley.analysis.util.FlowUtil;
import me.coley.analysis.util.FrameUtil;
import me.coley.analysis.util.InsnUtil;
import me.coley.analysis.util.TypeUtil;
import me.coley.analysis.value.AbstractValue;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.analysis.AnalyzerException;
import org.objectweb.asm.tree.analysis.Frame;

public class ResolvableExceptionFactory {
    private final TypeChecker typeChecker;
    private final BlockHandler blockHandler;

    public ResolvableExceptionFactory(TypeChecker typeChecker, BlockHandler blockHandler) {
        this.typeChecker = typeChecker;
        this.blockHandler = blockHandler;
    }

    public ResolvableAnalyzerException unexpectedType(Type expectedType, Type actualType, AbstractInsnNode insn, AbstractValue actualValue, TypeMismatchKind errorType) {
        switch (errorType) {
            case PUTSTATIC: {
                return new ResolvableAnalyzerException((methodNode, frames) -> {
                    Frame frame = frames[InsnUtil.index(insn)];
                    AbstractValue valueContext = FrameUtil.getTopStack((Frame<AbstractValue>)frame);
                    return TypeUtil.isSubTypeOfOrNull(this.typeChecker, valueContext, expectedType);
                }, insn, "Expected type: " + expectedType);
            }
            case GETFIELD: {
                return new ResolvableAnalyzerException((methodNode, frames) -> {
                    Frame frame = frames[InsnUtil.index(insn)];
                    AbstractValue fieldContext = FrameUtil.getTopStack((Frame<AbstractValue>)frame);
                    if (fieldContext.isNull() && FlowUtil.isNullChecked(this.blockHandler, fieldContext, insn)) {
                        return true;
                    }
                    return TypeUtil.isSubTypeOf(this.typeChecker, fieldContext.getType(), expectedType);
                }, insn, "Expected type: " + expectedType);
            }
            case RETURN: {
                return new ResolvableAnalyzerException((methodNode, frames) -> {
                    Frame frame = frames[InsnUtil.index(insn)];
                    AbstractValue returnValue = FrameUtil.getTopStack((Frame<AbstractValue>)frame);
                    return TypeUtil.isSubTypeOfOrNull(this.typeChecker, returnValue, expectedType);
                }, insn, "Incompatible return type, found '" + actualType + "', expected: " + expectedType, expectedType, actualValue);
            }
        }
        throw new IllegalStateException("Unhandled exception in factory");
    }

    public AnalyzerException unexpectedMethodHostType(Type expectedType, Type actualType, MethodInsnNode insn, AbstractValue actualValue, List<? extends AbstractValue> stackValues, TypeMismatchKind errorType) {
        Type[] args = Type.getArgumentTypes((String)insn.desc);
        Type owner = Type.getObjectType((String)insn.owner);
        return new ResolvableAnalyzerException((methodNode, frames) -> {
            Frame frame = frames[InsnUtil.index((AbstractInsnNode)insn)];
            AbstractValue methodContext = (AbstractValue)frame.getStack(frame.getStackSize() - (args.length + 1));
            if (methodContext.isNull() && FlowUtil.isNullChecked(this.blockHandler, methodContext, (AbstractInsnNode)insn)) {
                return true;
            }
            return TypeUtil.isSubTypeOf(this.typeChecker, methodContext.getType(), owner);
        }, (AbstractInsnNode)insn, "Method owner does not match type on stack");
    }

    public AnalyzerException unexpectedMethodArgType(Type expectedType, Type actualType, AbstractInsnNode insn, AbstractValue actualValue, List<? extends AbstractValue> stackValues, int argIndex, TypeMismatchKind errorType) {
        String methodDescriptor = insn.getOpcode() == 186 ? ((InvokeDynamicInsnNode)insn).desc : ((MethodInsnNode)insn).desc;
        Type[] args = Type.getArgumentTypes((String)methodDescriptor);
        if (argIndex >= args.length) {
            throw new IllegalStateException("Was given argument index >= number of actual arguments");
        }
        return new ResolvableAnalyzerException((methodNode, frames) -> {
            Frame frame = frames[InsnUtil.index(insn)];
            AbstractValue argValue = (AbstractValue)frame.getStack(frame.getStackSize() - (args.length - argIndex + 1));
            return TypeUtil.isSubTypeOfOrNull(this.typeChecker, argValue, expectedType);
        }, insn, "Argument type was \"" + actualType + "\" but expected \"" + expectedType + "\"");
    }

    public AnalyzerException unexpectedNullReference(MethodInsnNode insn, AbstractValue actualValue, List<? extends AbstractValue> stackValues, TypeMismatchKind errorType) {
        Type[] args = Type.getArgumentTypes((String)insn.desc);
        return new ResolvableAnalyzerException((method, frames) -> {
            Frame frame = frames[InsnUtil.index((AbstractInsnNode)insn)];
            AbstractValue methodContext = (AbstractValue)frame.getStack(frame.getStackSize() - (args.length + 1));
            return !methodContext.isNull();
        }, (AbstractInsnNode)insn, "Cannot call method on null reference");
    }
}

