/*
 * Decompiled with CFR 0.152.
 */
package me.coley.analysis;

import java.util.HashSet;
import java.util.Map;
import me.coley.analysis.OpaqueHandler;
import me.coley.analysis.ParameterFactory;
import me.coley.analysis.SimFrame;
import me.coley.analysis.SimInterpreter;
import me.coley.analysis.StaticGetFactory;
import me.coley.analysis.StaticInvokeFactory;
import me.coley.analysis.TypeChecker;
import me.coley.analysis.TypeResolver;
import me.coley.analysis.cfg.BlockHandler;
import me.coley.analysis.exception.ResolvableAnalyzerException;
import me.coley.analysis.exception.ResolvableExceptionFactory;
import me.coley.analysis.util.FlowUtil;
import me.coley.analysis.util.InternalAnalyzerHackery;
import me.coley.analysis.util.TypeUtil;
import me.coley.analysis.value.AbstractValue;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.analysis.Analyzer;
import org.objectweb.asm.tree.analysis.AnalyzerException;
import org.objectweb.asm.tree.analysis.Frame;
import org.objectweb.asm.tree.analysis.Interpreter;

public class SimAnalyzer
extends Analyzer<AbstractValue> {
    private final InternalAnalyzerHackery hackery = new InternalAnalyzerHackery(this);
    private final OpaqueHandler opaqueHandler = new OpaqueHandler(this.hackery);
    private final BlockHandler blockHandler = new BlockHandler();
    private final SimInterpreter interpreter;
    private boolean throwUnresolvedAnalyzerErrors = true;
    private boolean skipDeadCodeBlocks = true;
    private MethodNode method;

    public SimAnalyzer(SimInterpreter interpreter) {
        super((Interpreter)interpreter);
        this.interpreter = interpreter;
        this.interpreter.setAnalyzer(this);
        this.interpreter.setBlockHandler(this.getBlockHandler());
        this.interpreter.setExceptionFactory(this.createExceptionFactory());
        this.interpreter.setStaticInvokeFactory(this.createStaticInvokeFactory());
        this.interpreter.setStaticGetFactory(this.createStaticGetFactory());
        this.interpreter.setParameterFactory(this.createParameterFactory());
        this.interpreter.setTypeResolver(this.createTypeResolver());
        this.interpreter.setTypeChecker(this.createTypeChecker());
    }

    public Frame<AbstractValue>[] analyze(String owner, MethodNode method) throws AnalyzerException {
        this.method = method;
        this.blockHandler.setMethod(method);
        Frame[] values = super.analyze(owner, method);
        if (this.interpreter.hasReportedProblems()) {
            for (Map.Entry<AbstractInsnNode, AnalyzerException> e : new HashSet<Map.Entry<AbstractInsnNode, AnalyzerException>>(this.interpreter.getProblemInsns().entrySet())) {
                if (!(e.getValue() instanceof ResolvableAnalyzerException) || !((ResolvableAnalyzerException)e.getValue()).validate(method, values)) continue;
                this.interpreter.getProblemInsns().remove(e.getKey());
            }
            if (this.throwUnresolvedAnalyzerErrors && !this.interpreter.getProblemInsns().isEmpty()) {
                throw this.interpreter.getProblemInsns().values().iterator().next();
            }
        }
        return values;
    }

    protected SimFrame newFrame(int numLocals, int numStack) {
        return new SimFrame(numLocals, numStack);
    }

    protected SimFrame newFrame(Frame<? extends AbstractValue> frame) {
        return new SimFrame((SimFrame)frame);
    }

    protected boolean newControlFlowExceptionEdge(int insnIndex, int successorIndex) {
        this.blockHandler.add(insnIndex, successorIndex);
        return true;
    }

    protected void newControlFlowEdge(int insnIndex, int successorIndex) {
        if (FlowUtil.isFlowModifier(this.method, insnIndex, successorIndex)) {
            this.blockHandler.add(insnIndex, successorIndex);
        }
        if (this.skipDeadCodeBlocks) {
            this.opaqueHandler.onVisitControlFlowEdge(insnIndex, successorIndex);
        }
    }

    protected ResolvableExceptionFactory createExceptionFactory() {
        return new ResolvableExceptionFactory(this.createTypeChecker(), this.getBlockHandler());
    }

    protected StaticInvokeFactory createStaticInvokeFactory() {
        return null;
    }

    protected StaticGetFactory createStaticGetFactory() {
        return null;
    }

    protected ParameterFactory createParameterFactory() {
        return null;
    }

    protected TypeResolver createTypeResolver() {
        return new TypeResolver(){

            @Override
            public Type common(Type type1, Type type2) {
                return type1.equals((Object)type2) ? type1 : TypeUtil.OBJECT_TYPE;
            }

            @Override
            public Type commonException(Type type1, Type type2) {
                return type1.equals((Object)type2) ? type1 : TypeUtil.EXCEPTION_TYPE;
            }
        };
    }

    protected TypeChecker createTypeChecker() {
        return (parent, child) -> {
            try {
                Class<?> clsParent = Class.forName(parent.getClassName(), false, ClassLoader.getSystemClassLoader());
                Class<?> clsChild = Class.forName(child.getClassName(), false, ClassLoader.getSystemClassLoader());
                return clsParent.isAssignableFrom(clsChild);
            }
            catch (Throwable t) {
                return false;
            }
        };
    }

    public void setThrowUnresolvedAnalyzerErrors(boolean throwUnresolvedAnalyzerErrors) {
        this.throwUnresolvedAnalyzerErrors = throwUnresolvedAnalyzerErrors;
    }

    public void setSkipDeadCodeBlocks(boolean skipDeadCodeBlocks) {
        this.skipDeadCodeBlocks = skipDeadCodeBlocks;
    }

    public void setOpaqueJump(AbstractInsnNode insn, boolean gotoDestination) {
        if (this.skipDeadCodeBlocks) {
            this.opaqueHandler.setOpaqueJump(insn, gotoDestination);
        }
    }

    public OpaqueHandler getOpaqueHandler() {
        return this.opaqueHandler;
    }

    public BlockHandler getBlockHandler() {
        return this.blockHandler;
    }
}

