/*
 * Decompiled with CFR 0.152.
 */
package software.coley.cafedude.tree.visitor.writer;

import javax.annotation.Nonnull;
import software.coley.cafedude.classfile.ConstPool;
import software.coley.cafedude.classfile.Descriptor;
import software.coley.cafedude.classfile.annotation.ClassElementValue;
import software.coley.cafedude.classfile.annotation.ElementValue;
import software.coley.cafedude.classfile.annotation.PrimitiveElementValue;
import software.coley.cafedude.classfile.annotation.Utf8ElementValue;
import software.coley.cafedude.classfile.constant.ConstRef;
import software.coley.cafedude.classfile.constant.CpClass;
import software.coley.cafedude.classfile.constant.CpDouble;
import software.coley.cafedude.classfile.constant.CpEntry;
import software.coley.cafedude.classfile.constant.CpFieldRef;
import software.coley.cafedude.classfile.constant.CpFloat;
import software.coley.cafedude.classfile.constant.CpInt;
import software.coley.cafedude.classfile.constant.CpInterfaceMethodRef;
import software.coley.cafedude.classfile.constant.CpInvokeDynamic;
import software.coley.cafedude.classfile.constant.CpLong;
import software.coley.cafedude.classfile.constant.CpMethodHandle;
import software.coley.cafedude.classfile.constant.CpMethodRef;
import software.coley.cafedude.classfile.constant.CpMethodType;
import software.coley.cafedude.classfile.constant.CpModule;
import software.coley.cafedude.classfile.constant.CpNameType;
import software.coley.cafedude.classfile.constant.CpPackage;
import software.coley.cafedude.classfile.constant.CpString;
import software.coley.cafedude.classfile.constant.CpUtf8;
import software.coley.cafedude.tree.Constant;
import software.coley.cafedude.tree.Handle;

public class Symbols {
    protected final ConstPool pool;

    public Symbols(@Nonnull ConstPool pool) {
        this.pool = pool;
    }

    CpUtf8 newUtf8(@Nonnull String value) {
        return this.newSym(new CpUtf8(value));
    }

    CpClass newClass(@Nonnull String type) {
        return this.newSym(new CpClass(this.newUtf8(type)));
    }

    CpNameType newNameType(@Nonnull String name, @Nonnull Descriptor type) {
        return this.newSym(new CpNameType(this.newUtf8(name), this.newUtf8(type.getDescriptor())));
    }

    CpFieldRef newField(@Nonnull String owner, @Nonnull String name, @Nonnull Descriptor type) {
        return this.newSym(new CpFieldRef(this.newClass(owner), this.newNameType(name, type)));
    }

    CpMethodRef newMethod(@Nonnull String owner, @Nonnull String name, @Nonnull Descriptor type) {
        return this.newSym(new CpMethodRef(this.newClass(owner), this.newNameType(name, type)));
    }

    CpInterfaceMethodRef newInterfaceMethod(@Nonnull String owner, @Nonnull String name, @Nonnull Descriptor type) {
        return this.newSym(new CpInterfaceMethodRef(this.newClass(owner), this.newNameType(name, type)));
    }

    CpMethodHandle newHandle(@Nonnull Handle handle) {
        return this.newSym(new CpMethodHandle((byte)handle.getTag().ordinal(), (ConstRef)this.newMethod(handle.getOwner(), handle.getName(), handle.getDescriptor())));
    }

    CpInvokeDynamic newInvokeDynamic(int bootstrapMethodIndex, @Nonnull CpNameType nameAndTypeIndex) {
        return this.newSym(new CpInvokeDynamic(bootstrapMethodIndex, nameAndTypeIndex));
    }

    CpPackage newPackage(@Nonnull String exportPackage) {
        return this.newSym(new CpPackage(this.newUtf8(exportPackage)));
    }

    CpModule newModule(@Nonnull String module) {
        return this.newSym(new CpModule(this.newUtf8(module)));
    }

    @Nonnull
    <T extends CpEntry> T newSym(T entry) {
        int index = this.pool.indexOf(entry);
        if (index != -1) {
            CpEntry value = this.pool.get(index);
            if (value == null) {
                throw new IllegalStateException("Symbol at index " + index + " was null");
            }
            return (T)value;
        }
        this.pool.add(entry);
        return entry;
    }

    @Nonnull
    CpEntry newConstant(@Nonnull Constant value) {
        switch (value.getType()) {
            case STRING: {
                return this.newSym(new CpString(this.newUtf8((String)value.getValue())));
            }
            case BOOLEAN: 
            case BYTE: 
            case CHAR: 
            case SHORT: 
            case INT: {
                return this.newSym(new CpInt(((Integer)value.getValue()).intValue()));
            }
            case LONG: {
                return this.newSym(new CpLong(((Long)value.getValue()).longValue()));
            }
            case FLOAT: {
                return this.newSym(new CpFloat(((Float)value.getValue()).floatValue()));
            }
            case DOUBLE: {
                return this.newSym(new CpDouble(((Double)value.getValue()).doubleValue()));
            }
            case DESCRIPTOR: {
                Descriptor descriptor = (Descriptor)value.getValue();
                switch (descriptor.getKind()) {
                    case METHOD: {
                        CpUtf8 descriptorIndex = this.newUtf8(descriptor.getDescriptor());
                        return this.newSym(new CpMethodType(descriptorIndex));
                    }
                    case OBJECT: 
                    case ARRAY: {
                        CpUtf8 descriptorIndex = this.newUtf8(descriptor.getDescriptor());
                        return this.newSym(new CpClass(descriptorIndex));
                    }
                    case PRIMITIVE: {
                        throw new IllegalStateException("Cannot create constant for primitive descriptor");
                    }
                    case ILLEGAL: {
                        throw new IllegalStateException("Cannot create constant for illegal descriptor");
                    }
                }
            }
            case HANDLE: {
                Handle handle = (Handle)value.getValue();
                return this.newHandle(handle);
            }
        }
        throw new IllegalStateException("Unknown constant type: " + (Object)((Object)value.getType()));
    }

    @Nonnull
    ElementValue newElementValue(@Nonnull Constant value) {
        char tag = ' ';
        Object entry = value.getType().equals((Object)Constant.Type.STRING) ? this.newUtf8((String)value.getValue()) : this.newConstant(value);
        switch (value.getType()) {
            case BOOLEAN: {
                tag = 'Z';
                break;
            }
            case BYTE: {
                tag = 'B';
                break;
            }
            case CHAR: {
                tag = 'C';
                break;
            }
            case SHORT: {
                tag = 'S';
                break;
            }
            case INT: {
                tag = 'I';
                break;
            }
            case LONG: {
                tag = 'J';
                break;
            }
            case FLOAT: {
                tag = 'F';
                break;
            }
            case DOUBLE: {
                tag = 'D';
                break;
            }
            case STRING: {
                return new Utf8ElementValue('s', (CpUtf8)entry);
            }
            case DESCRIPTOR: {
                Descriptor descriptor = (Descriptor)value.getValue();
                switch (descriptor.getKind()) {
                    case OBJECT: 
                    case ARRAY: {
                        return new ClassElementValue('c', (CpUtf8)entry);
                    }
                    case METHOD: {
                        throw new IllegalStateException("Cannot create element value for method descriptor");
                    }
                    case PRIMITIVE: {
                        throw new IllegalStateException("Cannot create element value for primitive descriptor");
                    }
                    case ILLEGAL: {
                        throw new IllegalStateException("Cannot create element value for illegal descriptor");
                    }
                }
            }
            default: {
                throw new IllegalArgumentException("Invalid constant type: " + (Object)((Object)value.getType()));
            }
        }
        return new PrimitiveElementValue(tag, entry);
    }
}

