/*
 * Decompiled with CFR 0.152.
 */
package software.coley.cafedude.tree.visitor.writer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import software.coley.cafedude.classfile.Method;
import software.coley.cafedude.classfile.annotation.Annotation;
import software.coley.cafedude.classfile.attribute.AnnotationDefaultAttribute;
import software.coley.cafedude.classfile.attribute.Attribute;
import software.coley.cafedude.classfile.attribute.ExceptionsAttribute;
import software.coley.cafedude.classfile.attribute.MethodParametersAttribute;
import software.coley.cafedude.classfile.attribute.ParameterAnnotationsAttribute;
import software.coley.cafedude.classfile.constant.CpClass;
import software.coley.cafedude.classfile.constant.CpUtf8;
import software.coley.cafedude.tree.visitor.AnnotationDefaultVisitor;
import software.coley.cafedude.tree.visitor.AnnotationVisitor;
import software.coley.cafedude.tree.visitor.CodeVisitor;
import software.coley.cafedude.tree.visitor.MethodVisitor;
import software.coley.cafedude.tree.visitor.writer.AnnotationDefaultWriter;
import software.coley.cafedude.tree.visitor.writer.AnnotationWriter;
import software.coley.cafedude.tree.visitor.writer.CodeWriter;
import software.coley.cafedude.tree.visitor.writer.DeclarationWriter;
import software.coley.cafedude.tree.visitor.writer.Symbols;

public class MethodWriter
extends DeclarationWriter
implements MethodVisitor {
    private final List<Attribute> attributes = new ArrayList<Attribute>();
    private final List<CpClass> exceptions = new ArrayList<CpClass>();
    private final List<MethodParametersAttribute.Parameter> parameters = new ArrayList<MethodParametersAttribute.Parameter>();
    private final Map<Integer, List<Annotation>> visibleParameterAnnotations = new HashMap<Integer, List<Annotation>>();
    private final Map<Integer, List<Annotation>> invisibleParameterAnnotations = new HashMap<Integer, List<Annotation>>();
    private final Consumer<Method> callback;
    private final Method method;

    MethodWriter(Symbols symbols, int access, CpUtf8 name, CpUtf8 descriptor, Consumer<Method> callback) {
        super(symbols);
        this.method = new Method(this.attributes, access, name, descriptor);
        this.callback = callback;
    }

    @Override
    public void visitThrows(@Nonnull String type) {
        this.exceptions.add(this.symbols.newClass(type));
    }

    @Override
    public void visitParameter(@Nonnull String name, int access) {
        this.parameters.add(new MethodParametersAttribute.Parameter(access, this.symbols.newUtf8(name)));
    }

    @Override
    public AnnotationVisitor visitParameterAnnotation(int parameter, @Nonnull String type, boolean visible) {
        return new AnnotationWriter(this.symbols, values -> {
            Annotation annotation = new Annotation(this.symbols.newUtf8(type), values);
            Map<Integer, List<Annotation>> map = visible ? this.visibleParameterAnnotations : this.invisibleParameterAnnotations;
            map.computeIfAbsent(parameter, k -> new ArrayList()).add(annotation);
        });
    }

    @Override
    @Nonnull
    public CodeVisitor visitCode() {
        return new CodeWriter(this.symbols, this.attributes::add);
    }

    @Override
    @Nonnull
    public AnnotationDefaultVisitor visitAnnotationDefault() {
        return new AnnotationDefaultWriter(this.symbols, value -> this.attributes.add((Attribute)new AnnotationDefaultAttribute(this.symbols.newUtf8("AnnotationDefault"), value)));
    }

    @Override
    public void visitMethodEnd() {
        super.visitDeclarationEnd();
        if (!this.exceptions.isEmpty()) {
            this.attributes.add((Attribute)new ExceptionsAttribute(this.symbols.newUtf8("Exceptions"), this.exceptions));
        }
        if (!this.parameters.isEmpty()) {
            this.attributes.add((Attribute)new MethodParametersAttribute(this.symbols.newUtf8("MethodParameters"), this.parameters));
        }
        if (!this.visibleParameterAnnotations.isEmpty()) {
            this.attributes.add((Attribute)new ParameterAnnotationsAttribute(this.symbols.newUtf8("RuntimeVisibleParameterAnnotations"), this.visibleParameterAnnotations, true));
        }
        if (!this.invisibleParameterAnnotations.isEmpty()) {
            this.attributes.add((Attribute)new ParameterAnnotationsAttribute(this.symbols.newUtf8("RuntimeInvisibleParameterAnnotations"), this.invisibleParameterAnnotations, false));
        }
        this.callback.accept(this.method);
    }
}

