/*
 * Decompiled with CFR 0.152.
 */
package software.coley.cafedude.tree.insn;

import java.util.List;
import javax.annotation.Nonnull;
import software.coley.cafedude.classfile.Descriptor;
import software.coley.cafedude.tree.Constant;
import software.coley.cafedude.tree.Handle;
import software.coley.cafedude.tree.insn.Insn;
import software.coley.cafedude.tree.insn.InsnKind;

public class InvokeDynamicInsn
extends Insn {
    private String name;
    private Descriptor descriptor;
    private Handle bootstrapMethod;
    private List<Constant> bootstrapArguments;

    public InvokeDynamicInsn(@Nonnull String name, @Nonnull Descriptor descriptor, @Nonnull Handle bootstrapMethod, @Nonnull List<Constant> bootstrapArguments) {
        super(InsnKind.INVOKE_DYNAMIC, 186);
        this.name = name;
        this.descriptor = descriptor;
        this.bootstrapMethod = bootstrapMethod;
        this.bootstrapArguments = bootstrapArguments;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    public void setName(@Nonnull String name) {
        this.name = name;
    }

    @Nonnull
    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(@Nonnull Descriptor descriptor) {
        this.descriptor = descriptor;
    }

    @Nonnull
    public Handle getBootstrapMethod() {
        return this.bootstrapMethod;
    }

    public void setBootstrapMethod(@Nonnull Handle bootstrapMethod) {
        this.bootstrapMethod = bootstrapMethod;
    }

    @Nonnull
    public List<Constant> getBootstrapArguments() {
        return this.bootstrapArguments;
    }

    public void setBootstrapArguments(@Nonnull List<Constant> bootstrapArguments) {
        this.bootstrapArguments = bootstrapArguments;
    }

    @Override
    public int size() {
        return 5;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("invokedynamic(").append('\n');
        sb.append("  ").append(this.bootstrapMethod).append('\n');
        sb.append("  ").append(this.name).append(' ').append(this.descriptor.getDescriptor()).append('\n');
        for (Constant constant : this.bootstrapArguments) {
            sb.append("  ").append(constant).append('\n');
        }
        sb.append(')');
        return sb.toString();
    }
}

