/*
 * Decompiled with CFR 0.152.
 */
package software.coley.cafedude.tree.insn;

import javax.annotation.Nonnull;
import software.coley.cafedude.tree.insn.InsnKind;
import software.coley.cafedude.util.OpcodeUtil;

public class Insn {
    protected static final int LABEL_INSN_OPCODE = -1;
    private final int opcode;
    private final InsnKind kind;

    public Insn(@Nonnull InsnKind kind, int opcode) {
        this.opcode = opcode;
        this.kind = kind;
    }

    public int getOpcode() {
        return this.opcode;
    }

    @Nonnull
    public InsnKind getKind() {
        return this.kind;
    }

    public int size() {
        return 1;
    }

    public String toString() {
        return OpcodeUtil.getOpcodeName((int)this.opcode);
    }

    @Nonnull
    public static Insn nop() {
        return new Insn(InsnKind.NOP, 0);
    }

    @Nonnull
    public static Insn monitor(int opcode) {
        return new Insn(InsnKind.MONITOR, opcode);
    }

    @Nonnull
    public static Insn athrow() {
        return new Insn(InsnKind.THROW, 191);
    }
}

