/*
 * Decompiled with CFR 0.152.
 */
package software.coley.cafedude.transform;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import software.coley.cafedude.classfile.ClassFile;
import software.coley.cafedude.classfile.Method;
import software.coley.cafedude.classfile.attribute.CodeAttribute;
import software.coley.cafedude.classfile.attribute.LineNumberTableAttribute;
import software.coley.cafedude.classfile.attribute.LocalVariableTableAttribute;
import software.coley.cafedude.classfile.instruction.Instruction;
import software.coley.cafedude.classfile.instruction.IntOperandInstruction;
import software.coley.cafedude.classfile.instruction.LookupSwitchInstruction;
import software.coley.cafedude.classfile.instruction.TableSwitchInstruction;
import software.coley.cafedude.transform.Transformer;
import software.coley.cafedude.tree.Label;

public class LabelTransformer
extends Transformer {
    private final Map<Method, TreeMap<Integer, Label>> labels = new HashMap<Method, TreeMap<Integer, Label>>();
    private final Map<Method, TreeMap<Integer, Instruction>> instructions = new HashMap<Method, TreeMap<Integer, Instruction>>();

    public LabelTransformer(ClassFile clazz) {
        super(clazz);
    }

    public void transform() {
        for (Method method : this.clazz.getMethods()) {
            CodeAttribute ca = (CodeAttribute)method.getAttribute(CodeAttribute.class);
            if (ca == null) continue;
            LineNumberTableAttribute lnta = (LineNumberTableAttribute)ca.getAttribute(LineNumberTableAttribute.class);
            LocalVariableTableAttribute lvta = (LocalVariableTableAttribute)ca.getAttribute(LocalVariableTableAttribute.class);
            List insns = ca.getInstructions();
            TreeMap<Integer, Label> labels = new TreeMap<Integer, Label>();
            TreeMap<Integer, Instruction> instructions = new TreeMap<Integer, Instruction>();
            labels.put(0, new Label(0));
            for (CodeAttribute.ExceptionTableEntry exceptionTableEntry : ca.getExceptionTable()) {
                int start = exceptionTableEntry.getStartPc();
                int end = exceptionTableEntry.getEndPc();
                int handler = exceptionTableEntry.getHandlerPc();
                labels.computeIfAbsent(start, Label::new);
                labels.computeIfAbsent(end, Label::new);
                labels.computeIfAbsent(handler, Label::new);
            }
            int pos = 0;
            for (Instruction insn : insns) {
                int offset;
                int opcode = insn.getOpcode();
                if (opcode >= 153 && opcode <= 168 || opcode >= 198 && opcode <= 201) {
                    IntOperandInstruction ioi = (IntOperandInstruction)insn;
                    int offset2 = ioi.getOperand();
                    int target = pos + offset2;
                    labels.computeIfAbsent(target, Label::new);
                } else if (opcode == 170) {
                    TableSwitchInstruction tsi = (TableSwitchInstruction)insn;
                    List offsets = tsi.getOffsets();
                    Iterator iterator = offsets.iterator();
                    while (iterator.hasNext()) {
                        offset = (Integer)iterator.next();
                        labels.computeIfAbsent(pos + offset, Label::new);
                    }
                    labels.computeIfAbsent(pos + tsi.getDefault(), Label::new);
                } else if (opcode == 171) {
                    LookupSwitchInstruction lsi = (LookupSwitchInstruction)insn;
                    List offsets = lsi.getOffsets();
                    Iterator iterator = offsets.iterator();
                    while (iterator.hasNext()) {
                        offset = (Integer)iterator.next();
                        labels.computeIfAbsent(pos + offset, Label::new);
                    }
                    labels.computeIfAbsent(pos + lsi.getDefault(), Label::new);
                }
                instructions.put(pos, insn);
                int insnSize = insn.computeSize();
                pos += insnSize;
            }
            labels.put(pos, new Label(pos));
            if (lnta != null) {
                for (LineNumberTableAttribute.LineEntry entry : lnta.getEntries()) {
                    Label lab = labels.computeIfAbsent(entry.getStartPc(), Label::new);
                    lab.addLineNumber(entry.getLine());
                }
            }
            if (lvta != null) {
                for (LocalVariableTableAttribute.VarEntry entry : lvta.getEntries()) {
                    int start = entry.getStartPc();
                    int end = entry.getStartPc() + entry.getLength();
                    labels.computeIfAbsent(start, Label::new);
                    labels.computeIfAbsent(end, Label::new);
                }
            }
            this.labels.put(method, labels);
            this.instructions.put(method, instructions);
        }
    }

    public TreeMap<Integer, Label> getLabels(Method method) {
        return this.labels.get(method);
    }

    public TreeMap<Integer, Instruction> getInstructions(Method method) {
        return this.instructions.get(method);
    }
}

