/*
 * Decompiled with CFR 0.152.
 */
package me.coley.cafedude.io;

import java.util.ArrayList;
import java.util.List;
import me.coley.cafedude.classfile.ClassFile;
import me.coley.cafedude.classfile.ConstPool;
import me.coley.cafedude.classfile.Field;
import me.coley.cafedude.classfile.Method;
import me.coley.cafedude.classfile.attribute.Attribute;

public class ClassBuilder {
    private final ConstPool pool = new ConstPool();
    private final List<Attribute> attributes = new ArrayList<Attribute>();
    private final List<Integer> interfaces = new ArrayList<Integer>();
    private final List<Field> fields = new ArrayList<Field>();
    private final List<Method> methods = new ArrayList<Method>();
    private int versionMajor;
    private int versionMinor;
    private int access;
    private int classIndex;
    private int superIndex;

    public boolean isOakVersion() {
        return this.versionMajor == 45 && this.versionMinor <= 2 || this.versionMajor < 45;
    }

    public boolean isAnnotation() {
        return (this.access & 0x2000) != 0;
    }

    public ConstPool getPool() {
        return this.pool;
    }

    public int getVersionMajor() {
        return this.versionMajor;
    }

    public void setVersionMajor(int versionMajor) {
        this.versionMajor = versionMajor;
    }

    public int getVersionMinor() {
        return this.versionMinor;
    }

    public void setVersionMinor(int versionMinor) {
        this.versionMinor = versionMinor;
    }

    public int getAccess() {
        return this.access;
    }

    public void setAccess(int access) {
        this.access = access;
    }

    public void setClassIndex(int classIndex) {
        this.classIndex = classIndex;
    }

    public void setSuperIndex(int superIndex) {
        this.superIndex = superIndex;
    }

    public void addInterface(int interfaceIndex) {
        this.interfaces.add(interfaceIndex);
    }

    public void addField(Field field) {
        this.fields.add(field);
    }

    public void addMethod(Method method) {
        this.methods.add(method);
    }

    public void addAttribute(Attribute attribute) {
        this.attributes.add(attribute);
    }

    public ClassFile build() {
        return new ClassFile(this.versionMinor, this.versionMajor, this.pool, this.access, this.classIndex, this.superIndex, this.interfaces, this.fields, this.methods, this.attributes);
    }
}

