/*
 * Decompiled with CFR 0.152.
 */
package me.coley.cafedude.io;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Iterator;
import me.coley.cafedude.InvalidClassException;
import me.coley.cafedude.classfile.ClassFile;
import me.coley.cafedude.classfile.attribute.AnnotationDefaultAttribute;
import me.coley.cafedude.classfile.attribute.AnnotationsAttribute;
import me.coley.cafedude.classfile.attribute.Attribute;
import me.coley.cafedude.classfile.attribute.BootstrapMethodsAttribute;
import me.coley.cafedude.classfile.attribute.CodeAttribute;
import me.coley.cafedude.classfile.attribute.ConstantValueAttribute;
import me.coley.cafedude.classfile.attribute.DebugExtensionAttribute;
import me.coley.cafedude.classfile.attribute.DefaultAttribute;
import me.coley.cafedude.classfile.attribute.EnclosingMethodAttribute;
import me.coley.cafedude.classfile.attribute.ExceptionsAttribute;
import me.coley.cafedude.classfile.attribute.InnerClassesAttribute;
import me.coley.cafedude.classfile.attribute.LineNumberTableAttribute;
import me.coley.cafedude.classfile.attribute.LocalVariableTableAttribute;
import me.coley.cafedude.classfile.attribute.LocalVariableTypeTableAttribute;
import me.coley.cafedude.classfile.attribute.ModuleAttribute;
import me.coley.cafedude.classfile.attribute.NestHostAttribute;
import me.coley.cafedude.classfile.attribute.NestMembersAttribute;
import me.coley.cafedude.classfile.attribute.ParameterAnnotationsAttribute;
import me.coley.cafedude.classfile.attribute.PermittedClassesAttribute;
import me.coley.cafedude.classfile.attribute.RecordAttribute;
import me.coley.cafedude.classfile.attribute.SignatureAttribute;
import me.coley.cafedude.classfile.attribute.SourceFileAttribute;
import me.coley.cafedude.classfile.attribute.StackMapTableAttribute;
import me.coley.cafedude.classfile.constant.ConstPoolEntry;
import me.coley.cafedude.classfile.constant.CpUtf8;
import me.coley.cafedude.io.AnnotationWriter;

public class AttributeWriter {
    private final ClassFile clazz;

    public AttributeWriter(ClassFile clazz) {
        this.clazz = clazz;
    }

    public byte[] writeAttribute(Attribute attribute) throws IOException, InvalidClassException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(baos);
        if (attribute instanceof DefaultAttribute) {
            DefaultAttribute dflt = (DefaultAttribute)attribute;
            out.writeShort(dflt.getNameIndex());
            out.writeInt(dflt.getData().length);
            out.write(dflt.getData());
        } else {
            String attrName;
            ConstPoolEntry cpName = this.clazz.getCp(attribute.getNameIndex());
            if (!(cpName instanceof CpUtf8)) {
                throw new InvalidClassException("Attribute name index does not point to CP_UTF8");
            }
            out.writeShort(attribute.getNameIndex());
            out.writeInt(attribute.computeInternalLength());
            switch (attrName = ((CpUtf8)cpName).getText()) {
                case "BootstrapMethods": {
                    BootstrapMethodsAttribute bsms = (BootstrapMethodsAttribute)attribute;
                    out.writeShort(bsms.getBootstrapMethods().size());
                    for (BootstrapMethodsAttribute.BootstrapMethod bsm : bsms.getBootstrapMethods()) {
                        out.writeShort(bsm.getBsmMethodref());
                        out.writeShort(bsm.getArgs().size());
                        for (int arg : bsm.getArgs()) {
                            out.writeShort(arg);
                        }
                    }
                    break;
                }
                case "CharacterRangeTable": {
                    break;
                }
                case "Code": {
                    CodeAttribute code = (CodeAttribute)attribute;
                    out.writeShort(code.getMaxStack());
                    out.writeShort(code.getMaxLocals());
                    out.writeInt(code.getCode().length);
                    out.write(code.getCode());
                    out.writeShort(code.getExceptionTable().size());
                    for (CodeAttribute.ExceptionTableEntry tableEntry : code.getExceptionTable()) {
                        out.writeShort(tableEntry.getStartPc());
                        out.writeShort(tableEntry.getEndPc());
                        out.writeShort(tableEntry.getHandlerPc());
                        out.writeShort(tableEntry.getCatchTypeIndex());
                    }
                    out.writeShort(code.getAttributes().size());
                    for (Attribute subAttribute : code.getAttributes()) {
                        out.write(this.writeAttribute(subAttribute));
                    }
                    break;
                }
                case "ConstantValue": {
                    out.writeShort(((ConstantValueAttribute)attribute).getConstantValueIndex());
                    break;
                }
                case "CompilationID": {
                    break;
                }
                case "Deprecated": 
                case "Synthetic": {
                    break;
                }
                case "EnclosingMethod": {
                    EnclosingMethodAttribute enclosingMethodAttribute = (EnclosingMethodAttribute)attribute;
                    out.writeShort(enclosingMethodAttribute.getClassIndex());
                    out.writeShort(enclosingMethodAttribute.getMethodIndex());
                    break;
                }
                case "Exceptions": {
                    ExceptionsAttribute exceptionsAttribute = (ExceptionsAttribute)attribute;
                    out.writeShort(exceptionsAttribute.getExceptionIndexTable().size());
                    for (int index : exceptionsAttribute.getExceptionIndexTable()) {
                        out.writeShort(index);
                    }
                    break;
                }
                case "InnerClasses": {
                    InnerClassesAttribute innerClassesAttribute = (InnerClassesAttribute)attribute;
                    out.writeShort(innerClassesAttribute.getInnerClasses().size());
                    for (InnerClassesAttribute.InnerClass ic : innerClassesAttribute.getInnerClasses()) {
                        out.writeShort(ic.getInnerClassInfoIndex());
                        out.writeShort(ic.getOuterClassInfoIndex());
                        out.writeShort(ic.getInnerNameIndex());
                        out.writeShort(ic.getInnerClassAccessFlags());
                    }
                    break;
                }
                case "LineNumberTable": {
                    LineNumberTableAttribute lineNumbers = (LineNumberTableAttribute)attribute;
                    out.writeShort(lineNumbers.getEntries().size());
                    for (LineNumberTableAttribute.LineEntry entry : lineNumbers.getEntries()) {
                        out.writeShort(entry.getStartPc());
                        out.writeShort(entry.getLine());
                    }
                    break;
                }
                case "LocalVariableTable": {
                    LocalVariableTableAttribute varTable = (LocalVariableTableAttribute)attribute;
                    out.writeShort(varTable.getEntries().size());
                    for (LocalVariableTableAttribute.VarEntry entry : varTable.getEntries()) {
                        out.writeShort(entry.getStartPc());
                        out.writeShort(entry.getLength());
                        out.writeShort(entry.getNameIndex());
                        out.writeShort(entry.getDescIndex());
                        out.writeShort(entry.getIndex());
                    }
                    break;
                }
                case "LocalVariableTypeTable": {
                    LocalVariableTypeTableAttribute typeTable = (LocalVariableTypeTableAttribute)attribute;
                    out.writeShort(typeTable.getEntries().size());
                    for (LocalVariableTypeTableAttribute.VarTypeEntry entry : typeTable.getEntries()) {
                        out.writeShort(entry.getStartPc());
                        out.writeShort(entry.getLength());
                        out.writeShort(entry.getNameIndex());
                        out.writeShort(entry.getSignatureIndex());
                        out.writeShort(entry.getIndex());
                    }
                    break;
                }
                case "MethodParameters": {
                    break;
                }
                case "Module": {
                    ModuleAttribute moduleAttribute = (ModuleAttribute)attribute;
                    out.writeShort(moduleAttribute.getModuleIndex());
                    out.writeShort(moduleAttribute.getFlags());
                    out.writeShort(moduleAttribute.getVersionIndex());
                    out.writeShort(moduleAttribute.getRequires().size());
                    for (ModuleAttribute.Requires requires : moduleAttribute.getRequires()) {
                        out.writeShort(requires.getIndex());
                        out.writeShort(requires.getFlags());
                        out.writeShort(requires.getVersionIndex());
                    }
                    out.writeShort(moduleAttribute.getExports().size());
                    for (ModuleAttribute.Exports exports : moduleAttribute.getExports()) {
                        out.writeShort(exports.getIndex());
                        out.writeShort(exports.getFlags());
                        out.writeShort(exports.getToIndices().size());
                        for (int i : exports.getToIndices()) {
                            out.writeShort(i);
                        }
                    }
                    out.writeShort(moduleAttribute.getOpens().size());
                    for (ModuleAttribute.Opens opens : moduleAttribute.getOpens()) {
                        out.writeShort(opens.getIndex());
                        out.writeShort(opens.getFlags());
                        out.writeShort(opens.getToIndices().size());
                        for (int i : opens.getToIndices()) {
                            out.writeShort(i);
                        }
                    }
                    out.writeShort(moduleAttribute.getUses().size());
                    Iterator<Object> entry = moduleAttribute.getUses().iterator();
                    while (entry.hasNext()) {
                        int i = (Integer)entry.next();
                        out.writeShort(i);
                    }
                    out.writeShort(moduleAttribute.getProvides().size());
                    for (ModuleAttribute.Provides provides : moduleAttribute.getProvides()) {
                        out.writeShort(provides.getIndex());
                        out.writeShort(provides.getWithIndices().size());
                        for (int i : provides.getWithIndices()) {
                            out.writeShort(i);
                        }
                    }
                    break;
                }
                case "ModuleHashes": {
                    break;
                }
                case "ModuleMainClass": {
                    break;
                }
                case "ModulePackages": {
                    break;
                }
                case "ModuleResolution": {
                    break;
                }
                case "ModuleTarget": {
                    break;
                }
                case "NestHost": {
                    NestHostAttribute nestHost = (NestHostAttribute)attribute;
                    out.writeShort(nestHost.getHostClassIndex());
                    break;
                }
                case "NestMembers": {
                    NestMembersAttribute nestMembers = (NestMembersAttribute)attribute;
                    out.writeShort(nestMembers.getMemberClassIndices().size());
                    for (int classIndex : nestMembers.getMemberClassIndices()) {
                        out.writeShort(classIndex);
                    }
                    break;
                }
                case "Record": {
                    RecordAttribute recordAttribute = (RecordAttribute)attribute;
                    out.writeShort(recordAttribute.getComponents().size());
                    for (RecordAttribute.RecordComponent component : recordAttribute.getComponents()) {
                        out.writeShort(component.getNameIndex());
                        out.writeShort(component.getDescIndex());
                        out.writeShort(component.getAttributes().size());
                        for (Attribute subAttribute : component.getAttributes()) {
                            out.write(this.writeAttribute(subAttribute));
                        }
                    }
                    break;
                }
                case "RuntimeVisibleAnnotations": 
                case "RuntimeInvisibleAnnotations": {
                    new AnnotationWriter(out).writeAnnotations((AnnotationsAttribute)attribute);
                    break;
                }
                case "RuntimeVisibleParameterAnnotations": 
                case "RuntimeInvisibleParameterAnnotations": {
                    new AnnotationWriter(out).writeParameterAnnotations((ParameterAnnotationsAttribute)attribute);
                    break;
                }
                case "RuntimeVisibleTypeAnnotations": 
                case "RuntimeInvisibleTypeAnnotations": {
                    new AnnotationWriter(out).writeTypeAnnotations((AnnotationsAttribute)attribute);
                    break;
                }
                case "AnnotationDefault": {
                    new AnnotationWriter(out).writeAnnotationDefault((AnnotationDefaultAttribute)attribute);
                    break;
                }
                case "PermittedSubclasses": {
                    PermittedClassesAttribute permittedClasses = (PermittedClassesAttribute)attribute;
                    out.writeShort(permittedClasses.getClasses().size());
                    for (int classIndex : permittedClasses.getClasses()) {
                        out.writeShort(classIndex);
                    }
                    break;
                }
                case "Signature": {
                    SignatureAttribute signatureAttribute = (SignatureAttribute)attribute;
                    out.writeShort(signatureAttribute.getSignatureIndex());
                    break;
                }
                case "SourceDebugExtension": {
                    DebugExtensionAttribute debugExtension = (DebugExtensionAttribute)attribute;
                    out.write(debugExtension.getDebugExtension());
                    break;
                }
                case "SourceFile": {
                    SourceFileAttribute sourceFileAttribute = (SourceFileAttribute)attribute;
                    out.writeShort(sourceFileAttribute.getSourceFileNameIndex());
                    break;
                }
                case "SourceID": {
                    break;
                }
                case "StackMapTable": {
                    StackMapTableAttribute stackMapTable = (StackMapTableAttribute)attribute;
                    this.writeStackMapTable(out, stackMapTable);
                    break;
                }
            }
        }
        return baos.toByteArray();
    }

    private void writeVerificationType(DataOutputStream out, StackMapTableAttribute.TypeInfo type) throws IOException {
        out.writeByte(type.getTag());
        if (type instanceof StackMapTableAttribute.ObjectVariableInfo) {
            StackMapTableAttribute.ObjectVariableInfo objVar = (StackMapTableAttribute.ObjectVariableInfo)type;
            out.writeShort(objVar.classIndex);
        } else if (type instanceof StackMapTableAttribute.UninitializedVariableInfo) {
            StackMapTableAttribute.UninitializedVariableInfo uninitVar = (StackMapTableAttribute.UninitializedVariableInfo)type;
            out.writeShort(uninitVar.offset);
        }
    }

    private void writeStackMapTable(DataOutputStream out, StackMapTableAttribute stackMapTable) throws IOException {
        out.writeShort(stackMapTable.frames.size());
        for (StackMapTableAttribute.StackMapFrame frame : stackMapTable.frames) {
            StackMapTableAttribute.StackMapFrame sameLocals;
            out.writeByte(frame.getFrameType());
            if (frame instanceof StackMapTableAttribute.SameLocalsOneStackItem) {
                sameLocals = (StackMapTableAttribute.SameLocalsOneStackItem)frame;
                this.writeVerificationType(out, sameLocals.stack);
                continue;
            }
            if (frame instanceof StackMapTableAttribute.SameLocalsOneStackItemExtended) {
                sameLocals = (StackMapTableAttribute.SameLocalsOneStackItemExtended)frame;
                out.writeShort(((StackMapTableAttribute.SameLocalsOneStackItemExtended)sameLocals).offsetDelta);
                this.writeVerificationType(out, ((StackMapTableAttribute.SameLocalsOneStackItemExtended)sameLocals).stack);
                continue;
            }
            if (frame instanceof StackMapTableAttribute.ChopFrame) {
                StackMapTableAttribute.ChopFrame chopFrame = (StackMapTableAttribute.ChopFrame)frame;
                out.writeShort(chopFrame.offsetDelta);
                continue;
            }
            if (frame instanceof StackMapTableAttribute.SameFrameExtended) {
                StackMapTableAttribute.SameFrameExtended sameFrame = (StackMapTableAttribute.SameFrameExtended)frame;
                out.writeShort(sameFrame.offsetDelta);
                continue;
            }
            if (frame instanceof StackMapTableAttribute.AppendFrame) {
                StackMapTableAttribute.AppendFrame appendFrame = (StackMapTableAttribute.AppendFrame)frame;
                out.writeShort(appendFrame.offsetDelta);
                for (StackMapTableAttribute.TypeInfo type : appendFrame.additionalLocals) {
                    this.writeVerificationType(out, type);
                }
                continue;
            }
            if (!(frame instanceof StackMapTableAttribute.FullFrame)) continue;
            StackMapTableAttribute.FullFrame fullFrame = (StackMapTableAttribute.FullFrame)frame;
            out.writeShort(fullFrame.offsetDelta);
            out.writeShort(fullFrame.locals.size());
            for (StackMapTableAttribute.TypeInfo type : fullFrame.locals) {
                this.writeVerificationType(out, type);
            }
            out.writeShort(fullFrame.stack.size());
            for (StackMapTableAttribute.TypeInfo type : fullFrame.stack) {
                this.writeVerificationType(out, type);
            }
        }
    }
}

