/*
 * Decompiled with CFR 0.152.
 */
package me.coley.cafedude.io;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import me.coley.cafedude.classfile.ConstPool;
import me.coley.cafedude.classfile.attribute.AnnotationDefaultAttribute;
import me.coley.cafedude.classfile.attribute.AnnotationsAttribute;
import me.coley.cafedude.classfile.attribute.Attribute;
import me.coley.cafedude.classfile.attribute.AttributeVersions;
import me.coley.cafedude.classfile.attribute.BootstrapMethodsAttribute;
import me.coley.cafedude.classfile.attribute.CodeAttribute;
import me.coley.cafedude.classfile.attribute.ConstantValueAttribute;
import me.coley.cafedude.classfile.attribute.DebugExtensionAttribute;
import me.coley.cafedude.classfile.attribute.DefaultAttribute;
import me.coley.cafedude.classfile.attribute.DeprecatedAttribute;
import me.coley.cafedude.classfile.attribute.EnclosingMethodAttribute;
import me.coley.cafedude.classfile.attribute.ExceptionsAttribute;
import me.coley.cafedude.classfile.attribute.InnerClassesAttribute;
import me.coley.cafedude.classfile.attribute.LineNumberTableAttribute;
import me.coley.cafedude.classfile.attribute.LocalVariableTableAttribute;
import me.coley.cafedude.classfile.attribute.LocalVariableTypeTableAttribute;
import me.coley.cafedude.classfile.attribute.ModuleAttribute;
import me.coley.cafedude.classfile.attribute.NestHostAttribute;
import me.coley.cafedude.classfile.attribute.NestMembersAttribute;
import me.coley.cafedude.classfile.attribute.ParameterAnnotationsAttribute;
import me.coley.cafedude.classfile.attribute.PermittedClassesAttribute;
import me.coley.cafedude.classfile.attribute.RecordAttribute;
import me.coley.cafedude.classfile.attribute.SignatureAttribute;
import me.coley.cafedude.classfile.attribute.SourceFileAttribute;
import me.coley.cafedude.classfile.attribute.StackMapTableAttribute;
import me.coley.cafedude.classfile.attribute.SyntheticAttribute;
import me.coley.cafedude.classfile.constant.CpUtf8;
import me.coley.cafedude.io.AnnotationReader;
import me.coley.cafedude.io.AttributeContext;
import me.coley.cafedude.io.ClassBuilder;
import me.coley.cafedude.io.ClassFileReader;
import me.coley.cafedude.io.IndexableByteStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttributeReader {
    private static final Logger logger = LoggerFactory.getLogger(AttributeReader.class);
    private final IndexableByteStream is;
    private final ClassFileReader reader;
    private final ClassBuilder builder;
    private final int expectedContentLength;
    private final int nameIndex;

    public AttributeReader(ClassFileReader reader, ClassBuilder builder, DataInputStream is) throws IOException {
        this.reader = reader;
        this.builder = builder;
        this.nameIndex = is.readUnsignedShort();
        this.expectedContentLength = is.readInt();
        byte[] subsection = new byte[this.expectedContentLength];
        is.readFully(subsection);
        this.is = new IndexableByteStream(subsection);
    }

    public Attribute readAttribute(AttributeContext context) throws IOException {
        try {
            Attribute attribute = this.read(context);
            if (attribute == null) {
                return null;
            }
            int read = this.is.getIndex();
            if (read != this.expectedContentLength) {
                String name = ((CpUtf8)this.builder.getPool().get(this.nameIndex)).getText();
                logger.debug("Invalid '{}' on {}, claimed to be {} bytes, but was {}", new Object[]{name, context.name(), this.expectedContentLength, read});
                return null;
            }
            return attribute;
        }
        catch (Exception ex) {
            if (this.reader.doDropEofAttributes()) {
                if (this.nameIndex < this.builder.getPool().size()) {
                    String name = ((CpUtf8)this.builder.getPool().get(this.nameIndex)).getText();
                    logger.debug("Invalid '{}' on {}, EOF thrown when parsing attribute, expected {} bytes", new Object[]{name, context.name(), this.expectedContentLength});
                } else {
                    logger.debug("Invalid attribute on {}, invalid attribute name index", (Object)context.name());
                }
                return null;
            }
            throw ex;
        }
    }

    private Attribute read(AttributeContext context) throws IOException {
        int introducedAt;
        ConstPool pool = this.builder.getPool();
        String name = pool.getUtf(this.nameIndex);
        if (this.reader.doDropForwardVersioned() && (introducedAt = AttributeVersions.getIntroducedVersion(name)) > this.builder.getVersionMajor()) {
            logger.debug("Found '{}' on {} in class version {}, min supported is {}", new Object[]{name, context.name(), this.builder.getVersionMajor(), introducedAt});
            return null;
        }
        switch (name) {
            case "Code": {
                return this.readCode();
            }
            case "ConstantValue": {
                return this.readConstantValue();
            }
            case "Deprecated": {
                return new DeprecatedAttribute(this.nameIndex);
            }
            case "EnclosingMethod": {
                return this.readEnclosingMethod();
            }
            case "Exceptions": {
                return this.readExceptions();
            }
            case "InnerClasses": {
                return this.readInnerClasses();
            }
            case "NestHost": {
                return this.readNestHost();
            }
            case "NestMembers": {
                return this.readNestMembers();
            }
            case "SourceDebugExtension": {
                return this.readSourceDebugExtension();
            }
            case "RuntimeInvisibleAnnotations": 
            case "RuntimeVisibleAnnotations": {
                return this.readAnnotations(context);
            }
            case "RuntimeInvisibleParameterAnnotations": 
            case "RuntimeVisibleParameterAnnotations": {
                return this.readParameterAnnotations(context);
            }
            case "RuntimeInvisibleTypeAnnotations": 
            case "RuntimeVisibleTypeAnnotations": {
                return this.readTypeAnnotations(context);
            }
            case "AnnotationDefault": {
                return this.readAnnotationDefault(context);
            }
            case "Synthetic": {
                return this.readSynthetic();
            }
            case "BootstrapMethods": {
                return this.readBoostrapMethods();
            }
            case "Signature": {
                return this.readSignature();
            }
            case "SourceFile": {
                return this.readSourceFile();
            }
            case "Module": {
                return this.readModule();
            }
            case "StackMapTable": {
                return this.readStackMapTable();
            }
            case "LineNumberTable": {
                return this.readLineNumbers();
            }
            case "LocalVariableTable": {
                return this.readLocalVariables();
            }
            case "LocalVariableTypeTable": {
                return this.readLocalVariableTypess();
            }
            case "PermittedSubclasses": {
                return this.readPermittedClasses();
            }
            case "Record": {
                return this.readRecord();
            }
        }
        if (this.expectedContentLength < 2) {
            logger.debug("Invalid attribute, its content length <= 1");
            this.is.skipBytes(this.expectedContentLength);
            return null;
        }
        this.is.skipBytes(this.expectedContentLength);
        return new DefaultAttribute(this.nameIndex, this.is.getBuffer());
    }

    private RecordAttribute readRecord() throws IOException {
        ArrayList<RecordAttribute.RecordComponent> components = new ArrayList<RecordAttribute.RecordComponent>();
        int count = this.is.readUnsignedShort();
        for (int i = 0; i < count; ++i) {
            int nameIndex = this.is.readUnsignedShort();
            int descIndex = this.is.readUnsignedShort();
            int numAttributes = this.is.readUnsignedShort();
            ArrayList<Attribute> attributes = new ArrayList<Attribute>();
            for (int x = 0; x < numAttributes; ++x) {
                Attribute attr = new AttributeReader(this.reader, this.builder, this.is).readAttribute(AttributeContext.ATTRIBUTE);
                if (attr == null) continue;
                attributes.add(attr);
            }
            components.add(new RecordAttribute.RecordComponent(nameIndex, descIndex, attributes));
        }
        return new RecordAttribute(this.nameIndex, components);
    }

    private PermittedClassesAttribute readPermittedClasses() throws IOException {
        ArrayList<Integer> entries = new ArrayList<Integer>();
        int count = this.is.readUnsignedShort();
        for (int i = 0; i < count; ++i) {
            int index = this.is.readUnsignedShort();
            entries.add(index);
        }
        return new PermittedClassesAttribute(this.nameIndex, entries);
    }

    private LocalVariableTypeTableAttribute readLocalVariableTypess() throws IOException {
        ArrayList<LocalVariableTypeTableAttribute.VarTypeEntry> entries = new ArrayList<LocalVariableTypeTableAttribute.VarTypeEntry>();
        int count = this.is.readUnsignedShort();
        for (int i = 0; i < count; ++i) {
            int startPc = this.is.readUnsignedShort();
            int length = this.is.readUnsignedShort();
            int name = this.is.readUnsignedShort();
            int sig = this.is.readUnsignedShort();
            int index = this.is.readUnsignedShort();
            entries.add(new LocalVariableTypeTableAttribute.VarTypeEntry(startPc, length, name, sig, index));
        }
        return new LocalVariableTypeTableAttribute(this.nameIndex, entries);
    }

    private LocalVariableTableAttribute readLocalVariables() throws IOException {
        ArrayList<LocalVariableTableAttribute.VarEntry> entries = new ArrayList<LocalVariableTableAttribute.VarEntry>();
        int count = this.is.readUnsignedShort();
        for (int i = 0; i < count; ++i) {
            int startPc = this.is.readUnsignedShort();
            int length = this.is.readUnsignedShort();
            int name = this.is.readUnsignedShort();
            int desc = this.is.readUnsignedShort();
            int index = this.is.readUnsignedShort();
            entries.add(new LocalVariableTableAttribute.VarEntry(startPc, length, name, desc, index));
        }
        return new LocalVariableTableAttribute(this.nameIndex, entries);
    }

    private LineNumberTableAttribute readLineNumbers() throws IOException {
        ArrayList<LineNumberTableAttribute.LineEntry> entries = new ArrayList<LineNumberTableAttribute.LineEntry>();
        int count = this.is.readUnsignedShort();
        for (int i = 0; i < count; ++i) {
            int offset = this.is.readUnsignedShort();
            int line = this.is.readUnsignedShort();
            entries.add(new LineNumberTableAttribute.LineEntry(offset, line));
        }
        return new LineNumberTableAttribute(this.nameIndex, entries);
    }

    private ModuleAttribute readModule() throws IOException {
        int moduleIndex = this.is.readUnsignedShort();
        int flags = this.is.readUnsignedShort();
        int versionIndex = this.is.readUnsignedShort();
        ArrayList<ModuleAttribute.Requires> requires = new ArrayList<ModuleAttribute.Requires>();
        int count = this.is.readUnsignedShort();
        for (int i = 0; i < count; ++i) {
            int reqIndex = this.is.readUnsignedShort();
            int reqFlags = this.is.readUnsignedShort();
            int reqVersion = this.is.readUnsignedShort();
            requires.add(new ModuleAttribute.Requires(reqIndex, reqFlags, reqVersion));
        }
        ArrayList<ModuleAttribute.Exports> exports = new ArrayList<ModuleAttribute.Exports>();
        count = this.is.readUnsignedShort();
        for (int i = 0; i < count; ++i) {
            int expIndex = this.is.readUnsignedShort();
            int expFlags = this.is.readUnsignedShort();
            int expCount = this.is.readUnsignedShort();
            ArrayList<Integer> indices = new ArrayList<Integer>();
            for (int j = 0; j < expCount; ++j) {
                indices.add(this.is.readUnsignedShort());
            }
            exports.add(new ModuleAttribute.Exports(expIndex, expFlags, indices));
        }
        ArrayList<ModuleAttribute.Opens> opens = new ArrayList<ModuleAttribute.Opens>();
        count = this.is.readUnsignedShort();
        for (int i = 0; i < count; ++i) {
            int openIndex = this.is.readUnsignedShort();
            int openFlags = this.is.readUnsignedShort();
            int openCount = this.is.readUnsignedShort();
            ArrayList<Integer> indices = new ArrayList<Integer>();
            for (int j = 0; j < openCount; ++j) {
                indices.add(this.is.readUnsignedShort());
            }
            opens.add(new ModuleAttribute.Opens(openIndex, openFlags, indices));
        }
        ArrayList<Integer> uses = new ArrayList<Integer>();
        count = this.is.readUnsignedShort();
        for (int i = 0; i < count; ++i) {
            uses.add(this.is.readUnsignedShort());
        }
        ArrayList<ModuleAttribute.Provides> provides = new ArrayList<ModuleAttribute.Provides>();
        count = this.is.readUnsignedShort();
        for (int i = 0; i < count; ++i) {
            int prvIndex = this.is.readUnsignedShort();
            int prvCount = this.is.readUnsignedShort();
            ArrayList<Integer> indices = new ArrayList<Integer>();
            for (int j = 0; j < prvCount; ++j) {
                indices.add(this.is.readUnsignedShort());
            }
            provides.add(new ModuleAttribute.Provides(prvIndex, indices));
        }
        return new ModuleAttribute(this.nameIndex, moduleIndex, flags, versionIndex, requires, exports, opens, uses, provides);
    }

    private SignatureAttribute readSignature() throws IOException {
        int signatureIndex = this.is.readUnsignedShort();
        return new SignatureAttribute(this.nameIndex, signatureIndex);
    }

    private SourceFileAttribute readSourceFile() throws IOException {
        int sourceFileNameIndex = this.is.readUnsignedShort();
        return new SourceFileAttribute(this.nameIndex, sourceFileNameIndex);
    }

    private EnclosingMethodAttribute readEnclosingMethod() throws IOException {
        int classIndex = this.is.readUnsignedShort();
        int methodIndex = this.is.readUnsignedShort();
        return new EnclosingMethodAttribute(this.nameIndex, classIndex, methodIndex);
    }

    private ExceptionsAttribute readExceptions() throws IOException {
        int numberOfExceptionIndices = this.is.readUnsignedShort();
        ArrayList<Integer> exceptionIndexTable = new ArrayList<Integer>();
        for (int i = 0; i < numberOfExceptionIndices; ++i) {
            exceptionIndexTable.add(this.is.readUnsignedShort());
        }
        return new ExceptionsAttribute(this.nameIndex, exceptionIndexTable);
    }

    private InnerClassesAttribute readInnerClasses() throws IOException {
        int numberOfInnerClasses = this.is.readUnsignedShort();
        ArrayList<InnerClassesAttribute.InnerClass> innerClasses = new ArrayList<InnerClassesAttribute.InnerClass>();
        for (int i = 0; i < numberOfInnerClasses; ++i) {
            int innerClassInfoIndex = this.is.readUnsignedShort();
            int outerClassInfoIndex = this.is.readUnsignedShort();
            int innerNameIndex = this.is.readUnsignedShort();
            int innerClassAccessFlags = this.is.readUnsignedShort();
            innerClasses.add(new InnerClassesAttribute.InnerClass(innerClassInfoIndex, outerClassInfoIndex, innerNameIndex, innerClassAccessFlags));
        }
        return new InnerClassesAttribute(this.nameIndex, innerClasses);
    }

    private NestHostAttribute readNestHost() throws IOException {
        if (this.expectedContentLength != 2) {
            logger.debug("Found NestHost with illegal content length: {} != 2", (Object)this.expectedContentLength);
            return null;
        }
        int hostClassIndex = this.is.readUnsignedShort();
        return new NestHostAttribute(this.nameIndex, hostClassIndex);
    }

    private NestMembersAttribute readNestMembers() throws IOException {
        int count = this.is.readUnsignedShort();
        ArrayList<Integer> memberClassIndices = new ArrayList<Integer>();
        for (int i = 0; i < count; ++i) {
            int classIndex = this.is.readUnsignedShort();
            memberClassIndices.add(classIndex);
        }
        return new NestMembersAttribute(this.nameIndex, memberClassIndices);
    }

    private DebugExtensionAttribute readSourceDebugExtension() throws IOException {
        byte[] debugExtension = new byte[this.expectedContentLength];
        this.is.readFully(debugExtension);
        try {
            new DataInputStream(new ByteArrayInputStream(debugExtension)).readUTF();
        }
        catch (Throwable t) {
            logger.debug("Invalid SourceDebugExtension, not a valid UTF");
            return null;
        }
        return new DebugExtensionAttribute(this.nameIndex, debugExtension);
    }

    private AnnotationsAttribute readAnnotations(AttributeContext context) throws IOException {
        return new AnnotationReader(this.reader, this.builder.getPool(), this.is, this.expectedContentLength, this.nameIndex, context).readAnnotations();
    }

    private ParameterAnnotationsAttribute readParameterAnnotations(AttributeContext context) throws IOException {
        return new AnnotationReader(this.reader, this.builder.getPool(), this.is, this.expectedContentLength, this.nameIndex, context).readParameterAnnotations();
    }

    private AnnotationsAttribute readTypeAnnotations(AttributeContext context) throws IOException {
        return new AnnotationReader(this.reader, this.builder.getPool(), this.is, this.expectedContentLength, this.nameIndex, context).readTypeAnnotations();
    }

    private AnnotationDefaultAttribute readAnnotationDefault(AttributeContext context) throws IOException {
        return new AnnotationReader(this.reader, this.builder.getPool(), this.is, this.expectedContentLength, this.nameIndex, context).readAnnotationDefault();
    }

    private SyntheticAttribute readSynthetic() {
        return new SyntheticAttribute(this.nameIndex);
    }

    private BootstrapMethodsAttribute readBoostrapMethods() throws IOException {
        ArrayList<BootstrapMethodsAttribute.BootstrapMethod> bootstrapMethods = new ArrayList<BootstrapMethodsAttribute.BootstrapMethod>();
        int bsmCount = this.is.readUnsignedShort();
        for (int i = 0; i < bsmCount; ++i) {
            int methodRef = this.is.readUnsignedShort();
            int argCount = this.is.readUnsignedShort();
            ArrayList<Integer> args = new ArrayList<Integer>();
            for (int j = 0; j < argCount; ++j) {
                args.add(this.is.readUnsignedShort());
            }
            bootstrapMethods.add(new BootstrapMethodsAttribute.BootstrapMethod(methodRef, args));
        }
        return new BootstrapMethodsAttribute(this.nameIndex, bootstrapMethods);
    }

    private CodeAttribute readCode() throws IOException {
        int maxStack = -1;
        int maxLocals = -1;
        int codeLength = -1;
        byte[] code = null;
        ArrayList<CodeAttribute.ExceptionTableEntry> exceptions = new ArrayList<CodeAttribute.ExceptionTableEntry>();
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        if (this.builder.isOakVersion()) {
            maxStack = this.is.readUnsignedByte();
            maxLocals = this.is.readUnsignedByte();
            codeLength = this.is.readUnsignedShort();
        } else {
            maxStack = this.is.readUnsignedShort();
            maxLocals = this.is.readUnsignedShort();
            codeLength = this.is.readInt();
        }
        code = new byte[codeLength];
        this.is.readFully(code);
        int numExceptions = this.is.readUnsignedShort();
        for (int i = 0; i < numExceptions; ++i) {
            exceptions.add(this.readCodeException());
        }
        int numAttributes = this.is.readUnsignedShort();
        for (int i = 0; i < numAttributes; ++i) {
            Attribute attr = new AttributeReader(this.reader, this.builder, this.is).readAttribute(AttributeContext.ATTRIBUTE);
            if (attr == null) continue;
            attributes.add(attr);
        }
        return new CodeAttribute(this.nameIndex, maxStack, maxLocals, code, exceptions, attributes);
    }

    private CodeAttribute.ExceptionTableEntry readCodeException() throws IOException {
        return new CodeAttribute.ExceptionTableEntry(this.is.readUnsignedShort(), this.is.readUnsignedShort(), this.is.readUnsignedShort(), this.is.readUnsignedShort());
    }

    private ConstantValueAttribute readConstantValue() throws IOException {
        int valueIndex = this.is.readUnsignedShort();
        return new ConstantValueAttribute(this.nameIndex, valueIndex);
    }

    private StackMapTableAttribute readStackMapTable() throws IOException {
        int numEntries = this.is.readUnsignedShort();
        ArrayList<StackMapTableAttribute.StackMapFrame> frames = new ArrayList<StackMapTableAttribute.StackMapFrame>(numEntries);
        for (int i = 0; i < numEntries; ++i) {
            int j;
            ArrayList<StackMapTableAttribute.TypeInfo> locals;
            int frameType = this.is.readUnsignedByte();
            if (frameType <= 63) {
                frames.add(new StackMapTableAttribute.SameFrame(frameType));
                continue;
            }
            if (frameType <= 127) {
                StackMapTableAttribute.TypeInfo stack = this.readVerificationTypeInfo();
                frames.add(new StackMapTableAttribute.SameLocalsOneStackItem(frameType - 64, stack));
                continue;
            }
            if (frameType < 247) {
                throw new IllegalArgumentException("Unknown stackframe tag " + frameType);
            }
            if (frameType <= 247) {
                int offsetDelta = this.is.readUnsignedShort();
                StackMapTableAttribute.TypeInfo stack = this.readVerificationTypeInfo();
                frames.add(new StackMapTableAttribute.SameLocalsOneStackItemExtended(offsetDelta, stack));
                continue;
            }
            if (frameType <= 250) {
                int k = 251 - frameType;
                int offsetDelta = this.is.readUnsignedShort();
                frames.add(new StackMapTableAttribute.ChopFrame(offsetDelta, k));
                continue;
            }
            if (frameType < 252) {
                int offsetDelta = this.is.readUnsignedShort();
                frames.add(new StackMapTableAttribute.SameFrameExtended(offsetDelta));
                continue;
            }
            if (frameType <= 254) {
                int offsetDelta = this.is.readUnsignedShort();
                int numLocals = frameType - 251;
                locals = new ArrayList<StackMapTableAttribute.TypeInfo>(numLocals);
                for (j = 0; j < numLocals; ++j) {
                    locals.add(this.readVerificationTypeInfo());
                }
                frames.add(new StackMapTableAttribute.AppendFrame(offsetDelta, locals));
                continue;
            }
            if (frameType <= 255) {
                int offsetDelta = this.is.readUnsignedShort();
                int numLocals = this.is.readUnsignedShort();
                locals = new ArrayList(numLocals);
                for (j = 0; j < numLocals; ++j) {
                    locals.add(this.readVerificationTypeInfo());
                }
                int numStackItems = this.is.readUnsignedShort();
                ArrayList<StackMapTableAttribute.TypeInfo> stack = new ArrayList<StackMapTableAttribute.TypeInfo>(numStackItems);
                for (int j2 = 0; j2 < numStackItems; ++j2) {
                    stack.add(this.readVerificationTypeInfo());
                }
                frames.add(new StackMapTableAttribute.FullFrame(offsetDelta, locals, stack));
                continue;
            }
            throw new IllegalArgumentException("Unknown frame type " + frameType);
        }
        return new StackMapTableAttribute(this.nameIndex, frames);
    }

    private StackMapTableAttribute.TypeInfo readVerificationTypeInfo() throws IOException {
        int tag = this.is.readUnsignedByte();
        switch (tag) {
            case 0: {
                return new StackMapTableAttribute.TopVariableInfo();
            }
            case 1: {
                return new StackMapTableAttribute.IntegerVariableInfo();
            }
            case 2: {
                return new StackMapTableAttribute.FloatVariableInfo();
            }
            case 3: {
                return new StackMapTableAttribute.DoubleVariableInfo();
            }
            case 4: {
                return new StackMapTableAttribute.LongVariableInfo();
            }
            case 5: {
                return new StackMapTableAttribute.NullVariableInfo();
            }
            case 6: {
                return new StackMapTableAttribute.UninitializedThisVariableInfo();
            }
            case 7: {
                int cpoolIndex = this.is.readUnsignedShort();
                return new StackMapTableAttribute.ObjectVariableInfo(cpoolIndex);
            }
            case 8: {
                int offset = this.is.readUnsignedShort();
                return new StackMapTableAttribute.UninitializedVariableInfo(offset);
            }
        }
        throw new IllegalArgumentException("Unknown verification type tag " + tag);
    }
}

