/*
 * Decompiled with CFR 0.152.
 */
package me.coley.cafedude.classfile.attribute;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import me.coley.cafedude.Constants;
import me.coley.cafedude.classfile.attribute.Attribute;
import me.coley.cafedude.classfile.behavior.CpAccessor;

public class StackMapTableAttribute
extends Attribute
implements Constants.StackMapTable {
    public final List<StackMapFrame> frames;

    public StackMapTableAttribute(int nameIndex, List<StackMapFrame> frames) {
        super(nameIndex);
        this.frames = frames;
    }

    @Override
    public Set<Integer> cpAccesses() {
        Set<Integer> set = super.cpAccesses();
        for (StackMapFrame frame : this.frames) {
            set.addAll(frame.cpAccesses());
        }
        return set;
    }

    @Override
    public int computeInternalLength() {
        int length = 2;
        for (StackMapFrame frame : this.frames) {
            length += frame.getLength();
        }
        return length;
    }

    public static class FullFrame
    extends StackMapFrame {
        public List<TypeInfo> locals;
        public List<TypeInfo> stack;

        public FullFrame(int offsetDelta, List<TypeInfo> locals, List<TypeInfo> stack) {
            super(offsetDelta);
            this.locals = locals;
            this.stack = stack;
        }

        @Override
        public Set<Integer> cpAccesses() {
            TreeSet<Integer> set = new TreeSet<Integer>();
            for (TypeInfo info : this.locals) {
                set.addAll(info.cpAccesses());
            }
            for (TypeInfo info : this.stack) {
                set.addAll(info.cpAccesses());
            }
            return set;
        }

        @Override
        public int getLength() {
            int length = 3;
            length += 2;
            for (TypeInfo local : this.locals) {
                length += local.getLength();
            }
            length += 2;
            for (TypeInfo stackType : this.stack) {
                length += stackType.getLength();
            }
            return length;
        }

        @Override
        public int getFrameType() {
            return 255;
        }
    }

    public static class AppendFrame
    extends StackMapFrame {
        public List<TypeInfo> additionalLocals;

        public AppendFrame(int offsetDelta, List<TypeInfo> additionalLocals) {
            super(offsetDelta);
            this.additionalLocals = additionalLocals;
        }

        @Override
        public Set<Integer> cpAccesses() {
            TreeSet<Integer> set = new TreeSet<Integer>();
            for (TypeInfo info : this.additionalLocals) {
                set.addAll(info.cpAccesses());
            }
            return set;
        }

        @Override
        public int getLength() {
            int length = 3;
            for (TypeInfo local : this.additionalLocals) {
                length += local.getLength();
            }
            return length;
        }

        @Override
        public int getFrameType() {
            return this.additionalLocals.size() + 252 - 1;
        }
    }

    public static class SameFrameExtended
    extends StackMapFrame {
        public SameFrameExtended(int offsetDelta) {
            super(offsetDelta);
        }

        @Override
        public int getLength() {
            return 3;
        }

        @Override
        public int getFrameType() {
            return 251;
        }
    }

    public static class ChopFrame
    extends StackMapFrame {
        public int absentVariables;

        public ChopFrame(int offsetDelta, int absentVariables) {
            super(offsetDelta);
            this.absentVariables = absentVariables;
        }

        @Override
        public int getLength() {
            return 3;
        }

        @Override
        public int getFrameType() {
            return 250 - this.absentVariables + 1;
        }
    }

    public static class SameLocalsOneStackItemExtended
    extends StackMapFrame {
        public TypeInfo stack;

        public SameLocalsOneStackItemExtended(int offsetDelta, TypeInfo stack) {
            super(offsetDelta);
            this.stack = stack;
        }

        @Override
        public Set<Integer> cpAccesses() {
            return this.stack.cpAccesses();
        }

        @Override
        public int getLength() {
            return 3 + this.stack.getLength();
        }

        @Override
        public int getFrameType() {
            return 247;
        }
    }

    public static class SameLocalsOneStackItem
    extends StackMapFrame {
        public TypeInfo stack;

        public SameLocalsOneStackItem(int offsetDelta, TypeInfo stack) {
            super(offsetDelta);
            this.stack = stack;
        }

        @Override
        public Set<Integer> cpAccesses() {
            return this.stack.cpAccesses();
        }

        @Override
        public int getLength() {
            return 1 + this.stack.getLength();
        }

        @Override
        public int getFrameType() {
            return 64 + this.offsetDelta;
        }
    }

    public static class SameFrame
    extends StackMapFrame {
        public SameFrame(int offsetDelta) {
            super(offsetDelta);
        }

        @Override
        public int getFrameType() {
            return 0 + this.offsetDelta;
        }
    }

    public static abstract class StackMapFrame
    implements CpAccessor {
        public int offsetDelta;

        public StackMapFrame(int offsetDelta) {
            this.offsetDelta = offsetDelta;
        }

        public abstract int getFrameType();

        public int getLength() {
            return 1;
        }

        @Override
        public Set<Integer> cpAccesses() {
            return Collections.emptySet();
        }
    }

    public static class DoubleVariableInfo
    extends TypeInfo {
        @Override
        public int getTag() {
            return 3;
        }
    }

    public static class LongVariableInfo
    extends TypeInfo {
        @Override
        public int getTag() {
            return 4;
        }
    }

    public static class UninitializedVariableInfo
    extends TypeInfo {
        public int offset;

        @Override
        public int getTag() {
            return 8;
        }

        public UninitializedVariableInfo(int offset) {
            this.offset = offset;
        }

        @Override
        public int getLength() {
            return 3;
        }
    }

    public static class ObjectVariableInfo
    extends TypeInfo {
        public int classIndex;

        @Override
        public int getTag() {
            return 7;
        }

        public ObjectVariableInfo(int classIndex) {
            this.classIndex = classIndex;
        }

        @Override
        public Set<Integer> cpAccesses() {
            return Collections.singleton(this.classIndex);
        }

        @Override
        public int getLength() {
            return 3;
        }
    }

    public static class UninitializedThisVariableInfo
    extends TypeInfo {
        @Override
        public int getTag() {
            return 6;
        }
    }

    public static class NullVariableInfo
    extends TypeInfo {
        @Override
        public int getTag() {
            return 5;
        }
    }

    public static class FloatVariableInfo
    extends TypeInfo {
        @Override
        public int getTag() {
            return 2;
        }
    }

    public static class IntegerVariableInfo
    extends TypeInfo {
        @Override
        public int getTag() {
            return 1;
        }
    }

    public static class TopVariableInfo
    extends TypeInfo {
        @Override
        public int getTag() {
            return 0;
        }
    }

    public static abstract class TypeInfo
    implements CpAccessor {
        public abstract int getTag();

        public int getLength() {
            return 1;
        }

        @Override
        public Set<Integer> cpAccesses() {
            return Collections.emptySet();
        }
    }
}

