/*
 * Decompiled with CFR 0.152.
 */
package me.coley.cafedude.classfile.attribute;

import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import me.coley.cafedude.classfile.attribute.Attribute;
import me.coley.cafedude.classfile.behavior.CpAccessor;

public class LocalVariableTypeTableAttribute
extends Attribute {
    private List<VarTypeEntry> entries;

    public LocalVariableTypeTableAttribute(int nameIndex, List<VarTypeEntry> entries) {
        super(nameIndex);
        this.entries = entries;
    }

    @Override
    public Set<Integer> cpAccesses() {
        Set<Integer> set = super.cpAccesses();
        for (VarTypeEntry entry : this.getEntries()) {
            set.addAll(entry.cpAccesses());
        }
        return set;
    }

    @Override
    public int computeInternalLength() {
        return 2 + 10 * this.entries.size();
    }

    public List<VarTypeEntry> getEntries() {
        return this.entries;
    }

    public void setEntries(List<VarTypeEntry> entries) {
        this.entries = entries;
    }

    public static class VarTypeEntry
    implements CpAccessor {
        private final int startPc;
        private final int length;
        private final int nameIndex;
        private final int signatureIndex;
        private final int index;

        public VarTypeEntry(int startPc, int length, int nameIndex, int signatureIndex, int index) {
            this.startPc = startPc;
            this.length = length;
            this.nameIndex = nameIndex;
            this.signatureIndex = signatureIndex;
            this.index = index;
        }

        public int getStartPc() {
            return this.startPc;
        }

        public int getLength() {
            return this.length;
        }

        public int getNameIndex() {
            return this.nameIndex;
        }

        public int getSignatureIndex() {
            return this.signatureIndex;
        }

        public int getIndex() {
            return this.index;
        }

        @Override
        public Set<Integer> cpAccesses() {
            TreeSet<Integer> set = new TreeSet<Integer>();
            set.add(this.getNameIndex());
            set.add(this.getSignatureIndex());
            return set;
        }
    }
}

