/*
 * Decompiled with CFR 0.152.
 */
package me.coley.cafedude.classfile.attribute;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import me.coley.cafedude.classfile.attribute.Attribute;
import me.coley.cafedude.classfile.behavior.AttributeHolder;
import me.coley.cafedude.classfile.behavior.CpAccessor;
import me.coley.cafedude.io.AttributeContext;

public class CodeAttribute
extends Attribute
implements AttributeHolder {
    private List<ExceptionTableEntry> exceptionTable;
    private List<Attribute> attributes;
    private byte[] code;
    private int maxStack;
    private int maxLocals;

    public CodeAttribute(int nameIndex, int maxStack, int maxLocals, byte[] code, List<ExceptionTableEntry> exceptionTable, List<Attribute> attributes) {
        super(nameIndex);
        this.maxStack = maxStack;
        this.maxLocals = maxLocals;
        this.code = code;
        this.exceptionTable = exceptionTable;
        this.attributes = attributes;
    }

    public byte[] getCode() {
        return this.code;
    }

    public void setCode(byte[] code) {
        this.code = code;
    }

    public int getMaxStack() {
        return this.maxStack;
    }

    public void setMaxStack(int maxStack) {
        this.maxStack = maxStack;
    }

    public int getMaxLocals() {
        return this.maxLocals;
    }

    public void setMaxLocals(int maxLocals) {
        this.maxLocals = maxLocals;
    }

    public List<ExceptionTableEntry> getExceptionTable() {
        return this.exceptionTable;
    }

    public void setExceptionTable(List<ExceptionTableEntry> exceptionTable) {
        this.exceptionTable = exceptionTable;
    }

    @Override
    public List<Attribute> getAttributes() {
        return this.attributes;
    }

    @Override
    public void setAttributes(List<Attribute> attributes) {
        this.attributes = attributes;
    }

    @Override
    public AttributeContext getHolderType() {
        return AttributeContext.ATTRIBUTE;
    }

    @Override
    public Set<Integer> cpAccesses() {
        Set<Integer> set = super.cpAccesses();
        for (Attribute attribute : this.getAttributes()) {
            set.addAll(attribute.cpAccesses());
        }
        for (ExceptionTableEntry ex : this.getExceptionTable()) {
            set.addAll(ex.cpAccesses());
        }
        return set;
    }

    @Override
    public int computeInternalLength() {
        int len = 4;
        len += 4;
        len += this.code.length;
        len += 2;
        len += 8 * this.exceptionTable.size();
        len += 2;
        for (Attribute attribute : this.attributes) {
            len += attribute.computeCompleteLength();
        }
        return len;
    }

    public static class ExceptionTableEntry
    implements CpAccessor {
        private int startPc;
        private int endPc;
        private int handlerPc;
        private int catchTypeIndex;

        public ExceptionTableEntry(int startPc, int endPc, int handlerPc, int catchTypeIndex) {
            this.startPc = startPc;
            this.endPc = endPc;
            this.handlerPc = handlerPc;
            this.catchTypeIndex = catchTypeIndex;
        }

        public int getStartPc() {
            return this.startPc;
        }

        public void setStartPc(int startPc) {
            this.startPc = startPc;
        }

        public int getEndPc() {
            return this.endPc;
        }

        public void setEndPc(int endPc) {
            this.endPc = endPc;
        }

        public int getHandlerPc() {
            return this.handlerPc;
        }

        public void setHandlerPc(int handlerPc) {
            this.handlerPc = handlerPc;
        }

        public int getCatchTypeIndex() {
            return this.catchTypeIndex;
        }

        public void setCatchTypeIndex(int catchTypeIndex) {
            this.catchTypeIndex = catchTypeIndex;
        }

        @Override
        public Set<Integer> cpAccesses() {
            return Collections.singleton(this.getCatchTypeIndex());
        }
    }
}

