/*
 * Decompiled with CFR 0.152.
 */
package me.coley.cafedude.classfile;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Descriptor {
    public static final Descriptor VOID = new Descriptor(Kind.PRIMITIVE, "V");
    public static final Descriptor BOOLEAN = new Descriptor(Kind.PRIMITIVE, "Z");
    public static final Descriptor BYTE = new Descriptor(Kind.PRIMITIVE, "B");
    public static final Descriptor CHAR = new Descriptor(Kind.PRIMITIVE, "C");
    public static final Descriptor INT = new Descriptor(Kind.PRIMITIVE, "I");
    public static final Descriptor FLOAT = new Descriptor(Kind.PRIMITIVE, "F");
    public static final Descriptor DOUBLE = new Descriptor(Kind.PRIMITIVE, "D");
    public static final Descriptor LONG = new Descriptor(Kind.PRIMITIVE, "J");
    public static final Descriptor OBJECT = new Descriptor(Kind.OBJECT, "Ljava/lang/Object;");
    private final Kind kind;
    private final String desc;
    private final int arrayLevel;

    private Descriptor(Kind kind, String desc) {
        this(kind, desc, 0);
    }

    private Descriptor(Kind kind, String desc, int arrayLevel) {
        this.kind = kind;
        this.desc = desc;
        this.arrayLevel = arrayLevel;
    }

    public Descriptor getElementDesc() {
        if (this.arrayLevel == 0) {
            return this;
        }
        return Descriptor.from(this.desc.substring(this.arrayLevel));
    }

    public List<Descriptor> getParameters() {
        if (this.kind == Kind.METHOD) {
            int start = 1;
            int stop = 1;
            int max = this.desc.indexOf(41);
            ArrayList<Descriptor> list = new ArrayList<Descriptor>();
            while (start < max) {
                String section = this.desc.substring(start, ++stop);
                if (Descriptor.isPrimitive(this.desc)) {
                    list.add(Descriptor.from(section));
                } else {
                    char first = section.charAt(0);
                    if (first == '[') {
                        int i;
                        for (i = 1; i < stop && section.charAt(i) == '['; ++i) {
                        }
                        char elementStart = this.desc.charAt(start + i);
                        stop = Descriptor.isPrimitive(elementStart) ? start + i : this.desc.indexOf(59, start + 1) + 1;
                        section = this.desc.substring(start, stop);
                        list.add(new Descriptor(Kind.ARRAY, section, i));
                    } else if (first == 'L' && start + 1 < max) {
                        stop = this.desc.indexOf(59, start + 1) + 1;
                        section = this.desc.substring(start, stop);
                        list.add(new Descriptor(Kind.OBJECT, section));
                    } else {
                        list.add(new Descriptor(Kind.ILLEGAL, section));
                    }
                }
                start = stop;
            }
            return list;
        }
        return Collections.singletonList(this);
    }

    public int getParameterCount() {
        if (this.kind == Kind.METHOD) {
            int count = 0;
            int current = 1;
            int max = this.desc.indexOf(41);
            while (current < max) {
                int end;
                char c = this.desc.charAt(current);
                if (Descriptor.isPrimitive(c)) {
                    ++count;
                    ++current;
                    continue;
                }
                if (c == 'L') {
                    ++count;
                    end = this.desc.indexOf(59, current + 2);
                    if (end < 0) {
                        return -1;
                    }
                    current = end + 1;
                    continue;
                }
                if (c == '[') {
                    while ((c = this.desc.charAt(current++)) == '[') {
                    }
                    if (Descriptor.isPrimitive(c)) {
                        ++current;
                        ++count;
                        continue;
                    }
                    if (c == 'L') {
                        ++count;
                        end = this.desc.indexOf(59, current + 2);
                        if (end < 0) {
                            return -1;
                        }
                        current = end + 1;
                        continue;
                    }
                    return -1;
                }
                return -1;
            }
            return count;
        }
        return -1;
    }

    public Descriptor getReturnDesc() {
        if (this.kind == Kind.METHOD) {
            return Descriptor.from(this.desc.substring(this.desc.indexOf(41) + 1));
        }
        return this;
    }

    public boolean isWide() {
        if (this.kind == Kind.PRIMITIVE) {
            char c = this.desc.charAt(0);
            return c == 'J' || c == 'D';
        }
        return false;
    }

    public String getDescriptor() {
        return this.desc;
    }

    public Kind getKind() {
        return this.kind;
    }

    public int getArrayLevel() {
        return this.arrayLevel;
    }

    public static Descriptor from(String desc) {
        if (desc == null || desc.trim().isEmpty()) {
            return null;
        }
        switch (desc) {
            case "V": {
                return VOID;
            }
            case "Z": {
                return BOOLEAN;
            }
            case "B": {
                return BYTE;
            }
            case "C": {
                return CHAR;
            }
            case "I": {
                return INT;
            }
            case "F": {
                return FLOAT;
            }
            case "D": {
                return DOUBLE;
            }
            case "J": {
                return LONG;
            }
        }
        char first = desc.charAt(0);
        if (first == '[') {
            int i;
            int max = desc.length();
            for (i = 1; i < max && desc.charAt(i) == '['; ++i) {
            }
            Descriptor d = Descriptor.from(desc.substring(i));
            if (d == null || d.kind == Kind.ILLEGAL) {
                return new Descriptor(Kind.ILLEGAL, desc);
            }
            return new Descriptor(Kind.ARRAY, desc, i);
        }
        if (first == '(') {
            int end = desc.indexOf(41);
            if (end < 0 || end == desc.length() - 1) {
                return new Descriptor(Kind.ILLEGAL, desc);
            }
            Descriptor d = new Descriptor(Kind.METHOD, desc);
            if (Descriptor.from((String)d.getReturnDesc().desc).kind == Kind.ILLEGAL) {
                return new Descriptor(Kind.ILLEGAL, desc);
            }
            if (d.getParameterCount() < 0) {
                return new Descriptor(Kind.ILLEGAL, desc);
            }
            return d;
        }
        if (first == 'L') {
            int end = desc.indexOf(59);
            if (end < 0 || end == 1) {
                return new Descriptor(Kind.ILLEGAL, desc);
            }
            return new Descriptor(Kind.OBJECT, desc);
        }
        return new Descriptor(Kind.ILLEGAL, desc);
    }

    public static boolean isPrimitive(String desc) {
        if (desc == null || desc.length() != 1) {
            return false;
        }
        return Descriptor.isPrimitive(desc.charAt(0));
    }

    public static boolean isPrimitive(char desc) {
        switch (desc) {
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'V': 
            case 'Z': {
                return true;
            }
        }
        return false;
    }

    public static enum Kind {
        PRIMITIVE,
        OBJECT,
        ARRAY,
        METHOD,
        ILLEGAL;

    }
}

