/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.writer.builder;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jf.dexlib2.Opcodes;
import org.jf.dexlib2.base.BaseExceptionHandler;
import org.jf.dexlib2.base.BaseTryBlock;
import org.jf.dexlib2.iface.Annotation;
import org.jf.dexlib2.iface.AnnotationElement;
import org.jf.dexlib2.iface.ClassDef;
import org.jf.dexlib2.iface.ExceptionHandler;
import org.jf.dexlib2.iface.Field;
import org.jf.dexlib2.iface.Method;
import org.jf.dexlib2.iface.MethodImplementation;
import org.jf.dexlib2.iface.MethodParameter;
import org.jf.dexlib2.iface.TryBlock;
import org.jf.dexlib2.iface.UpdateReference;
import org.jf.dexlib2.iface.debug.DebugItem;
import org.jf.dexlib2.iface.instruction.Instruction;
import org.jf.dexlib2.iface.reference.FieldReference;
import org.jf.dexlib2.iface.reference.MethodProtoReference;
import org.jf.dexlib2.iface.reference.MethodReference;
import org.jf.dexlib2.iface.reference.Reference;
import org.jf.dexlib2.iface.reference.StringReference;
import org.jf.dexlib2.iface.reference.TypeReference;
import org.jf.dexlib2.iface.value.AnnotationEncodedValue;
import org.jf.dexlib2.iface.value.ArrayEncodedValue;
import org.jf.dexlib2.iface.value.BooleanEncodedValue;
import org.jf.dexlib2.iface.value.ByteEncodedValue;
import org.jf.dexlib2.iface.value.CharEncodedValue;
import org.jf.dexlib2.iface.value.DoubleEncodedValue;
import org.jf.dexlib2.iface.value.EncodedValue;
import org.jf.dexlib2.iface.value.EnumEncodedValue;
import org.jf.dexlib2.iface.value.FieldEncodedValue;
import org.jf.dexlib2.iface.value.FloatEncodedValue;
import org.jf.dexlib2.iface.value.IntEncodedValue;
import org.jf.dexlib2.iface.value.LongEncodedValue;
import org.jf.dexlib2.iface.value.MethodEncodedValue;
import org.jf.dexlib2.iface.value.ShortEncodedValue;
import org.jf.dexlib2.iface.value.StringEncodedValue;
import org.jf.dexlib2.iface.value.TypeEncodedValue;
import org.jf.dexlib2.writer.DexWriter;
import org.jf.dexlib2.writer.builder.BuilderAnnotation;
import org.jf.dexlib2.writer.builder.BuilderAnnotationElement;
import org.jf.dexlib2.writer.builder.BuilderAnnotationPool;
import org.jf.dexlib2.writer.builder.BuilderAnnotationSet;
import org.jf.dexlib2.writer.builder.BuilderAnnotationSetPool;
import org.jf.dexlib2.writer.builder.BuilderClassDef;
import org.jf.dexlib2.writer.builder.BuilderClassPool;
import org.jf.dexlib2.writer.builder.BuilderEncodedValues;
import org.jf.dexlib2.writer.builder.BuilderField;
import org.jf.dexlib2.writer.builder.BuilderFieldPool;
import org.jf.dexlib2.writer.builder.BuilderFieldReference;
import org.jf.dexlib2.writer.builder.BuilderMethod;
import org.jf.dexlib2.writer.builder.BuilderMethodParameter;
import org.jf.dexlib2.writer.builder.BuilderMethodPool;
import org.jf.dexlib2.writer.builder.BuilderMethodProtoReference;
import org.jf.dexlib2.writer.builder.BuilderMethodReference;
import org.jf.dexlib2.writer.builder.BuilderProtoPool;
import org.jf.dexlib2.writer.builder.BuilderReference;
import org.jf.dexlib2.writer.builder.BuilderStringPool;
import org.jf.dexlib2.writer.builder.BuilderStringReference;
import org.jf.dexlib2.writer.builder.BuilderTypeList;
import org.jf.dexlib2.writer.builder.BuilderTypeListPool;
import org.jf.dexlib2.writer.builder.BuilderTypePool;
import org.jf.dexlib2.writer.builder.BuilderTypeReference;
import org.jf.util.ExceptionWithContext;

public class DexBuilder
extends DexWriter<BuilderStringReference, BuilderStringReference, BuilderTypeReference, BuilderTypeReference, BuilderMethodProtoReference, BuilderFieldReference, BuilderMethodReference, BuilderClassDef, BuilderAnnotation, BuilderAnnotationSet, BuilderTypeList, BuilderField, BuilderMethod, BuilderEncodedValues.BuilderEncodedValue, BuilderAnnotationElement, BuilderStringPool, BuilderTypePool, BuilderProtoPool, BuilderFieldPool, BuilderMethodPool, BuilderClassPool, BuilderTypeListPool, BuilderAnnotationPool, BuilderAnnotationSetPool> {
    private boolean ignoreMethodAndFieldError = false;

    public DexBuilder(Opcodes opcodes) {
        super(opcodes);
    }

    @Override
    protected DexWriter.SectionProvider getSectionProvider() {
        return new DexBuilderSectionProvider();
    }

    public BuilderField internField(String definingClass, String name, String type, int accessFlags, EncodedValue initialValue, Set<? extends Annotation> annotations) {
        return new BuilderField(((BuilderFieldPool)this.fieldSection).internField(definingClass, name, type), accessFlags, this.internNullableEncodedValue(initialValue), ((BuilderAnnotationSetPool)this.annotationSetSection).internAnnotationSet(annotations));
    }

    public BuilderMethod internMethod(String definingClass, String name, List<? extends MethodParameter> parameters, String returnType, int accessFlags, Set<? extends Annotation> annotations, MethodImplementation methodImplementation) {
        if (parameters == null) {
            parameters = ImmutableList.of();
        }
        return new BuilderMethod(((BuilderMethodPool)this.methodSection).internMethod(definingClass, name, (List<? extends CharSequence>)parameters, returnType), this.internMethodParameters((List<? extends MethodParameter>)parameters), accessFlags, ((BuilderAnnotationSetPool)this.annotationSetSection).internAnnotationSet(annotations), methodImplementation);
    }

    public BuilderClassDef internClassDef(String type, int accessFlags, String superclass, List<String> interfaces, String sourceFile, Set<? extends Annotation> annotations, Iterable<? extends BuilderField> fields, Iterable<? extends BuilderMethod> methods) {
        if (interfaces == null) {
            interfaces = ImmutableList.of();
        } else {
            HashSet interfaces_copy = Sets.newHashSet((Iterable)interfaces);
            Iterator interfaceIterator = interfaces.iterator();
            while (interfaceIterator.hasNext()) {
                String iface = (String)interfaceIterator.next();
                if (!interfaces_copy.contains(iface)) {
                    interfaceIterator.remove();
                    continue;
                }
                interfaces_copy.remove(iface);
            }
        }
        return ((BuilderClassPool)this.classSection).internClass(new BuilderClassDef(((BuilderTypePool)this.typeSection).internType(type), accessFlags, ((BuilderTypePool)this.typeSection).internNullableType(superclass), ((BuilderTypeListPool)this.typeListSection).internTypeList((List<? extends CharSequence>)interfaces), ((BuilderStringPool)this.stringSection).internNullableString(sourceFile), ((BuilderAnnotationSetPool)this.annotationSetSection).internAnnotationSet(annotations), fields, methods));
    }

    public BuilderStringReference internStringReference(String string) {
        return ((BuilderStringPool)this.stringSection).internString(string);
    }

    public BuilderStringReference internNullableStringReference(String string) {
        if (string != null) {
            return this.internStringReference(string);
        }
        return null;
    }

    public BuilderTypeReference internTypeReference(String type) {
        return ((BuilderTypePool)this.typeSection).internType(type);
    }

    public BuilderTypeReference internNullableTypeReference(String type) {
        if (type != null) {
            return this.internTypeReference(type);
        }
        return null;
    }

    public BuilderFieldReference internFieldReference(FieldReference field) {
        return ((BuilderFieldPool)this.fieldSection).internField(field);
    }

    public BuilderMethodReference internMethodReference(MethodReference method) {
        return ((BuilderMethodPool)this.methodSection).internMethod(method);
    }

    public BuilderMethodProtoReference internMethodProtoReference(MethodProtoReference methodProto) {
        return ((BuilderProtoPool)this.protoSection).internMethodProto(methodProto);
    }

    public BuilderReference internReference(Reference reference) {
        if (reference instanceof StringReference) {
            return this.internStringReference(((StringReference)reference).getString());
        }
        if (reference instanceof TypeReference) {
            return this.internTypeReference(((TypeReference)reference).getType());
        }
        if (reference instanceof MethodReference) {
            return this.internMethodReference((MethodReference)reference);
        }
        if (reference instanceof FieldReference) {
            return this.internFieldReference((FieldReference)reference);
        }
        if (reference instanceof MethodProtoReference) {
            return this.internMethodProtoReference((MethodProtoReference)reference);
        }
        throw new IllegalArgumentException("Could not determine type of reference");
    }

    private List<BuilderMethodParameter> internMethodParameters(List<? extends MethodParameter> methodParameters) {
        if (methodParameters == null) {
            return ImmutableList.of();
        }
        return ImmutableList.copyOf((Iterator)Iterators.transform(methodParameters.iterator(), (Function)new Function<MethodParameter, BuilderMethodParameter>(){

            public BuilderMethodParameter apply(MethodParameter input) {
                return DexBuilder.this.internMethodParameter(input);
            }
        }));
    }

    private BuilderMethodParameter internMethodParameter(MethodParameter methodParameter) {
        return new BuilderMethodParameter(((BuilderTypePool)this.typeSection).internType(methodParameter.getType()), ((BuilderStringPool)this.stringSection).internNullableString(methodParameter.getName()), ((BuilderAnnotationSetPool)this.annotationSetSection).internAnnotationSet(methodParameter.getAnnotations()));
    }

    @Override
    protected void writeEncodedValue(DexWriter.InternalEncodedValueWriter writer, BuilderEncodedValues.BuilderEncodedValue encodedValue) throws IOException {
        switch (encodedValue.getValueType()) {
            case 29: {
                BuilderEncodedValues.BuilderAnnotationEncodedValue annotationEncodedValue = (BuilderEncodedValues.BuilderAnnotationEncodedValue)encodedValue;
                writer.writeAnnotation(annotationEncodedValue.typeReference, annotationEncodedValue.elements);
                break;
            }
            case 28: {
                BuilderEncodedValues.BuilderArrayEncodedValue arrayEncodedValue = (BuilderEncodedValues.BuilderArrayEncodedValue)encodedValue;
                writer.writeArray(arrayEncodedValue.elements);
                break;
            }
            case 31: {
                writer.writeBoolean(((BooleanEncodedValue)((Object)encodedValue)).getValue());
                break;
            }
            case 0: {
                writer.writeByte(((ByteEncodedValue)((Object)encodedValue)).getValue());
                break;
            }
            case 3: {
                writer.writeChar(((CharEncodedValue)((Object)encodedValue)).getValue());
                break;
            }
            case 17: {
                writer.writeDouble(((DoubleEncodedValue)((Object)encodedValue)).getValue());
                break;
            }
            case 27: {
                writer.writeEnum(((BuilderEncodedValues.BuilderEnumEncodedValue)encodedValue).getValue());
                break;
            }
            case 25: {
                writer.writeField(((BuilderEncodedValues.BuilderFieldEncodedValue)encodedValue).fieldReference);
                break;
            }
            case 16: {
                writer.writeFloat(((FloatEncodedValue)((Object)encodedValue)).getValue());
                break;
            }
            case 4: {
                writer.writeInt(((IntEncodedValue)((Object)encodedValue)).getValue());
                break;
            }
            case 6: {
                writer.writeLong(((LongEncodedValue)((Object)encodedValue)).getValue());
                break;
            }
            case 26: {
                writer.writeMethod(((BuilderEncodedValues.BuilderMethodEncodedValue)encodedValue).methodReference);
                break;
            }
            case 30: {
                writer.writeNull();
                break;
            }
            case 2: {
                writer.writeShort(((ShortEncodedValue)((Object)encodedValue)).getValue());
                break;
            }
            case 23: {
                writer.writeString(((BuilderEncodedValues.BuilderStringEncodedValue)encodedValue).stringReference);
                break;
            }
            case 24: {
                writer.writeType(((BuilderEncodedValues.BuilderTypeEncodedValue)encodedValue).typeReference);
                break;
            }
            default: {
                throw new ExceptionWithContext("Unrecognized value type: %d", encodedValue.getValueType());
            }
        }
    }

    public void setIgnoreMethodAndFieldError(boolean ignoreMethodAndFieldError) {
        this.ignoreMethodAndFieldError = ignoreMethodAndFieldError;
    }

    public BuilderClassDef internClassDef(ClassDef classDef) {
        ArrayList<BuilderField> fields = new ArrayList<BuilderField>();
        ArrayList<BuilderMethod> methods = new ArrayList<BuilderMethod>();
        if (this.ignoreMethodAndFieldError) {
            for (Field field : classDef.getFields()) {
                try {
                    BuilderField builderField = this.internField(field.getDefiningClass(), field.getName(), field.getType(), field.getAccessFlags(), field.getInitialValue(), field.getAnnotations());
                    fields.add(builderField);
                }
                catch (RuntimeException e) {
                    System.err.println(classDef.getType());
                    e.printStackTrace();
                }
            }
            for (Method method : classDef.getMethods()) {
                try {
                    BuilderMethod builderMethod = this.internMethod(method.getDefiningClass(), method.getName(), method.getParameters(), method.getReturnType(), method.getAccessFlags(), method.getAnnotations(), this.copyMethodImplementation(method.getImplementation()));
                    methods.add(builderMethod);
                }
                catch (RuntimeException e) {
                    System.err.println(classDef.getType());
                    e.printStackTrace();
                }
            }
        } else {
            for (Field field : classDef.getFields()) {
                BuilderField builderField = this.internField(field.getDefiningClass(), field.getName(), field.getType(), field.getAccessFlags(), field.getInitialValue(), field.getAnnotations());
                fields.add(builderField);
            }
            for (Method method : classDef.getMethods()) {
                BuilderMethod builderMethod = this.internMethod(method.getDefiningClass(), method.getName(), method.getParameters(), method.getReturnType(), method.getAccessFlags(), method.getAnnotations(), this.copyMethodImplementation(method.getImplementation()));
                methods.add(builderMethod);
            }
        }
        return this.internClassDef(classDef.getType(), classDef.getAccessFlags(), classDef.getSuperclass(), classDef.getInterfaces(), classDef.getSourceFile(), classDef.getAnnotations(), fields, methods);
    }

    private MethodImplementation copyMethodImplementation(MethodImplementation implementation) {
        MethodImplementation methodImplementation;
        if (implementation == null) {
            methodImplementation = null;
        } else {
            final int registerCount = implementation.getRegisterCount();
            final ArrayList<Instruction> instructions = new ArrayList<Instruction>();
            final ArrayList<DebugItem> debugItems = new ArrayList<DebugItem>();
            for (Instruction instruction : implementation.getInstructions()) {
                if (instruction instanceof UpdateReference) {
                    ((UpdateReference)((Object)instruction)).updateReference(this);
                }
                instructions.add(instruction);
            }
            List<? extends TryBlock<? extends ExceptionHandler>> tempTryBlocks = implementation.getTryBlocks();
            final ArrayList<BaseTryBlock<ExceptionHandler>> tryBlocks = new ArrayList<BaseTryBlock<ExceptionHandler>>(tempTryBlocks.size());
            for (TryBlock<? extends ExceptionHandler> tryBlock : tempTryBlocks) {
                tryBlocks.add(this.copyTryBlock(tryBlock));
            }
            for (DebugItem debugItem : implementation.getDebugItems()) {
                if (debugItem instanceof UpdateReference) {
                    ((UpdateReference)((Object)debugItem)).updateReference(this);
                }
                debugItems.add(debugItem);
            }
            methodImplementation = new MethodImplementation(){

                @Override
                public int getRegisterCount() {
                    return registerCount;
                }

                @Override
                public Iterable<? extends Instruction> getInstructions() {
                    return instructions;
                }

                @Override
                public List<? extends TryBlock<? extends ExceptionHandler>> getTryBlocks() {
                    return tryBlocks;
                }

                @Override
                public Iterable<? extends DebugItem> getDebugItems() {
                    return debugItems;
                }
            };
        }
        return methodImplementation;
    }

    private BaseTryBlock<ExceptionHandler> copyTryBlock(TryBlock tryBlock) {
        final int startCodeAddress = tryBlock.getStartCodeAddress();
        final int codeUnitCount = tryBlock.getCodeUnitCount();
        List tempExceptionHandlers = tryBlock.getExceptionHandlers();
        final ArrayList<ExceptionHandler> exceptionHandlers = new ArrayList<ExceptionHandler>(tempExceptionHandlers.size());
        for (ExceptionHandler backedExceptionHandler : tempExceptionHandlers) {
            exceptionHandlers.add(this.copyExceptionHandler(backedExceptionHandler));
        }
        return new BaseTryBlock<ExceptionHandler>(){

            @Override
            public int getStartCodeAddress() {
                return startCodeAddress;
            }

            @Override
            public int getCodeUnitCount() {
                return codeUnitCount;
            }

            @Override
            public List<? extends ExceptionHandler> getExceptionHandlers() {
                return exceptionHandlers;
            }
        };
    }

    private ExceptionHandler copyExceptionHandler(ExceptionHandler exceptionHandler) {
        String exceptionType = exceptionHandler.getExceptionType();
        final BuilderTypeReference typeReference = exceptionType == null ? null : this.internTypeReference(exceptionType);
        final int handlerCodeAddress = exceptionHandler.getHandlerCodeAddress();
        return new BaseExceptionHandler(){

            @Override
            public TypeReference getExceptionTypeReference() {
                return typeReference;
            }

            @Override
            public String getExceptionType() {
                return typeReference == null ? null : typeReference.getType();
            }

            @Override
            public int getHandlerCodeAddress() {
                return handlerCodeAddress;
            }
        };
    }

    Set<? extends BuilderAnnotationElement> internAnnotationElements(Set<? extends AnnotationElement> elements) {
        return ImmutableSet.copyOf((Iterator)Iterators.transform(elements.iterator(), (Function)new Function<AnnotationElement, BuilderAnnotationElement>(){

            public BuilderAnnotationElement apply(AnnotationElement input) {
                return DexBuilder.this.internAnnotationElement(input);
            }
        }));
    }

    private BuilderAnnotationElement internAnnotationElement(AnnotationElement annotationElement) {
        return new BuilderAnnotationElement(((BuilderStringPool)this.stringSection).internString(annotationElement.getName()), this.internEncodedValue(annotationElement.getValue()));
    }

    BuilderEncodedValues.BuilderEncodedValue internNullableEncodedValue(EncodedValue encodedValue) {
        if (encodedValue == null) {
            return null;
        }
        return this.internEncodedValue(encodedValue);
    }

    private BuilderEncodedValues.BuilderEncodedValue internEncodedValue(EncodedValue encodedValue) {
        switch (encodedValue.getValueType()) {
            case 29: {
                return this.internAnnotationEncodedValue((AnnotationEncodedValue)encodedValue);
            }
            case 28: {
                return this.internArrayEncodedValue((ArrayEncodedValue)encodedValue);
            }
            case 31: {
                boolean value = ((BooleanEncodedValue)encodedValue).getValue();
                return value ? BuilderEncodedValues.BuilderBooleanEncodedValue.TRUE_VALUE : BuilderEncodedValues.BuilderBooleanEncodedValue.FALSE_VALUE;
            }
            case 0: {
                return new BuilderEncodedValues.BuilderByteEncodedValue(((ByteEncodedValue)encodedValue).getValue());
            }
            case 3: {
                return new BuilderEncodedValues.BuilderCharEncodedValue(((CharEncodedValue)encodedValue).getValue());
            }
            case 17: {
                return new BuilderEncodedValues.BuilderDoubleEncodedValue(((DoubleEncodedValue)encodedValue).getValue());
            }
            case 27: {
                return this.internEnumEncodedValue((EnumEncodedValue)encodedValue);
            }
            case 25: {
                return this.internFieldEncodedValue((FieldEncodedValue)encodedValue);
            }
            case 16: {
                return new BuilderEncodedValues.BuilderFloatEncodedValue(((FloatEncodedValue)encodedValue).getValue());
            }
            case 4: {
                return new BuilderEncodedValues.BuilderIntEncodedValue(((IntEncodedValue)encodedValue).getValue());
            }
            case 6: {
                return new BuilderEncodedValues.BuilderLongEncodedValue(((LongEncodedValue)encodedValue).getValue());
            }
            case 26: {
                return this.internMethodEncodedValue((MethodEncodedValue)encodedValue);
            }
            case 30: {
                return BuilderEncodedValues.BuilderNullEncodedValue.INSTANCE;
            }
            case 2: {
                return new BuilderEncodedValues.BuilderShortEncodedValue(((ShortEncodedValue)encodedValue).getValue());
            }
            case 23: {
                return this.internStringEncodedValue((StringEncodedValue)encodedValue);
            }
            case 24: {
                return this.internTypeEncodedValue((TypeEncodedValue)encodedValue);
            }
        }
        throw new ExceptionWithContext("Unexpected encoded value type: %d", encodedValue.getValueType());
    }

    private BuilderEncodedValues.BuilderAnnotationEncodedValue internAnnotationEncodedValue(AnnotationEncodedValue value) {
        return new BuilderEncodedValues.BuilderAnnotationEncodedValue(((BuilderTypePool)this.typeSection).internType(value.getType()), this.internAnnotationElements(value.getElements()));
    }

    private BuilderEncodedValues.BuilderArrayEncodedValue internArrayEncodedValue(ArrayEncodedValue value) {
        return new BuilderEncodedValues.BuilderArrayEncodedValue((List<? extends BuilderEncodedValues.BuilderEncodedValue>)ImmutableList.copyOf((Iterator)Iterators.transform(value.getValue().iterator(), (Function)new Function<EncodedValue, BuilderEncodedValues.BuilderEncodedValue>(){

            public BuilderEncodedValues.BuilderEncodedValue apply(EncodedValue input) {
                return DexBuilder.this.internEncodedValue(input);
            }
        })));
    }

    private BuilderEncodedValues.BuilderEnumEncodedValue internEnumEncodedValue(EnumEncodedValue value) {
        return new BuilderEncodedValues.BuilderEnumEncodedValue(((BuilderFieldPool)this.fieldSection).internField(value.getValue()));
    }

    private BuilderEncodedValues.BuilderFieldEncodedValue internFieldEncodedValue(FieldEncodedValue value) {
        return new BuilderEncodedValues.BuilderFieldEncodedValue(((BuilderFieldPool)this.fieldSection).internField(value.getValue()));
    }

    private BuilderEncodedValues.BuilderMethodEncodedValue internMethodEncodedValue(MethodEncodedValue value) {
        return new BuilderEncodedValues.BuilderMethodEncodedValue(((BuilderMethodPool)this.methodSection).internMethod(value.getValue()));
    }

    private BuilderEncodedValues.BuilderStringEncodedValue internStringEncodedValue(StringEncodedValue string) {
        return new BuilderEncodedValues.BuilderStringEncodedValue(((BuilderStringPool)this.stringSection).internString(string.getValue()));
    }

    private BuilderEncodedValues.BuilderTypeEncodedValue internTypeEncodedValue(TypeEncodedValue type) {
        return new BuilderEncodedValues.BuilderTypeEncodedValue(((BuilderTypePool)this.typeSection).internType(type.getValue()));
    }

    protected class DexBuilderSectionProvider
    extends DexWriter.SectionProvider {
        protected DexBuilderSectionProvider() {
            super(DexBuilder.this);
        }

        public BuilderStringPool getStringSection() {
            return new BuilderStringPool();
        }

        public BuilderTypePool getTypeSection() {
            return new BuilderTypePool(DexBuilder.this);
        }

        public BuilderProtoPool getProtoSection() {
            return new BuilderProtoPool(DexBuilder.this);
        }

        public BuilderFieldPool getFieldSection() {
            return new BuilderFieldPool(DexBuilder.this);
        }

        public BuilderMethodPool getMethodSection() {
            return new BuilderMethodPool(DexBuilder.this);
        }

        public BuilderClassPool getClassSection() {
            return new BuilderClassPool(DexBuilder.this);
        }

        public BuilderTypeListPool getTypeListSection() {
            return new BuilderTypeListPool(DexBuilder.this);
        }

        public BuilderAnnotationPool getAnnotationSection() {
            return new BuilderAnnotationPool(DexBuilder.this);
        }

        public BuilderAnnotationSetPool getAnnotationSetSection() {
            return new BuilderAnnotationSetPool(DexBuilder.this);
        }
    }
}

