/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.dexbacked.value;

import java.util.Set;
import org.jf.dexlib2.base.value.BaseAnnotationEncodedValue;
import org.jf.dexlib2.dexbacked.DexBackedAnnotationElement;
import org.jf.dexlib2.dexbacked.DexBackedDexFile;
import org.jf.dexlib2.dexbacked.DexReader;
import org.jf.dexlib2.dexbacked.util.VariableSizeSet;
import org.jf.dexlib2.dexbacked.value.DexBackedEncodedValue;
import org.jf.dexlib2.iface.value.AnnotationEncodedValue;

public class DexBackedAnnotationEncodedValue
extends BaseAnnotationEncodedValue
implements AnnotationEncodedValue {
    public final DexBackedDexFile dexFile;
    public final String type;
    private final int elementCount;
    private final int elementsOffset;

    public DexBackedAnnotationEncodedValue(DexReader reader) {
        this.dexFile = (DexBackedDexFile)reader.dexBuf;
        this.type = this.dexFile.getType(reader.readSmallUleb128());
        this.elementCount = reader.readSmallUleb128();
        this.elementsOffset = reader.getOffset();
        DexBackedAnnotationEncodedValue.skipElements(reader, this.elementCount);
    }

    public static void skipFrom(DexReader reader) {
        reader.skipUleb128();
        int elementCount = reader.readSmallUleb128();
        DexBackedAnnotationEncodedValue.skipElements(reader, elementCount);
    }

    private static void skipElements(DexReader reader, int elementCount) {
        for (int i = 0; i < elementCount; ++i) {
            reader.skipUleb128();
            DexBackedEncodedValue.skipFrom(reader);
        }
    }

    @Override
    public String getType() {
        return this.type;
    }

    public Set<? extends DexBackedAnnotationElement> getElements() {
        return new VariableSizeSet<DexBackedAnnotationElement>(this.dexFile, this.elementsOffset, this.elementCount){

            @Override
            protected DexBackedAnnotationElement readNextItem(DexReader dexReader, int index) {
                return new DexBackedAnnotationElement(dexReader);
            }
        };
    }
}

