/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.dexbacked.reference;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.jf.dexlib2.base.reference.BaseMethodReference;
import org.jf.dexlib2.dexbacked.DexBackedDexFile;
import org.jf.dexlib2.dexbacked.reference.DexBackedMethodProtoReference;
import org.jf.dexlib2.dexbacked.util.FixedSizeList;

public class DexBackedMethodReference
extends BaseMethodReference {
    public final DexBackedDexFile dexFile;
    public final int methodIdItemOffset;
    private int protoIdItemOffset;

    public DexBackedMethodReference(DexBackedDexFile dexFile, int methodIndex) {
        this.dexFile = dexFile;
        this.methodIdItemOffset = dexFile.getMethodIdItemOffset(methodIndex);
    }

    @Override
    public String getDefiningClass() {
        return this.dexFile.getType(this.dexFile.readUshort(this.methodIdItemOffset + 0));
    }

    @Override
    public String getName() {
        return this.dexFile.getString(this.dexFile.readSmallUint(this.methodIdItemOffset + 4));
    }

    public List<String> getParameterTypes() {
        int protoIdItemOffset = this.getProtoIdItemOffset();
        int parametersOffset = this.dexFile.readSmallUint(protoIdItemOffset + 8);
        if (parametersOffset > 0) {
            final int parameterCount = this.dexFile.readSmallUint(parametersOffset + 0);
            final int paramListStart = parametersOffset + 4;
            return new FixedSizeList<String>(){

                @Override
                public String readItem(int index) {
                    return DexBackedMethodReference.this.dexFile.getType(DexBackedMethodReference.this.dexFile.readUshort(paramListStart + 2 * index));
                }

                @Override
                public int size() {
                    return parameterCount;
                }
            };
        }
        return ImmutableList.of();
    }

    @Override
    public String getReturnType() {
        int protoIdItemOffset = this.getProtoIdItemOffset();
        return this.dexFile.getType(this.dexFile.readSmallUint(protoIdItemOffset + 4));
    }

    private int getProtoIdItemOffset() {
        if (this.protoIdItemOffset == 0) {
            this.protoIdItemOffset = this.dexFile.getProtoIdItemOffset(this.dexFile.readUshort(this.methodIdItemOffset + 2));
        }
        return this.protoIdItemOffset;
    }

    public int getSize() {
        int size = 8;
        DexBackedMethodProtoReference protoRef = new DexBackedMethodProtoReference(this.dexFile, this.dexFile.readUshort(this.methodIdItemOffset + 2));
        return size += protoRef.getSize();
    }
}

