/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.dexbacked;

import com.google.common.collect.Lists;
import com.google.common.io.ByteStreams;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jf.dexlib2.Opcodes;
import org.jf.dexlib2.dexbacked.DexBackedDexFile;
import org.jf.dexlib2.iface.MultiDexContainer;
import org.jf.dexlib2.util.DexUtil;

public class ZipDexContainer
implements MultiDexContainer<ZipDexFile> {
    private final File zipFilePath;
    private final Opcodes opcodes;

    public ZipDexContainer(File zipFilePath, Opcodes opcodes) {
        this.zipFilePath = zipFilePath;
        this.opcodes = opcodes;
    }

    @Override
    public Opcodes getOpcodes() {
        return this.opcodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getDexEntryNames() throws IOException {
        ArrayList entryNames = Lists.newArrayList();
        try (ZipFile zipFile = this.getZipFile();){
            Enumeration<? extends ZipEntry> entriesEnumeration = zipFile.entries();
            while (entriesEnumeration.hasMoreElements()) {
                ZipEntry entry = entriesEnumeration.nextElement();
                if (!this.isDex(zipFile, entry)) continue;
                entryNames.add(entry.getName());
            }
            ArrayList arrayList = entryNames;
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ZipDexFile getEntry(String entryName) throws IOException {
        try (ZipFile zipFile = this.getZipFile();){
            ZipEntry entry = zipFile.getEntry(entryName);
            if (entry == null) {
                ZipDexFile zipDexFile = null;
                return zipDexFile;
            }
            ZipDexFile zipDexFile = this.loadEntry(zipFile, entry);
            return zipDexFile;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isZipFile() {
        ZipFile zipFile = null;
        try {
            zipFile = this.getZipFile();
            boolean bl = true;
            return bl;
        }
        catch (IOException ex) {
            boolean bl = false;
            return bl;
        }
        catch (NotAZipFileException ex) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isDex(ZipFile zipFile, ZipEntry zipEntry) throws IOException {
        try (BufferedInputStream inputStream = new BufferedInputStream(zipFile.getInputStream(zipEntry));){
            DexUtil.verifyDexHeader(inputStream);
        }
        return true;
    }

    protected ZipFile getZipFile() throws IOException {
        try {
            return new ZipFile(this.zipFilePath);
        }
        catch (IOException ex) {
            throw new NotAZipFileException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ZipDexFile loadEntry(ZipFile zipFile, ZipEntry zipEntry) throws IOException {
        try (InputStream inputStream = zipFile.getInputStream(zipEntry);){
            byte[] buf = ByteStreams.toByteArray((InputStream)inputStream);
            ZipDexFile zipDexFile = new ZipDexFile(this.opcodes, buf, zipEntry.getName());
            return zipDexFile;
        }
    }

    public static class NotAZipFileException
    extends RuntimeException {
    }

    public class ZipDexFile
    extends DexBackedDexFile
    implements MultiDexContainer.MultiDexFile {
        private final String entryName;

        protected ZipDexFile(Opcodes opcodes, byte[] buf, String entryName) {
            super(opcodes, buf, 0);
            this.entryName = entryName;
        }

        @Override
        public String getEntryName() {
            return this.entryName;
        }

        public MultiDexContainer getContainer() {
            return ZipDexContainer.this;
        }
    }
}

