/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.dexbacked;

import java.util.Set;
import org.jf.dexlib2.base.BaseAnnotation;
import org.jf.dexlib2.dexbacked.DexBackedAnnotationElement;
import org.jf.dexlib2.dexbacked.DexBackedDexFile;
import org.jf.dexlib2.dexbacked.DexReader;
import org.jf.dexlib2.dexbacked.util.VariableSizeSet;

public class DexBackedAnnotation
extends BaseAnnotation {
    public final DexBackedDexFile dexFile;
    public final int visibility;
    public final int typeIndex;
    private final int elementsOffset;

    public DexBackedAnnotation(DexBackedDexFile dexFile, int annotationOffset) {
        this.dexFile = dexFile;
        DexReader reader = dexFile.readerAt(annotationOffset);
        this.visibility = reader.readUbyte();
        this.typeIndex = reader.readSmallUleb128();
        this.elementsOffset = reader.getOffset();
    }

    @Override
    public int getVisibility() {
        return this.visibility;
    }

    @Override
    public String getType() {
        return this.dexFile.getType(this.typeIndex);
    }

    public Set<? extends DexBackedAnnotationElement> getElements() {
        DexReader reader = this.dexFile.readerAt(this.elementsOffset);
        int size = reader.readSmallUleb128();
        return new VariableSizeSet<DexBackedAnnotationElement>(this.dexFile, reader.getOffset(), size){

            @Override
            protected DexBackedAnnotationElement readNextItem(DexReader reader, int index) {
                return new DexBackedAnnotationElement(reader);
            }
        };
    }
}

