/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.d2j.tools.jar;

import com.googlecode.d2j.tools.jar.BaseWeaver;
import com.googlecode.dex2jar.tools.BaseCmd;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Modifier;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.objectweb.asm2.ClassReader;
import org.objectweb.asm2.ClassVisitor;
import org.objectweb.asm2.ClassWriter;
import org.objectweb.asm2.Label;
import org.objectweb.asm2.MethodVisitor;
import org.objectweb.asm2.Opcodes;
import org.objectweb.asm2.Type;
import org.objectweb.asm2.commons.Remapper;
import org.objectweb.asm2.commons.RemappingClassAdapter;
import org.objectweb.asm2.tree.InsnList;
import org.objectweb.asm2.tree.LocalVariableNode;
import org.objectweb.asm2.tree.MethodNode;
import org.objectweb.asm2.tree.TryCatchBlockNode;

public class InvocationWeaver
extends BaseWeaver
implements Opcodes {
    private static final Type OBJECT_TYPE = Type.getType(Object.class);
    private Remapper remapper = new Remapper(){

        public String mapDesc(String desc) {
            if (desc.length() == 1) {
                return desc;
            }
            String nDesc = (String)InvocationWeaver.this.clzDescMap.get(desc);
            return nDesc == null ? desc : nDesc;
        }
    };

    private static void box(Type arg, MethodVisitor mv) {
        switch (arg.getSort()) {
            case 9: 
            case 10: {
                return;
            }
            case 5: {
                mv.visitMethodInsn(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;");
                break;
            }
            case 7: {
                mv.visitMethodInsn(184, "java/lang/Long", "valueOf", "(J)Ljava/lang/Long;");
                break;
            }
            case 6: {
                mv.visitMethodInsn(184, "java/lang/Floag", "valueOf", "(F)Ljava/lang/Floag;");
                break;
            }
            case 8: {
                mv.visitMethodInsn(184, "java/lang/Double", "valueOf", "(D)Ljava/lang/Double;");
                break;
            }
            case 4: {
                mv.visitMethodInsn(184, "java/lang/Short", "valueOf", "(S)Ljava/lang/Short;");
                break;
            }
            case 2: {
                mv.visitMethodInsn(184, "java/lang/Character", "valueOf", "(C)Ljava/lang/Character;");
                break;
            }
            case 1: {
                mv.visitMethodInsn(184, "java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;");
                break;
            }
            case 3: {
                mv.visitMethodInsn(184, "java/lang/Byte", "valueOf", "(B)Ljava/lang/Byte;");
                break;
            }
            case 0: {
                mv.visitInsn(1);
            }
        }
    }

    private static void unBox(Type orgRet, Type nRet, MethodVisitor mv) {
        if (orgRet.equals((Object)nRet)) {
            return;
        }
        if (orgRet.getSort() == 0) {
            mv.visitInsn(nRet.getSize() == 1 ? 87 : 88);
        }
        if (nRet.getSort() != 10) {
            throw new RuntimeException("invalid ret type:" + nRet);
        }
        switch (orgRet.getSort()) {
            case 9: 
            case 10: {
                mv.visitTypeInsn(192, orgRet.getInternalName());
                break;
            }
            case 5: {
                mv.visitTypeInsn(192, "java/lang/Number");
                mv.visitMethodInsn(182, "java/lang/Number", "intValue", "()I");
                break;
            }
            case 6: {
                mv.visitTypeInsn(192, "java/lang/Number");
                mv.visitMethodInsn(182, "java/lang/Number", "floatValue", "()F");
                break;
            }
            case 7: {
                mv.visitTypeInsn(192, "java/lang/Number");
                mv.visitMethodInsn(182, "java/lang/Number", "longValue", "()J");
                break;
            }
            case 8: {
                mv.visitTypeInsn(192, "java/lang/Number");
                mv.visitMethodInsn(182, "java/lang/Number", "doubleValue", "()D");
                break;
            }
            case 3: {
                mv.visitTypeInsn(192, "java/lang/Number");
                mv.visitMethodInsn(182, "java/lang/Number", "byteValue", "()B");
                break;
            }
            case 4: {
                mv.visitTypeInsn(192, "java/lang/Number");
                mv.visitMethodInsn(182, "java/lang/Number", "shortValue", "()S");
                break;
            }
            case 2: {
                mv.visitTypeInsn(192, "java/lang/Character");
                mv.visitMethodInsn(182, "java/lang/Character", "charValue", "()C");
                break;
            }
            case 1: {
                mv.visitTypeInsn(192, "java/lang/Boolean");
                mv.visitMethodInsn(182, "java/lang/Boolean", "booleanValue", "()Z");
            }
        }
    }

    public byte[] wave0(byte[] data) throws IOException {
        ClassWriter cw = new ClassWriter(1);
        this.wave0(data, (ClassVisitor)cw);
        return cw.toByteArray();
    }

    public void wave0(byte[] data, ClassVisitor cv) throws IOException {
        new ClassReader(data).accept(this.wrapper(cv), 8);
    }

    public ClassVisitor wrapper(ClassVisitor cv) {
        return new RemappingClassAdapter(cv, this.remapper){
            Map<BaseWeaver.MtdInfo, BaseWeaver.MtdInfo> toCreate;
            String clzName;
            {
                this.toCreate = new HashMap<BaseWeaver.MtdInfo, BaseWeaver.MtdInfo>();
            }

            private BaseWeaver.MtdInfo newMethodA(int opcode, BaseWeaver.MtdInfo t, BaseWeaver.MtdInfo mapTo) {
                boolean hasThis;
                BaseWeaver.MtdInfo n = this.toCreate.get(t);
                if (n != null) {
                    return n;
                }
                n = new BaseWeaver.MtdInfo();
                n.owner = t.owner;
                n.name = InvocationWeaver.this.buildMethodAName(t.name);
                boolean bl = hasThis = opcode != 184;
                if (hasThis) {
                    Type[] args = Type.getArgumentTypes((String)t.desc);
                    Type ret = Type.getReturnType((String)t.desc);
                    ArrayList<Type> ts = new ArrayList<Type>(args.length + 1);
                    ts.add(Type.getType((String)t.owner));
                    ts.addAll(Arrays.asList(args));
                    n.desc = Type.getMethodDescriptor((Type)ret, (Type[])ts.toArray(new Type[ts.size()]));
                } else {
                    n.desc = t.desc;
                }
                this.toCreate.put(t, n);
                MethodVisitor mv = this.cv.visitMethod(4106, n.name, n.desc, null, null);
                mv.visitCode();
                this.genMethodACode(opcode, t, mapTo, mv, t);
                return n;
            }

            private void genMethodACode(int opcode, BaseWeaver.MtdInfo t, BaseWeaver.MtdInfo mapTo, MethodVisitor mv, BaseWeaver.MtdInfo src) {
                int start;
                boolean hasThis = opcode != 184;
                Type[] args = Type.getArgumentTypes((String)t.desc);
                Type ret = Type.getReturnType((String)t.desc);
                mv.visitTypeInsn(187, InvocationWeaver.this.getCurrentInvocationName());
                mv.visitInsn(89);
                if (hasThis) {
                    mv.visitVarInsn(25, 0);
                    start = 1;
                } else {
                    mv.visitInsn(1);
                    start = 0;
                }
                if (args.length == 0) {
                    mv.visitInsn(1);
                } else {
                    mv.visitLdcInsn((Object)args.length);
                    mv.visitTypeInsn(189, "java/lang/Object");
                    for (int i = 0; i < args.length; ++i) {
                        mv.visitInsn(89);
                        mv.visitLdcInsn((Object)i);
                        mv.visitVarInsn(args[i].getOpcode(21), i + start);
                        InvocationWeaver.box(args[i], mv);
                        mv.visitInsn(83);
                    }
                }
                int nextIdx = InvocationWeaver.this.callbacks.size();
                mv.visitLdcInsn((Object)nextIdx);
                mv.visitMethodInsn(183, InvocationWeaver.this.getCurrentInvocationName(), "<init>", "(Ljava/lang/Object;[Ljava/lang/Object;I)V");
                mv.visitMethodInsn(184, BaseWeaver.toInternal(mapTo.owner), mapTo.name, mapTo.desc);
                InvocationWeaver.unBox(ret, Type.getReturnType((String)mapTo.desc), mv);
                mv.visitInsn(ret.getOpcode(172));
                mv.visitMaxs(-1, -1);
                mv.visitEnd();
                BaseWeaver.Callback cb = new BaseWeaver.Callback();
                cb.idx = nextIdx;
                cb.callback = this.newMethodCallback(opcode, t);
                cb.target = src;
                cb.isSpecial = opcode == 183;
                cb.isStatic = opcode == 184;
                InvocationWeaver.this.callbacks.add(cb);
            }

            private BaseWeaver.MtdInfo newMethodCallback(int opcode, BaseWeaver.MtdInfo t) {
                int start;
                BaseWeaver.MtdInfo n = new BaseWeaver.MtdInfo();
                n.owner = "L" + this.className + ";";
                n.name = InvocationWeaver.this.buildCallbackMethodName(t.name);
                n.desc = opcode == 183 || opcode == 184 ? "([Ljava/lang/Object;)Ljava/lang/Object;" : "(Ljava/lang/Object;[Ljava/lang/Object;)Ljava/lang/Object;";
                MethodVisitor mv = this.cv.visitMethod(opcode == 183 ? 1 : 9, n.name, n.desc, null, null);
                mv.visitCode();
                if (opcode != 184) {
                    mv.visitVarInsn(25, 0);
                    if (opcode != 183) {
                        mv.visitTypeInsn(192, BaseWeaver.toInternal(t.owner));
                    }
                    start = 1;
                } else {
                    start = 0;
                }
                Type[] args = Type.getArgumentTypes((String)t.desc);
                for (int i = 0; i < args.length; ++i) {
                    mv.visitVarInsn(25, start);
                    mv.visitLdcInsn((Object)i);
                    mv.visitInsn(50);
                    InvocationWeaver.unBox(args[i], OBJECT_TYPE, mv);
                }
                mv.visitMethodInsn(opcode, BaseWeaver.toInternal(t.owner), t.name, t.desc);
                Type ret = Type.getReturnType((String)t.desc);
                InvocationWeaver.box(ret, mv);
                mv.visitInsn(176);
                mv.visitMaxs(-1, -1);
                mv.visitEnd();
                return n;
            }

            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                super.visit(version, access, name, signature, superName, interfaces);
                this.clzName = name;
            }

            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                final MethodVisitor superMv = this.superMethodVisitor(access, name, desc, signature, exceptions);
                final BaseWeaver.MtdInfo mapTo = InvocationWeaver.this.findDefinedTargetMethod("L" + this.clzName + ";", name, desc);
                if (mapTo != null) {
                    BaseWeaver.MtdInfo t1 = new BaseWeaver.MtdInfo();
                    t1.owner = "L" + this.clzName + ";";
                    t1.name = InvocationWeaver.this.buildMethodAName(name);
                    t1.desc = desc;
                    final BaseWeaver.MtdInfo t = t1;
                    final BaseWeaver.MtdInfo src = new BaseWeaver.MtdInfo();
                    src.owner = t.owner;
                    src.name = name;
                    src.desc = desc;
                    return new MethodNode(262144, access, name, desc, signature, exceptions){

                        public void visitEnd() {
                            InsnList instructions = this.instructions;
                            List tryCatchBlocks = this.tryCatchBlocks;
                            List localVariables = this.localVariables;
                            this.instructions = new InsnList();
                            this.tryCatchBlocks = new ArrayList();
                            this.localVariables = new ArrayList();
                            this.maxLocals = -1;
                            this.maxStack = -1;
                            this.accept(superMv);
                            int opcode = Modifier.isStatic(this.access) ? 184 : 182;
                            this.genMethodACode(opcode, t, mapTo, superMv, src);
                            int newAccess = this.access & 0xFFFFFFF9 | 1;
                            MethodVisitor rmv = this.wrap(this.superMethodVisitor(newAccess, t.name, this.desc, null, null));
                            if (rmv != null) {
                                int i;
                                rmv.visitCode();
                                int n = tryCatchBlocks == null ? 0 : tryCatchBlocks.size();
                                for (i = 0; i < n; ++i) {
                                    ((TryCatchBlockNode)tryCatchBlocks.get(i)).accept(rmv);
                                }
                                instructions.accept(rmv);
                                n = localVariables == null ? 0 : localVariables.size();
                                for (i = 0; i < n; ++i) {
                                    ((LocalVariableNode)localVariables.get(i)).accept(rmv);
                                }
                                rmv.visitMaxs(-1, -1);
                                rmv.visitEnd();
                            }
                        }
                    };
                }
                return this.wrap(superMv);
            }

            private MethodVisitor superMethodVisitor(int access, String name, String desc, String signature, String[] exceptions) {
                return super.visitMethod(access, name, desc, signature, exceptions);
            }

            MethodVisitor wrap(MethodVisitor mv) {
                return mv == null ? null : new ReplaceMethodVisitor(mv);
            }

            class ReplaceMethodVisitor
            extends MethodVisitor {
                public ReplaceMethodVisitor(MethodVisitor mv) {
                    super(262144, mv);
                }

                public void visitMethodInsn(int opcode, String owner, String name, String desc) {
                    BaseWeaver.MtdInfo mapTo = InvocationWeaver.this.findTargetMethod("L" + owner + ";", name, desc);
                    if (mapTo != null) {
                        boolean isStatic = opcode == 184;
                        Type orgRet = Type.getReturnType((String)desc);
                        Object[] orgArgs = Type.getArgumentTypes((String)desc);
                        Type nRet = Type.getReturnType((String)mapTo.desc);
                        Object[] nArgs = Type.getArgumentTypes((String)mapTo.desc);
                        if (orgRet.getSort() != 0 && nRet.getSort() == 0) {
                            throw new RuntimeException("can't cast " + nRet + " to " + orgRet);
                        }
                        if (nArgs.length == 1 && nArgs[0].getDescriptor().equals(InvocationWeaver.this.invocationInterfaceDesc)) {
                            BaseWeaver.MtdInfo t = new BaseWeaver.MtdInfo();
                            t.owner = "L" + owner + ";";
                            t.name = name;
                            t.desc = desc;
                            BaseWeaver.MtdInfo n = this.newMethodA(opcode, t, mapTo);
                            super.visitMethodInsn(184, clzName, n.name, n.desc);
                        } else {
                            if (isStatic) {
                                if (!Arrays.deepEquals(orgArgs, nArgs)) {
                                    throw new RuntimeException("arguments not equal: " + owner + "." + name + desc + " <> " + mapTo.owner + "." + mapTo.name + mapTo.desc);
                                }
                            } else {
                                if (nArgs.length != orgArgs.length + 1) {
                                    throw new RuntimeException("arguments not equal: " + owner + "." + name + desc + " <> " + mapTo.owner + "." + mapTo.name + mapTo.desc);
                                }
                                if (orgArgs.length > 0) {
                                    for (int i = 0; i < orgArgs.length; ++i) {
                                        if (orgArgs[i].equals(nArgs[i + 1])) continue;
                                        throw new RuntimeException("arguments not equal: " + owner + "." + name + desc + " <> " + mapTo.owner + "." + mapTo.name + mapTo.desc);
                                    }
                                }
                            }
                            super.visitMethodInsn(184, BaseWeaver.toInternal(mapTo.owner), mapTo.name, mapTo.desc);
                            InvocationWeaver.unBox(orgRet, nRet, this.mv);
                        }
                    } else {
                        super.visitMethodInsn(opcode, owner, name, desc);
                    }
                }
            }
        };
    }

    public void wave(Path from, final Path to) throws IOException {
        BaseCmd.walkJarOrDir((Path)from, (BaseCmd.FileVisitorX)new BaseCmd.FileVisitorX(){

            public void visitFile(Path file, String relative) throws IOException {
                String name = relative;
                Path targetPath = to.resolve(relative);
                BaseCmd.createParentDirectories((Path)targetPath);
                if (name.endsWith(".class")) {
                    String clzName = name.substring(0, name.length() - ".class".length());
                    if (InvocationWeaver.this.ignores.contains(clzName)) {
                        Files.copy(file, targetPath, new CopyOption[0]);
                    } else {
                        byte[] out = InvocationWeaver.this.wave0(Files.readAllBytes(file));
                        Files.write(targetPath, out, new OpenOption[0]);
                    }
                } else if (name.startsWith("META-INF/")) {
                    if (name.equals("META-INF/MANIFEST.MF")) {
                        try (InputStream in = Files.newInputStream(file, new OpenOption[0]);){
                            Manifest mf = new Manifest(in);
                            mf.getMainAttributes().put(new Attributes.Name("X-NOTICE"), "Modified");
                            mf.getEntries().clear();
                            ByteArrayOutputStream baos = new ByteArrayOutputStream();
                            mf.write(baos);
                            baos.flush();
                            Files.write(targetPath, baos.toByteArray(), new OpenOption[0]);
                        }
                    } else if (!(name.endsWith(".DSA") || name.endsWith(".RSA") || name.endsWith(".SF") || name.endsWith(".ECDSA"))) {
                        Files.copy(file, targetPath, new CopyOption[0]);
                    }
                } else {
                    Files.copy(file, targetPath, new CopyOption[0]);
                }
            }
        });
        if (this.callbacks.size() > 0) {
            ClassWriter cw = new ClassWriter(1);
            String type = this.buildInvocationClz((ClassVisitor)cw);
            byte[] data = cw.toByteArray();
            Path target = to.resolve(type + ".class");
            BaseCmd.createParentDirectories((Path)target);
            Files.write(target, data, new OpenOption[0]);
            this.nextInvocationName();
        }
    }

    public String buildInvocationClz(ClassVisitor cw) {
        int i;
        String typeName = this.getCurrentInvocationName();
        cw.visit(50, 1, typeName, null, "java/lang/Object", new String[]{InvocationWeaver.toInternal(this.invocationInterfaceDesc)});
        cw.visitField(18, "thiz", "Ljava/lang/Object;", null, null).visitEnd();
        cw.visitField(18, "args", "[Ljava/lang/Object;", null, null).visitEnd();
        cw.visitField(18, "idx", "I", null, null).visitEnd();
        MethodVisitor mv = cw.visitMethod(1, "<init>", "(Ljava/lang/Object;[Ljava/lang/Object;I)V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V");
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitFieldInsn(181, typeName, "thiz", "Ljava/lang/Object;");
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 2);
        mv.visitFieldInsn(181, typeName, "args", "[Ljava/lang/Object;");
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(21, 3);
        mv.visitFieldInsn(181, typeName, "idx", "I");
        mv.visitInsn(177);
        mv.visitMaxs(-1, -1);
        mv.visitEnd();
        this.genSwitchMethod(cw, typeName, "getMethodOwner", new CB(){

            @Override
            public String getKey(BaseWeaver.MtdInfo mtd) {
                return BaseWeaver.toInternal(mtd.owner);
            }
        });
        this.genSwitchMethod(cw, typeName, "getMethodName", new CB(){

            @Override
            public String getKey(BaseWeaver.MtdInfo mtd) {
                return mtd.name;
            }
        });
        this.genSwitchMethod(cw, typeName, "getMethodDesc", new CB(){

            @Override
            public String getKey(BaseWeaver.MtdInfo mtd) {
                return mtd.desc;
            }
        });
        mv = cw.visitMethod(1, "getArguments", "()[Ljava/lang/Object;", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, typeName, "args", "[Ljava/lang/Object;");
        mv.visitInsn(176);
        mv.visitMaxs(-1, -1);
        mv.visitEnd();
        mv = cw.visitMethod(1, "getThis", "()Ljava/lang/Object;", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, typeName, "thiz", "Ljava/lang/Object;");
        mv.visitInsn(176);
        mv.visitMaxs(-1, -1);
        mv.visitEnd();
        mv = cw.visitMethod(1, "proceed", "()Ljava/lang/Object;", null, new String[]{"java/lang/Throwable"});
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, typeName, "idx", "I");
        Label def = new Label();
        Label[] labels = new Label[this.callbacks.size()];
        for (i = 0; i < labels.length; ++i) {
            labels[i] = new Label();
        }
        mv.visitTableSwitchInsn(0, this.callbacks.size() - 1, def, labels);
        for (i = 0; i < labels.length; ++i) {
            mv.visitLabel(labels[i]);
            BaseWeaver.Callback cb = (BaseWeaver.Callback)this.callbacks.get(i);
            BaseWeaver.MtdInfo m = (BaseWeaver.MtdInfo)cb.callback;
            if (cb.isStatic) {
                mv.visitVarInsn(25, 0);
                mv.visitFieldInsn(180, typeName, "args", "[Ljava/lang/Object;");
                mv.visitMethodInsn(184, InvocationWeaver.toInternal(m.owner), m.name, m.desc);
            } else if (cb.isSpecial) {
                mv.visitVarInsn(25, 0);
                mv.visitFieldInsn(180, typeName, "thiz", "Ljava/lang/Object;");
                mv.visitTypeInsn(192, InvocationWeaver.toInternal(m.owner));
                mv.visitVarInsn(25, 0);
                mv.visitFieldInsn(180, typeName, "args", "[Ljava/lang/Object;");
                mv.visitMethodInsn(182, InvocationWeaver.toInternal(m.owner), m.name, m.desc);
            } else {
                mv.visitVarInsn(25, 0);
                mv.visitFieldInsn(180, typeName, "thiz", "Ljava/lang/Object;");
                mv.visitVarInsn(25, 0);
                mv.visitFieldInsn(180, typeName, "args", "[Ljava/lang/Object;");
                mv.visitMethodInsn(184, InvocationWeaver.toInternal(m.owner), m.name, m.desc);
            }
            Type ret = Type.getReturnType((String)m.desc);
            InvocationWeaver.box(ret, mv);
            mv.visitInsn(ret.getOpcode(172));
        }
        mv.visitLabel(def);
        mv.visitTypeInsn(187, "java/lang/RuntimeException");
        mv.visitInsn(89);
        mv.visitLdcInsn((Object)"invalid idx");
        mv.visitMethodInsn(183, "java/lang/RuntimeException", "<init>", "(Ljava/lang/String;)V");
        mv.visitInsn(191);
        mv.visitMaxs(-1, -1);
        mv.visitEnd();
        return typeName;
    }

    private void genSwitchMethod(ClassVisitor cw, String typeName, String methodName, CB callback) {
        MethodVisitor mv = cw.visitMethod(1, methodName, "()Ljava/lang/String;", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, typeName, "idx", "I");
        Label def = new Label();
        Label[] labels = new Label[this.callbacks.size()];
        TreeMap<String, Label> strMap = new TreeMap<String, Label>();
        for (int i = 0; i < labels.length; ++i) {
            BaseWeaver.Callback cb = (BaseWeaver.Callback)this.callbacks.get(i);
            String key = callback.getKey((BaseWeaver.MtdInfo)cb.target);
            Label label = (Label)strMap.get(key);
            if (label == null) {
                label = new Label();
                strMap.put(key, label);
            }
            labels[i] = label;
        }
        mv.visitTableSwitchInsn(0, this.callbacks.size() - 1, def, labels);
        for (Map.Entry e : strMap.entrySet()) {
            mv.visitLabel((Label)e.getValue());
            mv.visitLdcInsn(e.getKey());
            mv.visitInsn(176);
        }
        mv.visitLabel(def);
        mv.visitTypeInsn(187, "java/lang/RuntimeException");
        mv.visitInsn(89);
        mv.visitLdcInsn((Object)"invalid idx");
        mv.visitMethodInsn(183, "java/lang/RuntimeException", "<init>", "(Ljava/lang/String;)V");
        mv.visitInsn(191);
        mv.visitMaxs(-1, -1);
        mv.visitEnd();
    }

    static interface CB {
        public String getKey(BaseWeaver.MtdInfo var1);
    }
}

