/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.cloudmersive.client.rt.model.ZipFile;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Representation of a directory in a zip file")
@JsonPropertyOrder(value={"DirectoryName", "DirectoriesInDirectory", "FilesInDirectory"})
@JsonTypeName(value="ZipDirectory")
public class ZipDirectory {
    public static final String JSON_PROPERTY_DIRECTORY_NAME = "DirectoryName";
    private String directoryName;
    public static final String JSON_PROPERTY_DIRECTORIES_IN_DIRECTORY = "DirectoriesInDirectory";
    private List<ZipDirectory> directoriesInDirectory = null;
    public static final String JSON_PROPERTY_FILES_IN_DIRECTORY = "FilesInDirectory";
    private List<ZipFile> filesInDirectory = null;

    public ZipDirectory directoryName(String directoryName) {
        this.directoryName = directoryName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Name of this directory")
    @JsonProperty(value="DirectoryName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDirectoryName() {
        return this.directoryName;
    }

    public void setDirectoryName(String directoryName) {
        this.directoryName = directoryName;
    }

    public ZipDirectory directoriesInDirectory(List<ZipDirectory> directoriesInDirectory) {
        this.directoriesInDirectory = directoriesInDirectory;
        return this;
    }

    public ZipDirectory addDirectoriesInDirectoryItem(ZipDirectory directoriesInDirectoryItem) {
        if (this.directoriesInDirectory == null) {
            this.directoriesInDirectory = new ArrayList<ZipDirectory>();
        }
        this.directoriesInDirectory.add(directoriesInDirectoryItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Child directories contained directly in this directory")
    @JsonProperty(value="DirectoriesInDirectory")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<ZipDirectory> getDirectoriesInDirectory() {
        return this.directoriesInDirectory;
    }

    public void setDirectoriesInDirectory(List<ZipDirectory> directoriesInDirectory) {
        this.directoriesInDirectory = directoriesInDirectory;
    }

    public ZipDirectory filesInDirectory(List<ZipFile> filesInDirectory) {
        this.filesInDirectory = filesInDirectory;
        return this;
    }

    public ZipDirectory addFilesInDirectoryItem(ZipFile filesInDirectoryItem) {
        if (this.filesInDirectory == null) {
            this.filesInDirectory = new ArrayList<ZipFile>();
        }
        this.filesInDirectory.add(filesInDirectoryItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Child files contained directly in this directory")
    @JsonProperty(value="FilesInDirectory")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<ZipFile> getFilesInDirectory() {
        return this.filesInDirectory;
    }

    public void setFilesInDirectory(List<ZipFile> filesInDirectory) {
        this.filesInDirectory = filesInDirectory;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ZipDirectory zipDirectory = (ZipDirectory)o;
        return Objects.equals(this.directoryName, zipDirectory.directoryName) && Objects.equals(this.directoriesInDirectory, zipDirectory.directoriesInDirectory) && Objects.equals(this.filesInDirectory, zipDirectory.filesInDirectory);
    }

    public int hashCode() {
        return Objects.hash(this.directoryName, this.directoriesInDirectory, this.filesInDirectory);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ZipDirectory {\n");
        sb.append("    directoryName: ").append(this.toIndentedString(this.directoryName)).append("\n");
        sb.append("    directoriesInDirectory: ").append(this.toIndentedString(this.directoriesInDirectory)).append("\n");
        sb.append("    filesInDirectory: ").append(this.toIndentedString(this.filesInDirectory)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

