/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Result of performing a filter operation on XML input using XPath")
@JsonPropertyOrder(value={"Successful", "XmlNodes", "ResultCount"})
@JsonTypeName(value="XmlFilterWithXPathResult")
public class XmlFilterWithXPathResult {
    public static final String JSON_PROPERTY_SUCCESSFUL = "Successful";
    private Boolean successful;
    public static final String JSON_PROPERTY_XML_NODES = "XmlNodes";
    private List<String> xmlNodes = null;
    public static final String JSON_PROPERTY_RESULT_COUNT = "ResultCount";
    private Integer resultCount;

    public XmlFilterWithXPathResult successful(Boolean successful) {
        this.successful = successful;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="True if the operation was successful, false otherwise")
    @JsonProperty(value="Successful")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSuccessful() {
        return this.successful;
    }

    public void setSuccessful(Boolean successful) {
        this.successful = successful;
    }

    public XmlFilterWithXPathResult xmlNodes(List<String> xmlNodes) {
        this.xmlNodes = xmlNodes;
        return this;
    }

    public XmlFilterWithXPathResult addXmlNodesItem(String xmlNodesItem) {
        if (this.xmlNodes == null) {
            this.xmlNodes = new ArrayList<String>();
        }
        this.xmlNodes.add(xmlNodesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Matching selected XML nodes as strings")
    @JsonProperty(value="XmlNodes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getXmlNodes() {
        return this.xmlNodes;
    }

    public void setXmlNodes(List<String> xmlNodes) {
        this.xmlNodes = xmlNodes;
    }

    public XmlFilterWithXPathResult resultCount(Integer resultCount) {
        this.resultCount = resultCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Count of the matching results")
    @JsonProperty(value="ResultCount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getResultCount() {
        return this.resultCount;
    }

    public void setResultCount(Integer resultCount) {
        this.resultCount = resultCount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        XmlFilterWithXPathResult xmlFilterWithXPathResult = (XmlFilterWithXPathResult)o;
        return Objects.equals(this.successful, xmlFilterWithXPathResult.successful) && Objects.equals(this.xmlNodes, xmlFilterWithXPathResult.xmlNodes) && Objects.equals(this.resultCount, xmlFilterWithXPathResult.resultCount);
    }

    public int hashCode() {
        return Objects.hash(this.successful, this.xmlNodes, this.resultCount);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class XmlFilterWithXPathResult {\n");
        sb.append("    successful: ").append(this.toIndentedString(this.successful)).append("\n");
        sb.append("    xmlNodes: ").append(this.toIndentedString(this.xmlNodes)).append("\n");
        sb.append("    resultCount: ").append(this.toIndentedString(this.resultCount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

