/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.cloudmersive.client.rt.model.VirusFound;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Result of running a virus scan")
@JsonPropertyOrder(value={"CleanResult", "FoundViruses"})
@JsonTypeName(value="VirusScanResult")
public class VirusScanResult {
    public static final String JSON_PROPERTY_CLEAN_RESULT = "CleanResult";
    private Boolean cleanResult;
    public static final String JSON_PROPERTY_FOUND_VIRUSES = "FoundViruses";
    private List<VirusFound> foundViruses = null;

    public VirusScanResult cleanResult(Boolean cleanResult) {
        this.cleanResult = cleanResult;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="True if the scan contained no viruses, false otherwise")
    @JsonProperty(value="CleanResult")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getCleanResult() {
        return this.cleanResult;
    }

    public void setCleanResult(Boolean cleanResult) {
        this.cleanResult = cleanResult;
    }

    public VirusScanResult foundViruses(List<VirusFound> foundViruses) {
        this.foundViruses = foundViruses;
        return this;
    }

    public VirusScanResult addFoundVirusesItem(VirusFound foundVirusesItem) {
        if (this.foundViruses == null) {
            this.foundViruses = new ArrayList<VirusFound>();
        }
        this.foundViruses.add(foundVirusesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Array of viruses found, if any")
    @JsonProperty(value="FoundViruses")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<VirusFound> getFoundViruses() {
        return this.foundViruses;
    }

    public void setFoundViruses(List<VirusFound> foundViruses) {
        this.foundViruses = foundViruses;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VirusScanResult virusScanResult = (VirusScanResult)o;
        return Objects.equals(this.cleanResult, virusScanResult.cleanResult) && Objects.equals(this.foundViruses, virusScanResult.foundViruses);
    }

    public int hashCode() {
        return Objects.hash(this.cleanResult, this.foundViruses);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class VirusScanResult {\n");
        sb.append("    cleanResult: ").append(this.toIndentedString(this.cleanResult)).append("\n");
        sb.append("    foundViruses: ").append(this.toIndentedString(this.foundViruses)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

