/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.cloudmersive.client.rt.model.VirusFound;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Result of running an advanced virus scan")
@JsonPropertyOrder(value={"CleanResult", "ContainsExecutable", "ContainsInvalidFile", "ContainsScript", "ContainsPasswordProtectedFile", "ContainsRestrictedFileFormat", "VerifiedFileFormat", "FoundViruses"})
@JsonTypeName(value="VirusScanAdvancedResult")
public class VirusScanAdvancedResult {
    public static final String JSON_PROPERTY_CLEAN_RESULT = "CleanResult";
    private Boolean cleanResult;
    public static final String JSON_PROPERTY_CONTAINS_EXECUTABLE = "ContainsExecutable";
    private Boolean containsExecutable;
    public static final String JSON_PROPERTY_CONTAINS_INVALID_FILE = "ContainsInvalidFile";
    private Boolean containsInvalidFile;
    public static final String JSON_PROPERTY_CONTAINS_SCRIPT = "ContainsScript";
    private Boolean containsScript;
    public static final String JSON_PROPERTY_CONTAINS_PASSWORD_PROTECTED_FILE = "ContainsPasswordProtectedFile";
    private Boolean containsPasswordProtectedFile;
    public static final String JSON_PROPERTY_CONTAINS_RESTRICTED_FILE_FORMAT = "ContainsRestrictedFileFormat";
    private Boolean containsRestrictedFileFormat;
    public static final String JSON_PROPERTY_VERIFIED_FILE_FORMAT = "VerifiedFileFormat";
    private String verifiedFileFormat;
    public static final String JSON_PROPERTY_FOUND_VIRUSES = "FoundViruses";
    private List<VirusFound> foundViruses = null;

    public VirusScanAdvancedResult cleanResult(Boolean cleanResult) {
        this.cleanResult = cleanResult;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="True if the scan contained no viruses, false otherwise")
    @JsonProperty(value="CleanResult")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getCleanResult() {
        return this.cleanResult;
    }

    public void setCleanResult(Boolean cleanResult) {
        this.cleanResult = cleanResult;
    }

    public VirusScanAdvancedResult containsExecutable(Boolean containsExecutable) {
        this.containsExecutable = containsExecutable;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="True if the scan contained an executable (application code), which can be a significant risk factor")
    @JsonProperty(value="ContainsExecutable")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getContainsExecutable() {
        return this.containsExecutable;
    }

    public void setContainsExecutable(Boolean containsExecutable) {
        this.containsExecutable = containsExecutable;
    }

    public VirusScanAdvancedResult containsInvalidFile(Boolean containsInvalidFile) {
        this.containsInvalidFile = containsInvalidFile;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="True if the scan contained an invalid file (such as a PDF that is not a valid PDF, Word Document that is not a valid Word Document, etc.), which can be a significant risk factor")
    @JsonProperty(value="ContainsInvalidFile")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getContainsInvalidFile() {
        return this.containsInvalidFile;
    }

    public void setContainsInvalidFile(Boolean containsInvalidFile) {
        this.containsInvalidFile = containsInvalidFile;
    }

    public VirusScanAdvancedResult containsScript(Boolean containsScript) {
        this.containsScript = containsScript;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="True if the scan contained a script (such as a PHP script, Python script, etc.) which can be a significant risk factor")
    @JsonProperty(value="ContainsScript")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getContainsScript() {
        return this.containsScript;
    }

    public void setContainsScript(Boolean containsScript) {
        this.containsScript = containsScript;
    }

    public VirusScanAdvancedResult containsPasswordProtectedFile(Boolean containsPasswordProtectedFile) {
        this.containsPasswordProtectedFile = containsPasswordProtectedFile;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="True if the scan contained a password protected or encrypted file, which can be a significant risk factor")
    @JsonProperty(value="ContainsPasswordProtectedFile")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getContainsPasswordProtectedFile() {
        return this.containsPasswordProtectedFile;
    }

    public void setContainsPasswordProtectedFile(Boolean containsPasswordProtectedFile) {
        this.containsPasswordProtectedFile = containsPasswordProtectedFile;
    }

    public VirusScanAdvancedResult containsRestrictedFileFormat(Boolean containsRestrictedFileFormat) {
        this.containsRestrictedFileFormat = containsRestrictedFileFormat;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="True if the uploaded file is of a type that is not allowed based on the optional restrictFileTypes parameter, false otherwise; if restrictFileTypes is not set, this will always be false")
    @JsonProperty(value="ContainsRestrictedFileFormat")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getContainsRestrictedFileFormat() {
        return this.containsRestrictedFileFormat;
    }

    public void setContainsRestrictedFileFormat(Boolean containsRestrictedFileFormat) {
        this.containsRestrictedFileFormat = containsRestrictedFileFormat;
    }

    public VirusScanAdvancedResult verifiedFileFormat(String verifiedFileFormat) {
        this.verifiedFileFormat = verifiedFileFormat;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="For file format verification-supported file formats, the contents-verified file format of the file.  Null indicates that the file format is not supported for contents verification.  If a Virus or Malware is found, this field will always be set to Null.")
    @JsonProperty(value="VerifiedFileFormat")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getVerifiedFileFormat() {
        return this.verifiedFileFormat;
    }

    public void setVerifiedFileFormat(String verifiedFileFormat) {
        this.verifiedFileFormat = verifiedFileFormat;
    }

    public VirusScanAdvancedResult foundViruses(List<VirusFound> foundViruses) {
        this.foundViruses = foundViruses;
        return this;
    }

    public VirusScanAdvancedResult addFoundVirusesItem(VirusFound foundVirusesItem) {
        if (this.foundViruses == null) {
            this.foundViruses = new ArrayList<VirusFound>();
        }
        this.foundViruses.add(foundVirusesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Array of viruses found, if any")
    @JsonProperty(value="FoundViruses")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<VirusFound> getFoundViruses() {
        return this.foundViruses;
    }

    public void setFoundViruses(List<VirusFound> foundViruses) {
        this.foundViruses = foundViruses;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VirusScanAdvancedResult virusScanAdvancedResult = (VirusScanAdvancedResult)o;
        return Objects.equals(this.cleanResult, virusScanAdvancedResult.cleanResult) && Objects.equals(this.containsExecutable, virusScanAdvancedResult.containsExecutable) && Objects.equals(this.containsInvalidFile, virusScanAdvancedResult.containsInvalidFile) && Objects.equals(this.containsScript, virusScanAdvancedResult.containsScript) && Objects.equals(this.containsPasswordProtectedFile, virusScanAdvancedResult.containsPasswordProtectedFile) && Objects.equals(this.containsRestrictedFileFormat, virusScanAdvancedResult.containsRestrictedFileFormat) && Objects.equals(this.verifiedFileFormat, virusScanAdvancedResult.verifiedFileFormat) && Objects.equals(this.foundViruses, virusScanAdvancedResult.foundViruses);
    }

    public int hashCode() {
        return Objects.hash(this.cleanResult, this.containsExecutable, this.containsInvalidFile, this.containsScript, this.containsPasswordProtectedFile, this.containsRestrictedFileFormat, this.verifiedFileFormat, this.foundViruses);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class VirusScanAdvancedResult {\n");
        sb.append("    cleanResult: ").append(this.toIndentedString(this.cleanResult)).append("\n");
        sb.append("    containsExecutable: ").append(this.toIndentedString(this.containsExecutable)).append("\n");
        sb.append("    containsInvalidFile: ").append(this.toIndentedString(this.containsInvalidFile)).append("\n");
        sb.append("    containsScript: ").append(this.toIndentedString(this.containsScript)).append("\n");
        sb.append("    containsPasswordProtectedFile: ").append(this.toIndentedString(this.containsPasswordProtectedFile)).append("\n");
        sb.append("    containsRestrictedFileFormat: ").append(this.toIndentedString(this.containsRestrictedFileFormat)).append("\n");
        sb.append("    verifiedFileFormat: ").append(this.toIndentedString(this.verifiedFileFormat)).append("\n");
        sb.append("    foundViruses: ").append(this.toIndentedString(this.foundViruses)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

