/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="A video file")
@JsonPropertyOrder(value={"VideoNumber", "Content"})
@JsonTypeName(value="VideoFile")
public class VideoFile {
    public static final String JSON_PROPERTY_VIDEO_NUMBER = "VideoNumber";
    private Integer videoNumber;
    public static final String JSON_PROPERTY_CONTENT = "Content";
    private byte[] content;

    public VideoFile videoNumber(Integer videoNumber) {
        this.videoNumber = videoNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Sequence number of the video")
    @JsonProperty(value="VideoNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getVideoNumber() {
        return this.videoNumber;
    }

    public void setVideoNumber(Integer videoNumber) {
        this.videoNumber = videoNumber;
    }

    public VideoFile content(byte[] content) {
        this.content = content;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The video file as a byte array")
    @JsonProperty(value="Content")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public byte[] getContent() {
        return this.content;
    }

    public void setContent(byte[] content) {
        this.content = content;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VideoFile videoFile = (VideoFile)o;
        return Objects.equals(this.videoNumber, videoFile.videoNumber) && Arrays.equals(this.content, videoFile.content);
    }

    public int hashCode() {
        return Objects.hash(this.videoNumber, Arrays.hashCode(this.content));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class VideoFile {\n");
        sb.append("    videoNumber: ").append(this.toIndentedString(this.videoNumber)).append("\n");
        sb.append("    content: ").append(this.toIndentedString(this.content)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

