/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.cloudmersive.client.rt.model.DetectedLicensePlate;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Result of detecting vehicle license plates in an image")
@JsonPropertyOrder(value={"Successful", "DetectedLicensePlates", "DetectedLicensePlateCount"})
@JsonTypeName(value="VehicleLicensePlateDetectionResult")
public class VehicleLicensePlateDetectionResult {
    public static final String JSON_PROPERTY_SUCCESSFUL = "Successful";
    private Boolean successful;
    public static final String JSON_PROPERTY_DETECTED_LICENSE_PLATES = "DetectedLicensePlates";
    private List<DetectedLicensePlate> detectedLicensePlates = null;
    public static final String JSON_PROPERTY_DETECTED_LICENSE_PLATE_COUNT = "DetectedLicensePlateCount";
    private Integer detectedLicensePlateCount;

    public VehicleLicensePlateDetectionResult successful(Boolean successful) {
        this.successful = successful;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Was the image processed successfully?")
    @JsonProperty(value="Successful")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSuccessful() {
        return this.successful;
    }

    public void setSuccessful(Boolean successful) {
        this.successful = successful;
    }

    public VehicleLicensePlateDetectionResult detectedLicensePlates(List<DetectedLicensePlate> detectedLicensePlates) {
        this.detectedLicensePlates = detectedLicensePlates;
        return this;
    }

    public VehicleLicensePlateDetectionResult addDetectedLicensePlatesItem(DetectedLicensePlate detectedLicensePlatesItem) {
        if (this.detectedLicensePlates == null) {
            this.detectedLicensePlates = new ArrayList<DetectedLicensePlate>();
        }
        this.detectedLicensePlates.add(detectedLicensePlatesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="License plates found in the image")
    @JsonProperty(value="DetectedLicensePlates")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<DetectedLicensePlate> getDetectedLicensePlates() {
        return this.detectedLicensePlates;
    }

    public void setDetectedLicensePlates(List<DetectedLicensePlate> detectedLicensePlates) {
        this.detectedLicensePlates = detectedLicensePlates;
    }

    public VehicleLicensePlateDetectionResult detectedLicensePlateCount(Integer detectedLicensePlateCount) {
        this.detectedLicensePlateCount = detectedLicensePlateCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of license plates detected in the image")
    @JsonProperty(value="DetectedLicensePlateCount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getDetectedLicensePlateCount() {
        return this.detectedLicensePlateCount;
    }

    public void setDetectedLicensePlateCount(Integer detectedLicensePlateCount) {
        this.detectedLicensePlateCount = detectedLicensePlateCount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VehicleLicensePlateDetectionResult vehicleLicensePlateDetectionResult = (VehicleLicensePlateDetectionResult)o;
        return Objects.equals(this.successful, vehicleLicensePlateDetectionResult.successful) && Objects.equals(this.detectedLicensePlates, vehicleLicensePlateDetectionResult.detectedLicensePlates) && Objects.equals(this.detectedLicensePlateCount, vehicleLicensePlateDetectionResult.detectedLicensePlateCount);
    }

    public int hashCode() {
        return Objects.hash(this.successful, this.detectedLicensePlates, this.detectedLicensePlateCount);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class VehicleLicensePlateDetectionResult {\n");
        sb.append("    successful: ").append(this.toIndentedString(this.successful)).append("\n");
        sb.append("    detectedLicensePlates: ").append(this.toIndentedString(this.detectedLicensePlates)).append("\n");
        sb.append("    detectedLicensePlateCount: ").append(this.toIndentedString(this.detectedLicensePlateCount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

