/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"CountryCode", "VatNumber", "IsValid", "BusinessName", "BusinessAddress", "BusinessBuilding", "BusinessStreetNumber", "BusinessStreet", "BusinessCity", "BusinessStateOrProvince", "BusinessPostalCode", "BusinessCountry"})
@JsonTypeName(value="VatLookupResponse")
public class VatLookupResponse {
    public static final String JSON_PROPERTY_COUNTRY_CODE = "CountryCode";
    private String countryCode;
    public static final String JSON_PROPERTY_VAT_NUMBER = "VatNumber";
    private String vatNumber;
    public static final String JSON_PROPERTY_IS_VALID = "IsValid";
    private Boolean isValid;
    public static final String JSON_PROPERTY_BUSINESS_NAME = "BusinessName";
    private String businessName;
    public static final String JSON_PROPERTY_BUSINESS_ADDRESS = "BusinessAddress";
    private String businessAddress;
    public static final String JSON_PROPERTY_BUSINESS_BUILDING = "BusinessBuilding";
    private String businessBuilding;
    public static final String JSON_PROPERTY_BUSINESS_STREET_NUMBER = "BusinessStreetNumber";
    private String businessStreetNumber;
    public static final String JSON_PROPERTY_BUSINESS_STREET = "BusinessStreet";
    private String businessStreet;
    public static final String JSON_PROPERTY_BUSINESS_CITY = "BusinessCity";
    private String businessCity;
    public static final String JSON_PROPERTY_BUSINESS_STATE_OR_PROVINCE = "BusinessStateOrProvince";
    private String businessStateOrProvince;
    public static final String JSON_PROPERTY_BUSINESS_POSTAL_CODE = "BusinessPostalCode";
    private String businessPostalCode;
    public static final String JSON_PROPERTY_BUSINESS_COUNTRY = "BusinessCountry";
    private String businessCountry;

    public VatLookupResponse countryCode(String countryCode) {
        this.countryCode = countryCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Two-letter country code")
    @JsonProperty(value="CountryCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCountryCode() {
        return this.countryCode;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public VatLookupResponse vatNumber(String vatNumber) {
        this.vatNumber = vatNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="VAT number")
    @JsonProperty(value="VatNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getVatNumber() {
        return this.vatNumber;
    }

    public void setVatNumber(String vatNumber) {
        this.vatNumber = vatNumber;
    }

    public VatLookupResponse isValid(Boolean isValid) {
        this.isValid = isValid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="True if the VAT code is valid, false otherwise")
    @JsonProperty(value="IsValid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIsValid() {
        return this.isValid;
    }

    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }

    public VatLookupResponse businessName(String businessName) {
        this.businessName = businessName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Name of the business")
    @JsonProperty(value="BusinessName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBusinessName() {
        return this.businessName;
    }

    public void setBusinessName(String businessName) {
        this.businessName = businessName;
    }

    public VatLookupResponse businessAddress(String businessAddress) {
        this.businessAddress = businessAddress;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Business address as a single string")
    @JsonProperty(value="BusinessAddress")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBusinessAddress() {
        return this.businessAddress;
    }

    public void setBusinessAddress(String businessAddress) {
        this.businessAddress = businessAddress;
    }

    public VatLookupResponse businessBuilding(String businessBuilding) {
        this.businessBuilding = businessBuilding;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="For the business address, the name of the building, house or structure if applicable, such as \"Cloudmersive Building 2\".  This will often by null.")
    @JsonProperty(value="BusinessBuilding")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBusinessBuilding() {
        return this.businessBuilding;
    }

    public void setBusinessBuilding(String businessBuilding) {
        this.businessBuilding = businessBuilding;
    }

    public VatLookupResponse businessStreetNumber(String businessStreetNumber) {
        this.businessStreetNumber = businessStreetNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="For the business address, the street number or house number of the address.  For example, in the address \"1600 Pennsylvania Avenue NW\" the street number would be \"1600\".  This value will typically be populated for most addresses.")
    @JsonProperty(value="BusinessStreetNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBusinessStreetNumber() {
        return this.businessStreetNumber;
    }

    public void setBusinessStreetNumber(String businessStreetNumber) {
        this.businessStreetNumber = businessStreetNumber;
    }

    public VatLookupResponse businessStreet(String businessStreet) {
        this.businessStreet = businessStreet;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="For the business address, the name of the street or road of the address.  For example, in the address \"1600 Pennsylvania Avenue NW\" the street number would be \"Pennsylvania Avenue NW\".")
    @JsonProperty(value="BusinessStreet")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBusinessStreet() {
        return this.businessStreet;
    }

    public void setBusinessStreet(String businessStreet) {
        this.businessStreet = businessStreet;
    }

    public VatLookupResponse businessCity(String businessCity) {
        this.businessCity = businessCity;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="For the business address, the city of the address.")
    @JsonProperty(value="BusinessCity")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBusinessCity() {
        return this.businessCity;
    }

    public void setBusinessCity(String businessCity) {
        this.businessCity = businessCity;
    }

    public VatLookupResponse businessStateOrProvince(String businessStateOrProvince) {
        this.businessStateOrProvince = businessStateOrProvince;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="For the business address, the state or province of the address.")
    @JsonProperty(value="BusinessStateOrProvince")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBusinessStateOrProvince() {
        return this.businessStateOrProvince;
    }

    public void setBusinessStateOrProvince(String businessStateOrProvince) {
        this.businessStateOrProvince = businessStateOrProvince;
    }

    public VatLookupResponse businessPostalCode(String businessPostalCode) {
        this.businessPostalCode = businessPostalCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="For the business address, the postal code or zip code of the address.")
    @JsonProperty(value="BusinessPostalCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBusinessPostalCode() {
        return this.businessPostalCode;
    }

    public void setBusinessPostalCode(String businessPostalCode) {
        this.businessPostalCode = businessPostalCode;
    }

    public VatLookupResponse businessCountry(String businessCountry) {
        this.businessCountry = businessCountry;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="For the business address, country of the address, if present in the address.  If not included in the address it will be null.")
    @JsonProperty(value="BusinessCountry")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBusinessCountry() {
        return this.businessCountry;
    }

    public void setBusinessCountry(String businessCountry) {
        this.businessCountry = businessCountry;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VatLookupResponse vatLookupResponse = (VatLookupResponse)o;
        return Objects.equals(this.countryCode, vatLookupResponse.countryCode) && Objects.equals(this.vatNumber, vatLookupResponse.vatNumber) && Objects.equals(this.isValid, vatLookupResponse.isValid) && Objects.equals(this.businessName, vatLookupResponse.businessName) && Objects.equals(this.businessAddress, vatLookupResponse.businessAddress) && Objects.equals(this.businessBuilding, vatLookupResponse.businessBuilding) && Objects.equals(this.businessStreetNumber, vatLookupResponse.businessStreetNumber) && Objects.equals(this.businessStreet, vatLookupResponse.businessStreet) && Objects.equals(this.businessCity, vatLookupResponse.businessCity) && Objects.equals(this.businessStateOrProvince, vatLookupResponse.businessStateOrProvince) && Objects.equals(this.businessPostalCode, vatLookupResponse.businessPostalCode) && Objects.equals(this.businessCountry, vatLookupResponse.businessCountry);
    }

    public int hashCode() {
        return Objects.hash(this.countryCode, this.vatNumber, this.isValid, this.businessName, this.businessAddress, this.businessBuilding, this.businessStreetNumber, this.businessStreet, this.businessCity, this.businessStateOrProvince, this.businessPostalCode, this.businessCountry);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class VatLookupResponse {\n");
        sb.append("    countryCode: ").append(this.toIndentedString(this.countryCode)).append("\n");
        sb.append("    vatNumber: ").append(this.toIndentedString(this.vatNumber)).append("\n");
        sb.append("    isValid: ").append(this.toIndentedString(this.isValid)).append("\n");
        sb.append("    businessName: ").append(this.toIndentedString(this.businessName)).append("\n");
        sb.append("    businessAddress: ").append(this.toIndentedString(this.businessAddress)).append("\n");
        sb.append("    businessBuilding: ").append(this.toIndentedString(this.businessBuilding)).append("\n");
        sb.append("    businessStreetNumber: ").append(this.toIndentedString(this.businessStreetNumber)).append("\n");
        sb.append("    businessStreet: ").append(this.toIndentedString(this.businessStreet)).append("\n");
        sb.append("    businessCity: ").append(this.toIndentedString(this.businessCity)).append("\n");
        sb.append("    businessStateOrProvince: ").append(this.toIndentedString(this.businessStateOrProvince)).append("\n");
        sb.append("    businessPostalCode: ").append(this.toIndentedString(this.businessPostalCode)).append("\n");
        sb.append("    businessCountry: ").append(this.toIndentedString(this.businessCountry)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

