/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Identifier validation request, including the input identifier as well as various identifier rules")
@JsonPropertyOrder(value={"Input", "AllowWhitespace", "AllowHyphens", "AllowUnderscore", "AllowNumbers", "AllowPeriods", "MaxLength", "MinLength"})
@JsonTypeName(value="ValidateIdentifierRequest")
public class ValidateIdentifierRequest {
    public static final String JSON_PROPERTY_INPUT = "Input";
    private String input;
    public static final String JSON_PROPERTY_ALLOW_WHITESPACE = "AllowWhitespace";
    private Boolean allowWhitespace;
    public static final String JSON_PROPERTY_ALLOW_HYPHENS = "AllowHyphens";
    private Boolean allowHyphens;
    public static final String JSON_PROPERTY_ALLOW_UNDERSCORE = "AllowUnderscore";
    private Boolean allowUnderscore;
    public static final String JSON_PROPERTY_ALLOW_NUMBERS = "AllowNumbers";
    private Boolean allowNumbers;
    public static final String JSON_PROPERTY_ALLOW_PERIODS = "AllowPeriods";
    private Boolean allowPeriods;
    public static final String JSON_PROPERTY_MAX_LENGTH = "MaxLength";
    private Integer maxLength;
    public static final String JSON_PROPERTY_MIN_LENGTH = "MinLength";
    private Integer minLength;

    public ValidateIdentifierRequest input(String input) {
        this.input = input;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Text string identifier input")
    @JsonProperty(value="Input")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getInput() {
        return this.input;
    }

    public void setInput(String input) {
        this.input = input;
    }

    public ValidateIdentifierRequest allowWhitespace(Boolean allowWhitespace) {
        this.allowWhitespace = allowWhitespace;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="True if whitespace is allowed in the identifier, false otherwise")
    @JsonProperty(value="AllowWhitespace")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getAllowWhitespace() {
        return this.allowWhitespace;
    }

    public void setAllowWhitespace(Boolean allowWhitespace) {
        this.allowWhitespace = allowWhitespace;
    }

    public ValidateIdentifierRequest allowHyphens(Boolean allowHyphens) {
        this.allowHyphens = allowHyphens;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="True if hyphens are allowd in the identifier, false otherwise")
    @JsonProperty(value="AllowHyphens")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getAllowHyphens() {
        return this.allowHyphens;
    }

    public void setAllowHyphens(Boolean allowHyphens) {
        this.allowHyphens = allowHyphens;
    }

    public ValidateIdentifierRequest allowUnderscore(Boolean allowUnderscore) {
        this.allowUnderscore = allowUnderscore;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="True if underscores are allowed in the identifier, false otherwise")
    @JsonProperty(value="AllowUnderscore")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getAllowUnderscore() {
        return this.allowUnderscore;
    }

    public void setAllowUnderscore(Boolean allowUnderscore) {
        this.allowUnderscore = allowUnderscore;
    }

    public ValidateIdentifierRequest allowNumbers(Boolean allowNumbers) {
        this.allowNumbers = allowNumbers;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="True if numbers are allowed in the identifier, false otherwise")
    @JsonProperty(value="AllowNumbers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getAllowNumbers() {
        return this.allowNumbers;
    }

    public void setAllowNumbers(Boolean allowNumbers) {
        this.allowNumbers = allowNumbers;
    }

    public ValidateIdentifierRequest allowPeriods(Boolean allowPeriods) {
        this.allowPeriods = allowPeriods;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="True if periods are allowed in the identifier, false otherwise")
    @JsonProperty(value="AllowPeriods")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getAllowPeriods() {
        return this.allowPeriods;
    }

    public void setAllowPeriods(Boolean allowPeriods) {
        this.allowPeriods = allowPeriods;
    }

    public ValidateIdentifierRequest maxLength(Integer maxLength) {
        this.maxLength = maxLength;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional; maximum length, if any, of the identifier")
    @JsonProperty(value="MaxLength")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(Integer maxLength) {
        this.maxLength = maxLength;
    }

    public ValidateIdentifierRequest minLength(Integer minLength) {
        this.minLength = minLength;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional; minimum length, if any, of the identifier")
    @JsonProperty(value="MinLength")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getMinLength() {
        return this.minLength;
    }

    public void setMinLength(Integer minLength) {
        this.minLength = minLength;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ValidateIdentifierRequest validateIdentifierRequest = (ValidateIdentifierRequest)o;
        return Objects.equals(this.input, validateIdentifierRequest.input) && Objects.equals(this.allowWhitespace, validateIdentifierRequest.allowWhitespace) && Objects.equals(this.allowHyphens, validateIdentifierRequest.allowHyphens) && Objects.equals(this.allowUnderscore, validateIdentifierRequest.allowUnderscore) && Objects.equals(this.allowNumbers, validateIdentifierRequest.allowNumbers) && Objects.equals(this.allowPeriods, validateIdentifierRequest.allowPeriods) && Objects.equals(this.maxLength, validateIdentifierRequest.maxLength) && Objects.equals(this.minLength, validateIdentifierRequest.minLength);
    }

    public int hashCode() {
        return Objects.hash(this.input, this.allowWhitespace, this.allowHyphens, this.allowUnderscore, this.allowNumbers, this.allowPeriods, this.maxLength, this.minLength);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ValidateIdentifierRequest {\n");
        sb.append("    input: ").append(this.toIndentedString(this.input)).append("\n");
        sb.append("    allowWhitespace: ").append(this.toIndentedString(this.allowWhitespace)).append("\n");
        sb.append("    allowHyphens: ").append(this.toIndentedString(this.allowHyphens)).append("\n");
        sb.append("    allowUnderscore: ").append(this.toIndentedString(this.allowUnderscore)).append("\n");
        sb.append("    allowNumbers: ").append(this.toIndentedString(this.allowNumbers)).append("\n");
        sb.append("    allowPeriods: ").append(this.toIndentedString(this.allowPeriods)).append("\n");
        sb.append("    maxLength: ").append(this.toIndentedString(this.maxLength)).append("\n");
        sb.append("    minLength: ").append(this.toIndentedString(this.minLength)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

