/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.cloudmersive.client.rt.model.Timezone;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Result of performing a country validation operation")
@JsonPropertyOrder(value={"Successful", "CountryFullName", "ISOTwoLetterCode", "FIPSTwoLetterCode", "ThreeLetterCode", "IsEuropeanUnionMember", "Timezones", "ISOCurrencyCode", "CurrencySymbol", "CurrencyEnglishName", "Region", "Subregion"})
@JsonTypeName(value="ValidateCountryResponse")
public class ValidateCountryResponse {
    public static final String JSON_PROPERTY_SUCCESSFUL = "Successful";
    private Boolean successful;
    public static final String JSON_PROPERTY_COUNTRY_FULL_NAME = "CountryFullName";
    private String countryFullName;
    public static final String JSON_PROPERTY_IS_O_TWO_LETTER_CODE = "ISOTwoLetterCode";
    private String isOTwoLetterCode;
    public static final String JSON_PROPERTY_FI_P_S_TWO_LETTER_CODE = "FIPSTwoLetterCode";
    private String fiPSTwoLetterCode;
    public static final String JSON_PROPERTY_THREE_LETTER_CODE = "ThreeLetterCode";
    private String threeLetterCode;
    public static final String JSON_PROPERTY_IS_EUROPEAN_UNION_MEMBER = "IsEuropeanUnionMember";
    private Boolean isEuropeanUnionMember;
    public static final String JSON_PROPERTY_TIMEZONES = "Timezones";
    private List<Timezone> timezones = null;
    public static final String JSON_PROPERTY_IS_O_CURRENCY_CODE = "ISOCurrencyCode";
    private String isOCurrencyCode;
    public static final String JSON_PROPERTY_CURRENCY_SYMBOL = "CurrencySymbol";
    private String currencySymbol;
    public static final String JSON_PROPERTY_CURRENCY_ENGLISH_NAME = "CurrencyEnglishName";
    private String currencyEnglishName;
    public static final String JSON_PROPERTY_REGION = "Region";
    private String region;
    public static final String JSON_PROPERTY_SUBREGION = "Subregion";
    private String subregion;

    public ValidateCountryResponse successful(Boolean successful) {
        this.successful = successful;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="True if successful, false otherwise")
    @JsonProperty(value="Successful")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSuccessful() {
        return this.successful;
    }

    public void setSuccessful(Boolean successful) {
        this.successful = successful;
    }

    public ValidateCountryResponse countryFullName(String countryFullName) {
        this.countryFullName = countryFullName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Full name of the country")
    @JsonProperty(value="CountryFullName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCountryFullName() {
        return this.countryFullName;
    }

    public void setCountryFullName(String countryFullName) {
        this.countryFullName = countryFullName;
    }

    public ValidateCountryResponse isOTwoLetterCode(String isOTwoLetterCode) {
        this.isOTwoLetterCode = isOTwoLetterCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Two-letter ISO 3166-1 country code")
    @JsonProperty(value="ISOTwoLetterCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getIsOTwoLetterCode() {
        return this.isOTwoLetterCode;
    }

    public void setIsOTwoLetterCode(String isOTwoLetterCode) {
        this.isOTwoLetterCode = isOTwoLetterCode;
    }

    public ValidateCountryResponse fiPSTwoLetterCode(String fiPSTwoLetterCode) {
        this.fiPSTwoLetterCode = fiPSTwoLetterCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Two-letter FIPS 10-4 country code")
    @JsonProperty(value="FIPSTwoLetterCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFiPSTwoLetterCode() {
        return this.fiPSTwoLetterCode;
    }

    public void setFiPSTwoLetterCode(String fiPSTwoLetterCode) {
        this.fiPSTwoLetterCode = fiPSTwoLetterCode;
    }

    public ValidateCountryResponse threeLetterCode(String threeLetterCode) {
        this.threeLetterCode = threeLetterCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Three-letter ISO 3166-1 country code")
    @JsonProperty(value="ThreeLetterCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getThreeLetterCode() {
        return this.threeLetterCode;
    }

    public void setThreeLetterCode(String threeLetterCode) {
        this.threeLetterCode = threeLetterCode;
    }

    public ValidateCountryResponse isEuropeanUnionMember(Boolean isEuropeanUnionMember) {
        this.isEuropeanUnionMember = isEuropeanUnionMember;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="True if this country is currently a member of the European Union (EU), false otherwise")
    @JsonProperty(value="IsEuropeanUnionMember")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIsEuropeanUnionMember() {
        return this.isEuropeanUnionMember;
    }

    public void setIsEuropeanUnionMember(Boolean isEuropeanUnionMember) {
        this.isEuropeanUnionMember = isEuropeanUnionMember;
    }

    public ValidateCountryResponse timezones(List<Timezone> timezones) {
        this.timezones = timezones;
        return this;
    }

    public ValidateCountryResponse addTimezonesItem(Timezone timezonesItem) {
        if (this.timezones == null) {
            this.timezones = new ArrayList<Timezone>();
        }
        this.timezones.add(timezonesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Time zones (IANA/Olsen) in the country")
    @JsonProperty(value="Timezones")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Timezone> getTimezones() {
        return this.timezones;
    }

    public void setTimezones(List<Timezone> timezones) {
        this.timezones = timezones;
    }

    public ValidateCountryResponse isOCurrencyCode(String isOCurrencyCode) {
        this.isOCurrencyCode = isOCurrencyCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ISO 4217 currency three-letter code associated with the country")
    @JsonProperty(value="ISOCurrencyCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getIsOCurrencyCode() {
        return this.isOCurrencyCode;
    }

    public void setIsOCurrencyCode(String isOCurrencyCode) {
        this.isOCurrencyCode = isOCurrencyCode;
    }

    public ValidateCountryResponse currencySymbol(String currencySymbol) {
        this.currencySymbol = currencySymbol;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Symbol associated with the currency")
    @JsonProperty(value="CurrencySymbol")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCurrencySymbol() {
        return this.currencySymbol;
    }

    public void setCurrencySymbol(String currencySymbol) {
        this.currencySymbol = currencySymbol;
    }

    public ValidateCountryResponse currencyEnglishName(String currencyEnglishName) {
        this.currencyEnglishName = currencyEnglishName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Full name of the currency")
    @JsonProperty(value="CurrencyEnglishName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCurrencyEnglishName() {
        return this.currencyEnglishName;
    }

    public void setCurrencyEnglishName(String currencyEnglishName) {
        this.currencyEnglishName = currencyEnglishName;
    }

    public ValidateCountryResponse region(String region) {
        this.region = region;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Region (continent) in which the country is located; possible values are None, Europe, Americas, Asia, Africa, Oceania")
    @JsonProperty(value="Region")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public ValidateCountryResponse subregion(String subregion) {
        this.subregion = subregion;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Subregion in which the country is located; possible values are None, NorthernEurope, WesternEurope, SouthernEurope, EasternEurope, CentralAmerica, NorthernAmerica, SouthAmerica, EasternAfrica, MiddleAfrica, NorthernAfrica , SouthernAfrica , WesternAfrica , CentralAsia , EasternAsia , SouthernAsia , SouthEasternAsia , WesternAsia , Southern , Middle , AustraliaandNewZealand , Melanesia , Polynesia , Micronesia , Caribbean,")
    @JsonProperty(value="Subregion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSubregion() {
        return this.subregion;
    }

    public void setSubregion(String subregion) {
        this.subregion = subregion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ValidateCountryResponse validateCountryResponse = (ValidateCountryResponse)o;
        return Objects.equals(this.successful, validateCountryResponse.successful) && Objects.equals(this.countryFullName, validateCountryResponse.countryFullName) && Objects.equals(this.isOTwoLetterCode, validateCountryResponse.isOTwoLetterCode) && Objects.equals(this.fiPSTwoLetterCode, validateCountryResponse.fiPSTwoLetterCode) && Objects.equals(this.threeLetterCode, validateCountryResponse.threeLetterCode) && Objects.equals(this.isEuropeanUnionMember, validateCountryResponse.isEuropeanUnionMember) && Objects.equals(this.timezones, validateCountryResponse.timezones) && Objects.equals(this.isOCurrencyCode, validateCountryResponse.isOCurrencyCode) && Objects.equals(this.currencySymbol, validateCountryResponse.currencySymbol) && Objects.equals(this.currencyEnglishName, validateCountryResponse.currencyEnglishName) && Objects.equals(this.region, validateCountryResponse.region) && Objects.equals(this.subregion, validateCountryResponse.subregion);
    }

    public int hashCode() {
        return Objects.hash(this.successful, this.countryFullName, this.isOTwoLetterCode, this.fiPSTwoLetterCode, this.threeLetterCode, this.isEuropeanUnionMember, this.timezones, this.isOCurrencyCode, this.currencySymbol, this.currencyEnglishName, this.region, this.subregion);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ValidateCountryResponse {\n");
        sb.append("    successful: ").append(this.toIndentedString(this.successful)).append("\n");
        sb.append("    countryFullName: ").append(this.toIndentedString(this.countryFullName)).append("\n");
        sb.append("    isOTwoLetterCode: ").append(this.toIndentedString(this.isOTwoLetterCode)).append("\n");
        sb.append("    fiPSTwoLetterCode: ").append(this.toIndentedString(this.fiPSTwoLetterCode)).append("\n");
        sb.append("    threeLetterCode: ").append(this.toIndentedString(this.threeLetterCode)).append("\n");
        sb.append("    isEuropeanUnionMember: ").append(this.toIndentedString(this.isEuropeanUnionMember)).append("\n");
        sb.append("    timezones: ").append(this.toIndentedString(this.timezones)).append("\n");
        sb.append("    isOCurrencyCode: ").append(this.toIndentedString(this.isOCurrencyCode)).append("\n");
        sb.append("    currencySymbol: ").append(this.toIndentedString(this.currencySymbol)).append("\n");
        sb.append("    currencyEnglishName: ").append(this.toIndentedString(this.currencyEnglishName)).append("\n");
        sb.append("    region: ").append(this.toIndentedString(this.region)).append("\n");
        sb.append("    subregion: ").append(this.toIndentedString(this.subregion)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

