/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Request to convert a URL to a PDF file")
@JsonPropertyOrder(value={"Url", "ExtraLoadingWait", "IncludeBackgroundGraphics", "ScaleFactor"})
@JsonTypeName(value="UrlToPdfRequest")
public class UrlToPdfRequest {
    public static final String JSON_PROPERTY_URL = "Url";
    private String url;
    public static final String JSON_PROPERTY_EXTRA_LOADING_WAIT = "ExtraLoadingWait";
    private Integer extraLoadingWait;
    public static final String JSON_PROPERTY_INCLUDE_BACKGROUND_GRAPHICS = "IncludeBackgroundGraphics";
    private Boolean includeBackgroundGraphics;
    public static final String JSON_PROPERTY_SCALE_FACTOR = "ScaleFactor";
    private Integer scaleFactor;

    public UrlToPdfRequest url(String url) {
        this.url = url;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="URL address of the website to screenshot.  HTTP and HTTPS are both supported, as are custom ports.")
    @JsonProperty(value="Url")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public UrlToPdfRequest extraLoadingWait(Integer extraLoadingWait) {
        this.extraLoadingWait = extraLoadingWait;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional: Additional number of milliseconds to wait once the web page has finished loading before taking the screenshot.  Can be helpful for highly asynchronous websites.  Provide a value of 0 for the default of 5000 milliseconds (5 seconds). Maximum is 20000 milliseconds (20 seconds).")
    @JsonProperty(value="ExtraLoadingWait")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getExtraLoadingWait() {
        return this.extraLoadingWait;
    }

    public void setExtraLoadingWait(Integer extraLoadingWait) {
        this.extraLoadingWait = extraLoadingWait;
    }

    public UrlToPdfRequest includeBackgroundGraphics(Boolean includeBackgroundGraphics) {
        this.includeBackgroundGraphics = includeBackgroundGraphics;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional: Set to true to include background graphics in the PDF, or false to not include.  Default is true.")
    @JsonProperty(value="IncludeBackgroundGraphics")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIncludeBackgroundGraphics() {
        return this.includeBackgroundGraphics;
    }

    public void setIncludeBackgroundGraphics(Boolean includeBackgroundGraphics) {
        this.includeBackgroundGraphics = includeBackgroundGraphics;
    }

    public UrlToPdfRequest scaleFactor(Integer scaleFactor) {
        this.scaleFactor = scaleFactor;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional: Set to 100 to scale at 100%, set to 50% to scale down to 50% scale, set to 200% to scale up to 200% scale, etc.  Default is 100%. Maximum is 1000%")
    @JsonProperty(value="ScaleFactor")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getScaleFactor() {
        return this.scaleFactor;
    }

    public void setScaleFactor(Integer scaleFactor) {
        this.scaleFactor = scaleFactor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UrlToPdfRequest urlToPdfRequest = (UrlToPdfRequest)o;
        return Objects.equals(this.url, urlToPdfRequest.url) && Objects.equals(this.extraLoadingWait, urlToPdfRequest.extraLoadingWait) && Objects.equals(this.includeBackgroundGraphics, urlToPdfRequest.includeBackgroundGraphics) && Objects.equals(this.scaleFactor, urlToPdfRequest.scaleFactor);
    }

    public int hashCode() {
        return Objects.hash(this.url, this.extraLoadingWait, this.includeBackgroundGraphics, this.scaleFactor);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UrlToPdfRequest {\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    extraLoadingWait: ").append(this.toIndentedString(this.extraLoadingWait)).append("\n");
        sb.append("    includeBackgroundGraphics: ").append(this.toIndentedString(this.includeBackgroundGraphics)).append("\n");
        sb.append("    scaleFactor: ").append(this.toIndentedString(this.scaleFactor)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

