/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.cloudmersive.client.rt.model.DocxTableCell;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Input to a Update Table Cell request")
@JsonPropertyOrder(value={"InputFileBytes", "InputFileUrl", "CellToUpdate", "TableRowIndex", "TableCellIndex", "ExistingTablePath"})
@JsonTypeName(value="UpdateDocxTableCellRequest")
public class UpdateDocxTableCellRequest {
    public static final String JSON_PROPERTY_INPUT_FILE_BYTES = "InputFileBytes";
    private byte[] inputFileBytes;
    public static final String JSON_PROPERTY_INPUT_FILE_URL = "InputFileUrl";
    private String inputFileUrl;
    public static final String JSON_PROPERTY_CELL_TO_UPDATE = "CellToUpdate";
    private DocxTableCell cellToUpdate;
    public static final String JSON_PROPERTY_TABLE_ROW_INDEX = "TableRowIndex";
    private Integer tableRowIndex;
    public static final String JSON_PROPERTY_TABLE_CELL_INDEX = "TableCellIndex";
    private Integer tableCellIndex;
    public static final String JSON_PROPERTY_EXISTING_TABLE_PATH = "ExistingTablePath";
    private String existingTablePath;

    public UpdateDocxTableCellRequest inputFileBytes(byte[] inputFileBytes) {
        this.inputFileBytes = inputFileBytes;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional: Bytes of the input file to operate on")
    @JsonProperty(value="InputFileBytes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public byte[] getInputFileBytes() {
        return this.inputFileBytes;
    }

    public void setInputFileBytes(byte[] inputFileBytes) {
        this.inputFileBytes = inputFileBytes;
    }

    public UpdateDocxTableCellRequest inputFileUrl(String inputFileUrl) {
        this.inputFileUrl = inputFileUrl;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional: URL of a file to operate on as input.  This can be a public URL, or you can also use the begin-editing API to upload a document and pass in the secure URL result from that operation as the URL here (this URL is not public).")
    @JsonProperty(value="InputFileUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getInputFileUrl() {
        return this.inputFileUrl;
    }

    public void setInputFileUrl(String inputFileUrl) {
        this.inputFileUrl = inputFileUrl;
    }

    public UpdateDocxTableCellRequest cellToUpdate(DocxTableCell cellToUpdate) {
        this.cellToUpdate = cellToUpdate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="CellToUpdate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public DocxTableCell getCellToUpdate() {
        return this.cellToUpdate;
    }

    public void setCellToUpdate(DocxTableCell cellToUpdate) {
        this.cellToUpdate = cellToUpdate;
    }

    public UpdateDocxTableCellRequest tableRowIndex(Integer tableRowIndex) {
        this.tableRowIndex = tableRowIndex;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="0-based index of the Table Row to update")
    @JsonProperty(value="TableRowIndex")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getTableRowIndex() {
        return this.tableRowIndex;
    }

    public void setTableRowIndex(Integer tableRowIndex) {
        this.tableRowIndex = tableRowIndex;
    }

    public UpdateDocxTableCellRequest tableCellIndex(Integer tableCellIndex) {
        this.tableCellIndex = tableCellIndex;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="0-based index of the Table Cell (within the row) to update")
    @JsonProperty(value="TableCellIndex")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getTableCellIndex() {
        return this.tableCellIndex;
    }

    public void setTableCellIndex(Integer tableCellIndex) {
        this.tableCellIndex = tableCellIndex;
    }

    public UpdateDocxTableCellRequest existingTablePath(String existingTablePath) {
        this.existingTablePath = existingTablePath;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Required; the path to the existing table to modify")
    @JsonProperty(value="ExistingTablePath")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getExistingTablePath() {
        return this.existingTablePath;
    }

    public void setExistingTablePath(String existingTablePath) {
        this.existingTablePath = existingTablePath;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateDocxTableCellRequest updateDocxTableCellRequest = (UpdateDocxTableCellRequest)o;
        return Arrays.equals(this.inputFileBytes, updateDocxTableCellRequest.inputFileBytes) && Objects.equals(this.inputFileUrl, updateDocxTableCellRequest.inputFileUrl) && Objects.equals(this.cellToUpdate, updateDocxTableCellRequest.cellToUpdate) && Objects.equals(this.tableRowIndex, updateDocxTableCellRequest.tableRowIndex) && Objects.equals(this.tableCellIndex, updateDocxTableCellRequest.tableCellIndex) && Objects.equals(this.existingTablePath, updateDocxTableCellRequest.existingTablePath);
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.inputFileBytes), this.inputFileUrl, this.cellToUpdate, this.tableRowIndex, this.tableCellIndex, this.existingTablePath);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UpdateDocxTableCellRequest {\n");
        sb.append("    inputFileBytes: ").append(this.toIndentedString(this.inputFileBytes)).append("\n");
        sb.append("    inputFileUrl: ").append(this.toIndentedString(this.inputFileUrl)).append("\n");
        sb.append("    cellToUpdate: ").append(this.toIndentedString(this.cellToUpdate)).append("\n");
        sb.append("    tableRowIndex: ").append(this.toIndentedString(this.tableRowIndex)).append("\n");
        sb.append("    tableCellIndex: ").append(this.toIndentedString(this.tableCellIndex)).append("\n");
        sb.append("    existingTablePath: ").append(this.toIndentedString(this.existingTablePath)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

