/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Result of converting a single document page to a PNG thumbnail")
@JsonPropertyOrder(value={"Index", "Content"})
@JsonTypeName(value="Thumbnail")
public class Thumbnail {
    public static final String JSON_PROPERTY_INDEX = "Index";
    private Integer index;
    public static final String JSON_PROPERTY_CONTENT = "Content";
    private byte[] content;

    public Thumbnail index(Integer index) {
        this.index = index;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Index of this thumbnail")
    @JsonProperty(value="Index")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getIndex() {
        return this.index;
    }

    public void setIndex(Integer index) {
        this.index = index;
    }

    public Thumbnail content(byte[] content) {
        this.content = content;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A PNG thumbnail of the document page")
    @JsonProperty(value="Content")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public byte[] getContent() {
        return this.content;
    }

    public void setContent(byte[] content) {
        this.content = content;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Thumbnail thumbnail = (Thumbnail)o;
        return Objects.equals(this.index, thumbnail.index) && Arrays.equals(this.content, thumbnail.content);
    }

    public int hashCode() {
        return Objects.hash(this.index, Arrays.hashCode(this.content));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Thumbnail {\n");
        sb.append("    index: ").append(this.toIndentedString(this.index)).append("\n");
        sb.append("    content: ").append(this.toIndentedString(this.content)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

