/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="A single line of a Text document")
@JsonPropertyOrder(value={"LineNumber", "LineContents"})
@JsonTypeName(value="TextDocumentLine")
public class TextDocumentLine {
    public static final String JSON_PROPERTY_LINE_NUMBER = "LineNumber";
    private Integer lineNumber;
    public static final String JSON_PROPERTY_LINE_CONTENTS = "LineContents";
    private String lineContents;

    public TextDocumentLine lineNumber(Integer lineNumber) {
        this.lineNumber = lineNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The 1-based line index of the line")
    @JsonProperty(value="LineNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getLineNumber() {
        return this.lineNumber;
    }

    public void setLineNumber(Integer lineNumber) {
        this.lineNumber = lineNumber;
    }

    public TextDocumentLine lineContents(String lineContents) {
        this.lineContents = lineContents;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The text contents of a single line of a text file")
    @JsonProperty(value="LineContents")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLineContents() {
        return this.lineContents;
    }

    public void setLineContents(String lineContents) {
        this.lineContents = lineContents;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TextDocumentLine textDocumentLine = (TextDocumentLine)o;
        return Objects.equals(this.lineNumber, textDocumentLine.lineNumber) && Objects.equals(this.lineContents, textDocumentLine.lineContents);
    }

    public int hashCode() {
        return Objects.hash(this.lineNumber, this.lineContents);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TextDocumentLine {\n");
        sb.append("    lineNumber: ").append(this.toIndentedString(this.lineNumber)).append("\n");
        sb.append("    lineContents: ").append(this.toIndentedString(this.lineContents)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

