/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="A single element of a Text document")
@JsonPropertyOrder(value={"ElementNumber", "ElementContents"})
@JsonTypeName(value="TextDocumentElement")
public class TextDocumentElement {
    public static final String JSON_PROPERTY_ELEMENT_NUMBER = "ElementNumber";
    private Integer elementNumber;
    public static final String JSON_PROPERTY_ELEMENT_CONTENTS = "ElementContents";
    private String elementContents;

    public TextDocumentElement elementNumber(Integer elementNumber) {
        this.elementNumber = elementNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The 1-based line index of the element")
    @JsonProperty(value="ElementNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getElementNumber() {
        return this.elementNumber;
    }

    public void setElementNumber(Integer elementNumber) {
        this.elementNumber = elementNumber;
    }

    public TextDocumentElement elementContents(String elementContents) {
        this.elementContents = elementContents;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The text contents of a single element of a text file")
    @JsonProperty(value="ElementContents")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getElementContents() {
        return this.elementContents;
    }

    public void setElementContents(String elementContents) {
        this.elementContents = elementContents;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TextDocumentElement textDocumentElement = (TextDocumentElement)o;
        return Objects.equals(this.elementNumber, textDocumentElement.elementNumber) && Objects.equals(this.elementContents, textDocumentElement.elementContents);
    }

    public int hashCode() {
        return Objects.hash(this.elementNumber, this.elementContents);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TextDocumentElement {\n");
        sb.append("    elementNumber: ").append(this.toIndentedString(this.elementNumber)).append("\n");
        sb.append("    elementContents: ").append(this.toIndentedString(this.elementContents)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

