/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Text conversion result from converting a document to Plain Text (TXT) format")
@JsonPropertyOrder(value={"Successful", "TextResult"})
@JsonTypeName(value="TextConversionResult")
public class TextConversionResult {
    public static final String JSON_PROPERTY_SUCCESSFUL = "Successful";
    private Boolean successful;
    public static final String JSON_PROPERTY_TEXT_RESULT = "TextResult";
    private String textResult;

    public TextConversionResult successful(Boolean successful) {
        this.successful = successful;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="True if the operation was successful, false otherwise")
    @JsonProperty(value="Successful")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSuccessful() {
        return this.successful;
    }

    public void setSuccessful(Boolean successful) {
        this.successful = successful;
    }

    public TextConversionResult textResult(String textResult) {
        this.textResult = textResult;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Plain Text (TXT) format conversion result of the input document.  The text result is returned as a string.")
    @JsonProperty(value="TextResult")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTextResult() {
        return this.textResult;
    }

    public void setTextResult(String textResult) {
        this.textResult = textResult;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TextConversionResult textConversionResult = (TextConversionResult)o;
        return Objects.equals(this.successful, textConversionResult.successful) && Objects.equals(this.textResult, textConversionResult.textResult);
    }

    public int hashCode() {
        return Objects.hash(this.successful, this.textResult);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TextConversionResult {\n");
        sb.append("    successful: ").append(this.toIndentedString(this.successful)).append("\n");
        sb.append("    textResult: ").append(this.toIndentedString(this.textResult)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

