/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Re-use the output from a previously-completed task")
@JsonPropertyOrder(value={"TaskName", "TargetType"})
@JsonTypeName(value="TaskOutputReference")
public class TaskOutputReference {
    public static final String JSON_PROPERTY_TASK_NAME = "TaskName";
    private String taskName;
    public static final String JSON_PROPERTY_TARGET_TYPE = "TargetType";
    private String targetType;

    public TaskOutputReference taskName(String taskName) {
        this.taskName = taskName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Name of the task to use the output from")
    @JsonProperty(value="TaskName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTaskName() {
        return this.taskName;
    }

    public void setTaskName(String taskName) {
        this.taskName = taskName;
    }

    public TaskOutputReference targetType(String targetType) {
        this.targetType = targetType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Type to convert the output from the referenced task to; possible values are string, binary")
    @JsonProperty(value="TargetType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTargetType() {
        return this.targetType;
    }

    public void setTargetType(String targetType) {
        this.targetType = targetType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskOutputReference taskOutputReference = (TaskOutputReference)o;
        return Objects.equals(this.taskName, taskOutputReference.taskName) && Objects.equals(this.targetType, taskOutputReference.targetType);
    }

    public int hashCode() {
        return Objects.hash(this.taskName, this.targetType);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TaskOutputReference {\n");
        sb.append("    taskName: ").append(this.toIndentedString(this.taskName)).append("\n");
        sb.append("    targetType: ").append(this.toIndentedString(this.targetType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

