/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.cloudmersive.client.rt.model.StillFrame;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The result of converting a video into still frames")
@JsonPropertyOrder(value={"Successful", "TotalFrames", "StillFrames"})
@JsonTypeName(value="StillFramesResult")
public class StillFramesResult {
    public static final String JSON_PROPERTY_SUCCESSFUL = "Successful";
    private Boolean successful;
    public static final String JSON_PROPERTY_TOTAL_FRAMES = "TotalFrames";
    private Integer totalFrames;
    public static final String JSON_PROPERTY_STILL_FRAMES = "StillFrames";
    private List<StillFrame> stillFrames = null;

    public StillFramesResult successful(Boolean successful) {
        this.successful = successful;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="True if the operation was successful, false otherwise")
    @JsonProperty(value="Successful")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSuccessful() {
        return this.successful;
    }

    public void setSuccessful(Boolean successful) {
        this.successful = successful;
    }

    public StillFramesResult totalFrames(Integer totalFrames) {
        this.totalFrames = totalFrames;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The total number of frames converted")
    @JsonProperty(value="TotalFrames")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getTotalFrames() {
        return this.totalFrames;
    }

    public void setTotalFrames(Integer totalFrames) {
        this.totalFrames = totalFrames;
    }

    public StillFramesResult stillFrames(List<StillFrame> stillFrames) {
        this.stillFrames = stillFrames;
        return this;
    }

    public StillFramesResult addStillFramesItem(StillFrame stillFramesItem) {
        if (this.stillFrames == null) {
            this.stillFrames = new ArrayList<StillFrame>();
        }
        this.stillFrames.add(stillFramesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Individual still frames from the conversion operation")
    @JsonProperty(value="StillFrames")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<StillFrame> getStillFrames() {
        return this.stillFrames;
    }

    public void setStillFrames(List<StillFrame> stillFrames) {
        this.stillFrames = stillFrames;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StillFramesResult stillFramesResult = (StillFramesResult)o;
        return Objects.equals(this.successful, stillFramesResult.successful) && Objects.equals(this.totalFrames, stillFramesResult.totalFrames) && Objects.equals(this.stillFrames, stillFramesResult.stillFrames);
    }

    public int hashCode() {
        return Objects.hash(this.successful, this.totalFrames, this.stillFrames);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class StillFramesResult {\n");
        sb.append("    successful: ").append(this.toIndentedString(this.successful)).append("\n");
        sb.append("    totalFrames: ").append(this.toIndentedString(this.totalFrames)).append("\n");
        sb.append("    stillFrames: ").append(this.toIndentedString(this.stillFrames)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

