/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.cloudmersive.client.rt.model.VideoFile;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The result of splitting a video")
@JsonPropertyOrder(value={"Successful", "Videos"})
@JsonTypeName(value="SplitVideoResult")
public class SplitVideoResult {
    public static final String JSON_PROPERTY_SUCCESSFUL = "Successful";
    private Boolean successful;
    public static final String JSON_PROPERTY_VIDEOS = "Videos";
    private List<VideoFile> videos = null;

    public SplitVideoResult successful(Boolean successful) {
        this.successful = successful;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="True if the operation was successful, false otherwise")
    @JsonProperty(value="Successful")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSuccessful() {
        return this.successful;
    }

    public void setSuccessful(Boolean successful) {
        this.successful = successful;
    }

    public SplitVideoResult videos(List<VideoFile> videos) {
        this.videos = videos;
        return this;
    }

    public SplitVideoResult addVideosItem(VideoFile videosItem) {
        if (this.videos == null) {
            this.videos = new ArrayList<VideoFile>();
        }
        this.videos.add(videosItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Individual video files resulting from the split operation")
    @JsonProperty(value="Videos")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<VideoFile> getVideos() {
        return this.videos;
    }

    public void setVideos(List<VideoFile> videos) {
        this.videos = videos;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SplitVideoResult splitVideoResult = (SplitVideoResult)o;
        return Objects.equals(this.successful, splitVideoResult.successful) && Objects.equals(this.videos, splitVideoResult.videos);
    }

    public int hashCode() {
        return Objects.hash(this.successful, this.videos);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SplitVideoResult {\n");
        sb.append("    successful: ").append(this.toIndentedString(this.successful)).append("\n");
        sb.append("    videos: ").append(this.toIndentedString(this.videos)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

