/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="A single Word DOCX file corresponding to one page in the original document")
@JsonPropertyOrder(value={"PageNumber", "URL", "DocumentContents"})
@JsonTypeName(value="SplitDocumentResult")
public class SplitDocumentResult {
    public static final String JSON_PROPERTY_PAGE_NUMBER = "PageNumber";
    private Integer pageNumber;
    public static final String JSON_PROPERTY_U_R_L = "URL";
    private String URL;
    public static final String JSON_PROPERTY_DOCUMENT_CONTENTS = "DocumentContents";
    private byte[] documentContents;

    public SplitDocumentResult pageNumber(Integer pageNumber) {
        this.pageNumber = pageNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Page number of the converted page, starting with 1 for the first page")
    @JsonProperty(value="PageNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getPageNumber() {
        return this.pageNumber;
    }

    public void setPageNumber(Integer pageNumber) {
        this.pageNumber = pageNumber;
    }

    public SplitDocumentResult URL(String URL2) {
        this.URL = URL2;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="URL to the DOCX file of this slide; file is stored in an in-memory cache and will be deleted")
    @JsonProperty(value="URL")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getURL() {
        return this.URL;
    }

    public void setURL(String URL2) {
        this.URL = URL2;
    }

    public SplitDocumentResult documentContents(byte[] documentContents) {
        this.documentContents = documentContents;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Contents of the document in bytes")
    @JsonProperty(value="DocumentContents")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public byte[] getDocumentContents() {
        return this.documentContents;
    }

    public void setDocumentContents(byte[] documentContents) {
        this.documentContents = documentContents;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SplitDocumentResult splitDocumentResult = (SplitDocumentResult)o;
        return Objects.equals(this.pageNumber, splitDocumentResult.pageNumber) && Objects.equals(this.URL, splitDocumentResult.URL) && Arrays.equals(this.documentContents, splitDocumentResult.documentContents);
    }

    public int hashCode() {
        return Objects.hash(this.pageNumber, this.URL, Arrays.hashCode(this.documentContents));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SplitDocumentResult {\n");
        sb.append("    pageNumber: ").append(this.toIndentedString(this.pageNumber)).append("\n");
        sb.append("    URL: ").append(this.toIndentedString(this.URL)).append("\n");
        sb.append("    documentContents: ").append(this.toIndentedString(this.documentContents)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

