/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.cloudmersive.client.rt.model.XlsxSpreadsheetCell;
import com.cloudmersive.client.rt.model.XlsxWorksheet;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Input to a Set Cell by identifier in XLSX Worksheets request")
@JsonPropertyOrder(value={"InputFileBytes", "InputFileUrl", "WorksheetToUpdate", "CellIdentifier", "CellValue"})
@JsonTypeName(value="SetXlsxCellByIdentifierRequest")
public class SetXlsxCellByIdentifierRequest {
    public static final String JSON_PROPERTY_INPUT_FILE_BYTES = "InputFileBytes";
    private byte[] inputFileBytes;
    public static final String JSON_PROPERTY_INPUT_FILE_URL = "InputFileUrl";
    private String inputFileUrl;
    public static final String JSON_PROPERTY_WORKSHEET_TO_UPDATE = "WorksheetToUpdate";
    private XlsxWorksheet worksheetToUpdate;
    public static final String JSON_PROPERTY_CELL_IDENTIFIER = "CellIdentifier";
    private String cellIdentifier;
    public static final String JSON_PROPERTY_CELL_VALUE = "CellValue";
    private XlsxSpreadsheetCell cellValue;

    public SetXlsxCellByIdentifierRequest inputFileBytes(byte[] inputFileBytes) {
        this.inputFileBytes = inputFileBytes;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional: Bytes of the input file to operate on")
    @JsonProperty(value="InputFileBytes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public byte[] getInputFileBytes() {
        return this.inputFileBytes;
    }

    public void setInputFileBytes(byte[] inputFileBytes) {
        this.inputFileBytes = inputFileBytes;
    }

    public SetXlsxCellByIdentifierRequest inputFileUrl(String inputFileUrl) {
        this.inputFileUrl = inputFileUrl;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional: URL of a file to operate on as input.  This can be a public URL, or you can also use the begin-editing API to upload a document and pass in the secure URL result from that operation as the URL here (this URL is not public).")
    @JsonProperty(value="InputFileUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getInputFileUrl() {
        return this.inputFileUrl;
    }

    public void setInputFileUrl(String inputFileUrl) {
        this.inputFileUrl = inputFileUrl;
    }

    public SetXlsxCellByIdentifierRequest worksheetToUpdate(XlsxWorksheet worksheetToUpdate) {
        this.worksheetToUpdate = worksheetToUpdate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="WorksheetToUpdate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public XlsxWorksheet getWorksheetToUpdate() {
        return this.worksheetToUpdate;
    }

    public void setWorksheetToUpdate(XlsxWorksheet worksheetToUpdate) {
        this.worksheetToUpdate = worksheetToUpdate;
    }

    public SetXlsxCellByIdentifierRequest cellIdentifier(String cellIdentifier) {
        this.cellIdentifier = cellIdentifier;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The Excel cell identifier (e.g. A1, B2, C33, etc.) of the cell to update")
    @JsonProperty(value="CellIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCellIdentifier() {
        return this.cellIdentifier;
    }

    public void setCellIdentifier(String cellIdentifier) {
        this.cellIdentifier = cellIdentifier;
    }

    public SetXlsxCellByIdentifierRequest cellValue(XlsxSpreadsheetCell cellValue) {
        this.cellValue = cellValue;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="CellValue")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public XlsxSpreadsheetCell getCellValue() {
        return this.cellValue;
    }

    public void setCellValue(XlsxSpreadsheetCell cellValue) {
        this.cellValue = cellValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SetXlsxCellByIdentifierRequest setXlsxCellByIdentifierRequest = (SetXlsxCellByIdentifierRequest)o;
        return Arrays.equals(this.inputFileBytes, setXlsxCellByIdentifierRequest.inputFileBytes) && Objects.equals(this.inputFileUrl, setXlsxCellByIdentifierRequest.inputFileUrl) && Objects.equals(this.worksheetToUpdate, setXlsxCellByIdentifierRequest.worksheetToUpdate) && Objects.equals(this.cellIdentifier, setXlsxCellByIdentifierRequest.cellIdentifier) && Objects.equals(this.cellValue, setXlsxCellByIdentifierRequest.cellValue);
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.inputFileBytes), this.inputFileUrl, this.worksheetToUpdate, this.cellIdentifier, this.cellValue);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SetXlsxCellByIdentifierRequest {\n");
        sb.append("    inputFileBytes: ").append(this.toIndentedString(this.inputFileBytes)).append("\n");
        sb.append("    inputFileUrl: ").append(this.toIndentedString(this.inputFileUrl)).append("\n");
        sb.append("    worksheetToUpdate: ").append(this.toIndentedString(this.worksheetToUpdate)).append("\n");
        sb.append("    cellIdentifier: ").append(this.toIndentedString(this.cellIdentifier)).append("\n");
        sb.append("    cellValue: ").append(this.toIndentedString(this.cellValue)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

