/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Output of a sentiment analysis operation")
@JsonPropertyOrder(value={"Successful", "SentimentClassificationResult", "SentimentScoreResult", "SentenceCount"})
@JsonTypeName(value="SentimentAnalysisResponse")
public class SentimentAnalysisResponse {
    public static final String JSON_PROPERTY_SUCCESSFUL = "Successful";
    private Boolean successful;
    public static final String JSON_PROPERTY_SENTIMENT_CLASSIFICATION_RESULT = "SentimentClassificationResult";
    private String sentimentClassificationResult;
    public static final String JSON_PROPERTY_SENTIMENT_SCORE_RESULT = "SentimentScoreResult";
    private Double sentimentScoreResult;
    public static final String JSON_PROPERTY_SENTENCE_COUNT = "SentenceCount";
    private Integer sentenceCount;

    public SentimentAnalysisResponse successful(Boolean successful) {
        this.successful = successful;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="True if the sentiment analysis operation was successful, false otherwise")
    @JsonProperty(value="Successful")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSuccessful() {
        return this.successful;
    }

    public void setSuccessful(Boolean successful) {
        this.successful = successful;
    }

    public SentimentAnalysisResponse sentimentClassificationResult(String sentimentClassificationResult) {
        this.sentimentClassificationResult = sentimentClassificationResult;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Classification of input text into a sentiment classification; possible values are \"Positive\", \"Negative\" or \"Neutral\"")
    @JsonProperty(value="SentimentClassificationResult")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSentimentClassificationResult() {
        return this.sentimentClassificationResult;
    }

    public void setSentimentClassificationResult(String sentimentClassificationResult) {
        this.sentimentClassificationResult = sentimentClassificationResult;
    }

    public SentimentAnalysisResponse sentimentScoreResult(Double sentimentScoreResult) {
        this.sentimentScoreResult = sentimentScoreResult;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Sentiment classification score between -1.0 and +1.0 where scores less than 0 are negative sentiment, scores greater than 0 are positive sentiment and scores close to 0 are neutral.  The greater the value deviates from 0.0 the stronger the sentiment, with +1.0 and -1.0 being maximum positive and negative sentiment, respectively.")
    @JsonProperty(value="SentimentScoreResult")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getSentimentScoreResult() {
        return this.sentimentScoreResult;
    }

    public void setSentimentScoreResult(Double sentimentScoreResult) {
        this.sentimentScoreResult = sentimentScoreResult;
    }

    public SentimentAnalysisResponse sentenceCount(Integer sentenceCount) {
        this.sentenceCount = sentenceCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Number of sentences in input text")
    @JsonProperty(value="SentenceCount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getSentenceCount() {
        return this.sentenceCount;
    }

    public void setSentenceCount(Integer sentenceCount) {
        this.sentenceCount = sentenceCount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SentimentAnalysisResponse sentimentAnalysisResponse = (SentimentAnalysisResponse)o;
        return Objects.equals(this.successful, sentimentAnalysisResponse.successful) && Objects.equals(this.sentimentClassificationResult, sentimentAnalysisResponse.sentimentClassificationResult) && Objects.equals(this.sentimentScoreResult, sentimentAnalysisResponse.sentimentScoreResult) && Objects.equals(this.sentenceCount, sentimentAnalysisResponse.sentenceCount);
    }

    public int hashCode() {
        return Objects.hash(this.successful, this.sentimentClassificationResult, this.sentimentScoreResult, this.sentenceCount);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SentimentAnalysisResponse {\n");
        sb.append("    successful: ").append(this.toIndentedString(this.successful)).append("\n");
        sb.append("    sentimentClassificationResult: ").append(this.toIndentedString(this.sentimentClassificationResult)).append("\n");
        sb.append("    sentimentScoreResult: ").append(this.toIndentedString(this.sentimentScoreResult)).append("\n");
        sb.append("    sentenceCount: ").append(this.toIndentedString(this.sentenceCount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

