/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Input to a string replacement request")
@JsonPropertyOrder(value={"InputFileBytes", "InputFileUrl", "MatchString", "ReplaceString", "MatchCase"})
@JsonTypeName(value="ReplaceStringRequest")
public class ReplaceStringRequest {
    public static final String JSON_PROPERTY_INPUT_FILE_BYTES = "InputFileBytes";
    private byte[] inputFileBytes;
    public static final String JSON_PROPERTY_INPUT_FILE_URL = "InputFileUrl";
    private String inputFileUrl;
    public static final String JSON_PROPERTY_MATCH_STRING = "MatchString";
    private String matchString;
    public static final String JSON_PROPERTY_REPLACE_STRING = "ReplaceString";
    private String replaceString;
    public static final String JSON_PROPERTY_MATCH_CASE = "MatchCase";
    private Boolean matchCase;

    public ReplaceStringRequest inputFileBytes(byte[] inputFileBytes) {
        this.inputFileBytes = inputFileBytes;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional: Bytes of the input file to operate on")
    @JsonProperty(value="InputFileBytes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public byte[] getInputFileBytes() {
        return this.inputFileBytes;
    }

    public void setInputFileBytes(byte[] inputFileBytes) {
        this.inputFileBytes = inputFileBytes;
    }

    public ReplaceStringRequest inputFileUrl(String inputFileUrl) {
        this.inputFileUrl = inputFileUrl;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional: URL of a file to operate on as input.  This can be a public URL, or you can also use the begin-editing API to upload a document and pass in the secure URL result from that operation as the URL here (this URL is not public).")
    @JsonProperty(value="InputFileUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getInputFileUrl() {
        return this.inputFileUrl;
    }

    public void setInputFileUrl(String inputFileUrl) {
        this.inputFileUrl = inputFileUrl;
    }

    public ReplaceStringRequest matchString(String matchString) {
        this.matchString = matchString;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="String to search for and match against, to be replaced")
    @JsonProperty(value="MatchString")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMatchString() {
        return this.matchString;
    }

    public void setMatchString(String matchString) {
        this.matchString = matchString;
    }

    public ReplaceStringRequest replaceString(String replaceString) {
        this.replaceString = replaceString;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="String to replace the matched values with")
    @JsonProperty(value="ReplaceString")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReplaceString() {
        return this.replaceString;
    }

    public void setReplaceString(String replaceString) {
        this.replaceString = replaceString;
    }

    public ReplaceStringRequest matchCase(Boolean matchCase) {
        this.matchCase = matchCase;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="True if the case should be matched, false for case insensitive match")
    @JsonProperty(value="MatchCase")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getMatchCase() {
        return this.matchCase;
    }

    public void setMatchCase(Boolean matchCase) {
        this.matchCase = matchCase;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReplaceStringRequest replaceStringRequest = (ReplaceStringRequest)o;
        return Arrays.equals(this.inputFileBytes, replaceStringRequest.inputFileBytes) && Objects.equals(this.inputFileUrl, replaceStringRequest.inputFileUrl) && Objects.equals(this.matchString, replaceStringRequest.matchString) && Objects.equals(this.replaceString, replaceStringRequest.replaceString) && Objects.equals(this.matchCase, replaceStringRequest.matchCase);
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.inputFileBytes), this.inputFileUrl, this.matchString, this.replaceString, this.matchCase);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ReplaceStringRequest {\n");
        sb.append("    inputFileBytes: ").append(this.toIndentedString(this.inputFileBytes)).append("\n");
        sb.append("    inputFileUrl: ").append(this.toIndentedString(this.inputFileUrl)).append("\n");
        sb.append("    matchString: ").append(this.toIndentedString(this.matchString)).append("\n");
        sb.append("    replaceString: ").append(this.toIndentedString(this.replaceString)).append("\n");
        sb.append("    matchCase: ").append(this.toIndentedString(this.matchCase)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

