/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.cloudmersive.client.rt.model.DocxImage;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Input to a request to replace matching paragraphs in a Word DOCX document")
@JsonPropertyOrder(value={"InputFileBytes", "InputFileUrl", "FindString", "MatchCase", "Replacement_Image"})
@JsonTypeName(value="ReplaceDocxParagraphRequest")
public class ReplaceDocxParagraphRequest {
    public static final String JSON_PROPERTY_INPUT_FILE_BYTES = "InputFileBytes";
    private byte[] inputFileBytes;
    public static final String JSON_PROPERTY_INPUT_FILE_URL = "InputFileUrl";
    private String inputFileUrl;
    public static final String JSON_PROPERTY_FIND_STRING = "FindString";
    private String findString;
    public static final String JSON_PROPERTY_MATCH_CASE = "MatchCase";
    private Boolean matchCase;
    public static final String JSON_PROPERTY_REPLACEMENT_IMAGE = "Replacement_Image";
    private DocxImage replacementImage;

    public ReplaceDocxParagraphRequest inputFileBytes(byte[] inputFileBytes) {
        this.inputFileBytes = inputFileBytes;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional: Bytes of the input file to operate on")
    @JsonProperty(value="InputFileBytes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public byte[] getInputFileBytes() {
        return this.inputFileBytes;
    }

    public void setInputFileBytes(byte[] inputFileBytes) {
        this.inputFileBytes = inputFileBytes;
    }

    public ReplaceDocxParagraphRequest inputFileUrl(String inputFileUrl) {
        this.inputFileUrl = inputFileUrl;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional: URL of a file to operate on as input.  This can be a public URL, or you can also use the begin-editing API to upload a document and pass in the secure URL result from that operation as the URL here (this URL is not public).")
    @JsonProperty(value="InputFileUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getInputFileUrl() {
        return this.inputFileUrl;
    }

    public void setInputFileUrl(String inputFileUrl) {
        this.inputFileUrl = inputFileUrl;
    }

    public ReplaceDocxParagraphRequest findString(String findString) {
        this.findString = findString;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Required: The target string to search for in the paragraphs of the document")
    @JsonProperty(value="FindString")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFindString() {
        return this.findString;
    }

    public void setFindString(String findString) {
        this.findString = findString;
    }

    public ReplaceDocxParagraphRequest matchCase(Boolean matchCase) {
        this.matchCase = matchCase;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional: True to match case, false to ignore case when matching")
    @JsonProperty(value="MatchCase")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getMatchCase() {
        return this.matchCase;
    }

    public void setMatchCase(Boolean matchCase) {
        this.matchCase = matchCase;
    }

    public ReplaceDocxParagraphRequest replacementImage(DocxImage replacementImage) {
        this.replacementImage = replacementImage;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="Replacement_Image")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public DocxImage getReplacementImage() {
        return this.replacementImage;
    }

    public void setReplacementImage(DocxImage replacementImage) {
        this.replacementImage = replacementImage;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReplaceDocxParagraphRequest replaceDocxParagraphRequest = (ReplaceDocxParagraphRequest)o;
        return Arrays.equals(this.inputFileBytes, replaceDocxParagraphRequest.inputFileBytes) && Objects.equals(this.inputFileUrl, replaceDocxParagraphRequest.inputFileUrl) && Objects.equals(this.findString, replaceDocxParagraphRequest.findString) && Objects.equals(this.matchCase, replaceDocxParagraphRequest.matchCase) && Objects.equals(this.replacementImage, replaceDocxParagraphRequest.replacementImage);
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.inputFileBytes), this.inputFileUrl, this.findString, this.matchCase, this.replacementImage);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ReplaceDocxParagraphRequest {\n");
        sb.append("    inputFileBytes: ").append(this.toIndentedString(this.inputFileBytes)).append("\n");
        sb.append("    inputFileUrl: ").append(this.toIndentedString(this.inputFileUrl)).append("\n");
        sb.append("    findString: ").append(this.toIndentedString(this.findString)).append("\n");
        sb.append("    matchCase: ").append(this.toIndentedString(this.matchCase)).append("\n");
        sb.append("    replacementImage: ").append(this.toIndentedString(this.replacementImage)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

