/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.cloudmersive.client.rt.model.RephrasedSentenceOption;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="One input sentence and associated rephrasing results")
@JsonPropertyOrder(value={"SentenceIndex", "OriginalSentenceText", "Rephrasings"})
@JsonTypeName(value="RephrasedSentence")
public class RephrasedSentence {
    public static final String JSON_PROPERTY_SENTENCE_INDEX = "SentenceIndex";
    private Integer sentenceIndex;
    public static final String JSON_PROPERTY_ORIGINAL_SENTENCE_TEXT = "OriginalSentenceText";
    private String originalSentenceText;
    public static final String JSON_PROPERTY_REPHRASINGS = "Rephrasings";
    private List<RephrasedSentenceOption> rephrasings = null;

    public RephrasedSentence sentenceIndex(Integer sentenceIndex) {
        this.sentenceIndex = sentenceIndex;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Index of the sentence, 1-based, ordered")
    @JsonProperty(value="SentenceIndex")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getSentenceIndex() {
        return this.sentenceIndex;
    }

    public void setSentenceIndex(Integer sentenceIndex) {
        this.sentenceIndex = sentenceIndex;
    }

    public RephrasedSentence originalSentenceText(String originalSentenceText) {
        this.originalSentenceText = originalSentenceText;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Original input sentence text")
    @JsonProperty(value="OriginalSentenceText")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getOriginalSentenceText() {
        return this.originalSentenceText;
    }

    public void setOriginalSentenceText(String originalSentenceText) {
        this.originalSentenceText = originalSentenceText;
    }

    public RephrasedSentence rephrasings(List<RephrasedSentenceOption> rephrasings) {
        this.rephrasings = rephrasings;
        return this;
    }

    public RephrasedSentence addRephrasingsItem(RephrasedSentenceOption rephrasingsItem) {
        if (this.rephrasings == null) {
            this.rephrasings = new ArrayList<RephrasedSentenceOption>();
        }
        this.rephrasings.add(rephrasingsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Rephrasing text options, candidates of the original input sentence, in order - with best candidate first")
    @JsonProperty(value="Rephrasings")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<RephrasedSentenceOption> getRephrasings() {
        return this.rephrasings;
    }

    public void setRephrasings(List<RephrasedSentenceOption> rephrasings) {
        this.rephrasings = rephrasings;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RephrasedSentence rephrasedSentence = (RephrasedSentence)o;
        return Objects.equals(this.sentenceIndex, rephrasedSentence.sentenceIndex) && Objects.equals(this.originalSentenceText, rephrasedSentence.originalSentenceText) && Objects.equals(this.rephrasings, rephrasedSentence.rephrasings);
    }

    public int hashCode() {
        return Objects.hash(this.sentenceIndex, this.originalSentenceText, this.rephrasings);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RephrasedSentence {\n");
        sb.append("    sentenceIndex: ").append(this.toIndentedString(this.sentenceIndex)).append("\n");
        sb.append("    originalSentenceText: ").append(this.toIndentedString(this.originalSentenceText)).append("\n");
        sb.append("    rephrasings: ").append(this.toIndentedString(this.rephrasings)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

